/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.rift.targets;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrarManager;
import dev.architectury.registry.registries.RegistrySupplier;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.ResourceLocation;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.api.rift.target.Target;
import org.dimdev.dimdoors.api.util.Location;
import org.dimdev.dimdoors.api.util.RGBA;
import org.dimdev.dimdoors.rift.targets.DungeonTarget;
import org.dimdev.dimdoors.rift.targets.EscapeTarget;
import org.dimdev.dimdoors.rift.targets.GlobalReference;
import org.dimdev.dimdoors.rift.targets.IdMarker;
import org.dimdev.dimdoors.rift.targets.LimboTarget;
import org.dimdev.dimdoors.rift.targets.LocalReference;
import org.dimdev.dimdoors.rift.targets.PocketEntranceMarker;
import org.dimdev.dimdoors.rift.targets.PocketExitMarker;
import org.dimdev.dimdoors.rift.targets.PrivatePocketExitTarget;
import org.dimdev.dimdoors.rift.targets.PrivatePocketTarget;
import org.dimdev.dimdoors.rift.targets.PublicPocketTarget;
import org.dimdev.dimdoors.rift.targets.RandomTarget;
import org.dimdev.dimdoors.rift.targets.RelativeReference;
import org.dimdev.dimdoors.rift.targets.TemplateTarget;
import org.dimdev.dimdoors.rift.targets.UnstableTarget;
import org.slf4j.Logger;

public abstract class VirtualTarget
implements Target {
    public static final Codec<VirtualTarget> CODEC = VirtualTargetType.CODEC.dispatch("type", VirtualTarget::getType, VirtualTargetType::codec);
    public static final RGBA COLOR = new RGBA(1.0f, 0.0f, 0.0f, 1.0f);
    protected Location location;

    public static VirtualTarget fromNbt(CompoundTag nbt) {
        return (VirtualTarget)((Pair)CODEC.decode((DynamicOps)NbtOps.f_128958_, (Object)nbt).getOrThrow(false, arg_0 -> ((Logger)DimensionalDoors.LOGGER).error(arg_0))).getFirst();
    }

    public static <T extends VirtualTarget> CompoundTag toNbt(T virtualTarget) {
        CompoundTag data = (CompoundTag)virtualTarget.getType().codec().encode(virtualTarget, (DynamicOps)NbtOps.f_128958_, (Object)new CompoundTag()).getOrThrow(false, arg_0 -> ((Logger)DimensionalDoors.LOGGER).error(arg_0));
        data.m_128359_("type", virtualTarget.getType().getId().toString());
        return data;
    }

    public void register() {
    }

    public void unregister() {
    }

    public abstract <T extends VirtualTarget> VirtualTargetType<T> getType();

    public boolean shouldInvalidate(Location riftDeleted) {
        return false;
    }

    public RGBA getColor() {
        return this.getType().getColor();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VirtualTarget that = (VirtualTarget)o;
        return Objects.equals(this.location, that.location);
    }

    public int hashCode() {
        return Objects.hash(this.location);
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public Location getLocation() {
        return this.location;
    }

    public boolean isDummy() {
        return false;
    }

    public abstract VirtualTarget copy();

    public static interface VirtualTargetType<T extends VirtualTarget> {
        public static final Registrar<VirtualTargetType<?>> REGISTRY = RegistrarManager.get((String)"dimdoors").builder(DimensionalDoors.id("virtual_type"), (Object[])new VirtualTargetType[0]).build();
        public static final Codec<VirtualTargetType<?>> CODEC = ResourceLocation.f_135803_.xmap(arg_0 -> REGISTRY.get(arg_0), arg_0 -> REGISTRY.getId(arg_0));
        public static final RegistrySupplier<VirtualTargetType<RandomTarget>> AVAILABLE_LINK = VirtualTargetType.register("dimdoors:available_link", RandomTarget.CODEC);
        public static final RegistrySupplier<VirtualTargetType<DungeonTarget>> DUNGEON = VirtualTargetType.register("dimdoors:dungeon", DungeonTarget.CODEC);
        public static final RegistrySupplier<VirtualTargetType<TemplateTarget>> TEMPLATE = VirtualTargetType.register("dimdoors:template", TemplateTarget.CODEC);
        public static final RegistrySupplier<VirtualTargetType<EscapeTarget>> ESCAPE = VirtualTargetType.register("dimdoors:escape", EscapeTarget.CODEC);
        public static final RegistrySupplier<VirtualTargetType<GlobalReference>> GLOBAL = VirtualTargetType.register("dimdoors:global", GlobalReference.CODEC);
        public static final RegistrySupplier<VirtualTargetType<LimboTarget>> LIMBO = VirtualTargetType.register("dimdoors:limbo", LimboTarget.INSTANCE);
        public static final RegistrySupplier<VirtualTargetType<LocalReference>> LOCAL = VirtualTargetType.register("dimdoors:local", LocalReference.CODEC);
        public static final RegistrySupplier<VirtualTargetType<PublicPocketTarget>> PUBLIC_POCKET = VirtualTargetType.register("dimdoors:public_pocket", PublicPocketTarget.CODEC);
        public static final RegistrySupplier<VirtualTargetType<PocketEntranceMarker>> POCKET_ENTRANCE = VirtualTargetType.register("dimdoors:pocket_entrance", PocketEntranceMarker.CODEC);
        public static final RegistrySupplier<VirtualTargetType<PocketExitMarker>> POCKET_EXIT = VirtualTargetType.register("dimdoors:pocket_exit", COLOR, PocketExitMarker.INSTANCE);
        public static final RegistrySupplier<VirtualTargetType<PrivatePocketTarget>> PRIVATE = VirtualTargetType.register("dimdoors:private", PrivatePocketExitTarget.COLOR, PrivatePocketTarget.INSTANCE);
        public static final RegistrySupplier<VirtualTargetType<PrivatePocketExitTarget>> PRIVATE_POCKET_EXIT = VirtualTargetType.register("dimdoors:private_pocket_exit", PrivatePocketExitTarget.COLOR, PrivatePocketExitTarget.INSTANCE);
        public static final RegistrySupplier<VirtualTargetType<RelativeReference>> RELATIVE = VirtualTargetType.register("dimdoors:relative", RelativeReference.CODEC);
        public static final RegistrySupplier<VirtualTargetType<IdMarker>> ID_MARKER = VirtualTargetType.register("dimdoors:id_marker", IdMarker.CODEC);
        public static final RegistrySupplier<VirtualTargetType<UnstableTarget>> UNSTABLE = VirtualTargetType.register("dimdoors:unstable", UnstableTarget.INSTANCE);
        public static final RegistrySupplier<VirtualTargetType<NoneTarget>> NONE = VirtualTargetType.register("dimdoors:none", NoneTarget.INSTANCE);
        public static final Map<VirtualTargetType<?>, String> TRANSLATION_KEYS = new Object2ObjectArrayMap();

        public Codec<T> codec();

        public RGBA getColor();

        default public ResourceLocation getId() {
            return REGISTRY.getId((Object)this);
        }

        default public String getTranslationKey() {
            return TRANSLATION_KEYS.computeIfAbsent(this, t -> {
                ResourceLocation id = t.getId();
                return "dimdoors.virtualTarget." + id.m_135827_() + "." + id.m_135815_();
            });
        }

        public static void register() {
        }

        public static <T extends VirtualTarget> RegistrySupplier<VirtualTargetType<T>> register(String id, T instance) {
            return VirtualTargetType.register(id, COLOR, instance);
        }

        public static <T extends VirtualTarget> RegistrySupplier<VirtualTargetType<T>> register(String id, RGBA color, T instance) {
            return VirtualTargetType.register(id, Codec.unit(instance), color);
        }

        public static <T extends VirtualTarget> RegistrySupplier<VirtualTargetType<T>> register(String id, Codec<T> codec) {
            return VirtualTargetType.register(id, codec, COLOR);
        }

        public static <T extends VirtualTarget> RegistrySupplier<VirtualTargetType<T>> register(String id, final Codec<T> codec, final RGBA color) {
            return REGISTRY.register(new ResourceLocation(id), () -> new VirtualTargetType<T>(){

                @Override
                public Codec<T> codec() {
                    return codec;
                }

                @Override
                public RGBA getColor() {
                    return color;
                }
            });
        }
    }

    public static class NoneTarget
    extends VirtualTarget {
        public static final NoneTarget INSTANCE = new NoneTarget();

        private NoneTarget() {
        }

        public VirtualTargetType<? extends VirtualTarget> getType() {
            return (VirtualTargetType)VirtualTargetType.NONE.get();
        }

        @Override
        public boolean equals(Object o) {
            return o == INSTANCE;
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(INSTANCE);
        }

        @Override
        public VirtualTarget copy() {
            return INSTANCE;
        }

        public String toString() {
            return "[none]";
        }
    }
}

