/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.rift.registry;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import org.dimdev.dimdoors.rift.registry.RegistryVertex;

public class PlayerRiftPointer
extends RegistryVertex {
    public static final Codec<PlayerRiftPointer> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)UUIDUtil.f_235867_.fieldOf("id").forGetter(a -> a.id), (App)UUIDUtil.f_235867_.fieldOf("player").forGetter(a -> a.player)).apply((Applicative)instance, (id, player) -> {
        PlayerRiftPointer pointer = new PlayerRiftPointer((UUID)player);
        pointer.id = id;
        return pointer;
    }));
    private final UUID player;

    public PlayerRiftPointer(UUID player) {
        this.player = player;
    }

    @Override
    public RegistryVertex.RegistryVertexType<? extends RegistryVertex> getType() {
        return (RegistryVertex.RegistryVertexType)RegistryVertex.RegistryVertexType.PLAYER.get();
    }

    @Override
    public String toString() {
        return "PlayerRiftPointer(player=" + String.valueOf(this.player) + ")";
    }

    public static CompoundTag toNbt(PlayerRiftPointer vertex) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128362_("id", vertex.id);
        nbt.m_128362_("player", vertex.player);
        return nbt;
    }

    public static PlayerRiftPointer fromNbt(CompoundTag nbt) {
        return new PlayerRiftPointer(nbt.m_128342_("id"));
    }

    public UUID getPlayer() {
        return this.player;
    }
}

