/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.pockets.generator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.api.util.BlockPlacementType;
import org.dimdev.dimdoors.api.util.Path;
import org.dimdev.dimdoors.block.entity.RiftBlockEntity;
import org.dimdev.dimdoors.command.PocketCommand;
import org.dimdev.dimdoors.pockets.PocketGenerationContext;
import org.dimdev.dimdoors.pockets.PocketLoader;
import org.dimdev.dimdoors.pockets.PocketTemplate;
import org.dimdev.dimdoors.pockets.generator.LazyPocketGenerator;
import org.dimdev.dimdoors.pockets.generator.PocketGenerator;
import org.dimdev.dimdoors.pockets.modifier.AbsoluteRiftBlockEntityModifier;
import org.dimdev.dimdoors.pockets.modifier.RiftManager;
import org.dimdev.dimdoors.util.schematic.Schematic;
import org.dimdev.dimdoors.world.level.registry.DimensionalRegistry;
import org.dimdev.dimdoors.world.pocket.type.LazyGenerationPocket;
import org.dimdev.dimdoors.world.pocket.type.Pocket;

public class SchematicGenerator
extends LazyPocketGenerator {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String KEY = "schematic";
    private String id;
    private ResourceLocation templateID;
    private BlockPlacementType placementType = BlockPlacementType.SECTION_NO_UPDATE;
    private final List<RiftBlockEntity> rifts = new ArrayList<RiftBlockEntity>();
    private BlockPos origin;
    private AbsoluteRiftBlockEntityModifier queuedRiftBlockEntities;

    public SchematicGenerator() {
    }

    public SchematicGenerator(String id) {
        this.id = id;
        this.templateID = DimensionalDoors.id(id);
    }

    public String getId() {
        return this.id;
    }

    public ResourceLocation getTemplateID() {
        return this.templateID;
    }

    @Override
    public void generateChunk(LazyGenerationPocket pocket, LevelChunk chunk) {
        PocketTemplate template = PocketLoader.getInstance().getTemplates().get(Path.stringPath(this.templateID));
        if (template == null) {
            throw new RuntimeException("Pocket template of id " + String.valueOf(this.templateID) + " not found!");
        }
        template.place(pocket, (ChunkAccess)chunk, this.origin, this.placementType);
        this.setupChunk(pocket, (ChunkAccess)chunk, this.isSetupLoot());
        super.generateChunk(pocket, chunk);
    }

    @Override
    public PocketGenerator fromNbt(CompoundTag nbt, ResourceManager manager) {
        super.fromNbt(nbt, manager);
        this.id = nbt.m_128461_("id");
        this.templateID = DimensionalDoors.id(this.id);
        if (nbt.m_128425_("origin", 11)) {
            int[] originInts = nbt.m_128465_("origin");
            this.origin = new BlockPos(originInts[0], originInts[1], originInts[2]);
        }
        if (nbt.m_128425_("placement_type", 8)) {
            this.placementType = BlockPlacementType.getFromId(nbt.m_128461_("placement_type"));
        }
        return this;
    }

    @Override
    public CompoundTag toNbtInternal(CompoundTag nbt, boolean allowReference) {
        super.toNbtInternal(nbt, allowReference);
        nbt.m_128359_("id", this.id);
        if (this.placementType != BlockPlacementType.SECTION_NO_UPDATE) {
            nbt.m_128359_("placement_type", this.placementType.getId());
        }
        if (this.origin != null) {
            nbt.m_128385_("origin", new int[]{this.origin.m_123341_(), this.origin.m_123342_(), this.origin.m_123343_()});
        }
        return nbt;
    }

    @Override
    public RiftManager getRiftManager(Pocket pocket) {
        RiftManager manager = super.getRiftManager(pocket);
        this.rifts.forEach(manager::add);
        return manager;
    }

    @Override
    public LazyPocketGenerator cloneWithLazyModifiers(BlockPos originalOrigin) {
        LazyPocketGenerator generator = super.cloneWithLazyModifiers(originalOrigin);
        generator.lazyModifierList.add(0, this.queuedRiftBlockEntities);
        return generator;
    }

    @Override
    public LazyPocketGenerator cloneWithEmptyModifiers(BlockPos originalOrigin) {
        SchematicGenerator generator = (SchematicGenerator)super.cloneWithEmptyModifiers(originalOrigin);
        generator.id = this.id;
        generator.templateID = this.templateID;
        generator.origin = originalOrigin;
        return generator;
    }

    @Override
    public LazyPocketGenerator getNewInstance() {
        return new SchematicGenerator();
    }

    @Override
    public Pocket prepareAndPlacePocket(PocketGenerationContext parameters, Pocket.PocketBuilder<?, ?> builder) {
        ServerLevel world = parameters.world();
        Map<String, Double> variableMap = parameters.toVariableMap(new HashMap<String, Double>());
        PocketTemplate template = PocketLoader.getInstance().getTemplates().get(Path.stringPath(this.templateID));
        if (template == null) {
            throw new RuntimeException("Pocket template of id " + String.valueOf(this.templateID) + " not found!");
        }
        Object pocket = DimensionalRegistry.getPocketDirectory((ResourceKey<Level>)world.m_46472_()).newPocket(builder);
        BlockPos origin = ((Pocket)pocket).getOrigin();
        LOGGER.info("Generating pocket from template " + String.valueOf(this.templateID) + " at location " + String.valueOf(origin));
        PocketCommand.logSetting.values().forEach(commandSource -> commandSource.m_288197_(() -> Component.m_237110_((String)"commands.pocket.log.creation.generating", (Object[])new Object[]{this.templateID, origin.m_123341_(), origin.m_123342_(), origin.m_123343_()}), false));
        if (pocket instanceof LazyGenerationPocket) {
            Map<BlockPos, RiftBlockEntity> absoluteRifts = template.getAbsoluteRifts((Pocket)pocket);
            this.rifts.addAll(absoluteRifts.values());
            this.queuedRiftBlockEntities = new AbsoluteRiftBlockEntityModifier(absoluteRifts);
        } else {
            template.place((Pocket)pocket, this.placementType);
        }
        return pocket;
    }

    @Override
    public PocketGenerator.PocketGeneratorType<? extends PocketGenerator> getType() {
        return (PocketGenerator.PocketGeneratorType)PocketGenerator.PocketGeneratorType.SCHEMATIC.get();
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public Vec3i getSize(PocketGenerationContext parameters) {
        PocketTemplate template = PocketLoader.getInstance().getTemplates().get(Path.stringPath(this.templateID));
        if (template == null) {
            throw new RuntimeException("Pocket template of id " + String.valueOf(this.templateID) + " not found!");
        }
        Schematic schem = template.getSchematic();
        return new Vec3i((int)schem.getWidth(), (int)schem.getHeight(), (int)schem.getLength());
    }
}

