/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.item;

import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.block.DimensionalPortalBlock;
import org.dimdev.dimdoors.block.ModBlocks;
import org.dimdev.dimdoors.block.entity.EntranceRiftBlockEntity;
import org.dimdev.dimdoors.block.entity.RiftBlockEntity;
import org.dimdev.dimdoors.client.ToolTipHelper;
import org.dimdev.dimdoors.item.ModItems;
import org.dimdev.dimdoors.item.RaycastHelper;
import org.jetbrains.annotations.Nullable;

public class RiftBladeItem
extends SwordItem {
    public static final String ID = "rift_blade";

    public RiftBladeItem(Item.Properties settings) {
        super((Tier)Tiers.IRON, 3, -2.4f, settings);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> list, TooltipFlag tooltipFlag) {
        ToolTipHelper.processTranslation(list, this.m_5524_() + ".info", new Object[0]);
    }

    public boolean m_5812_(ItemStack itemStack) {
        return true;
    }

    public boolean m_6832_(ItemStack item, ItemStack repairingItem) {
        return Objects.equals(ModItems.STABLE_FABRIC.get(), repairingItem.m_41720_());
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        HitResult hit;
        ItemStack stack;
        block10: {
            block9: {
                stack = player.m_21120_(hand);
                hit = RaycastHelper.raycast(player, 0.0f, LivingEntity.class::isInstance);
                if (hit == null) break block9;
                if (hit.m_6662_() != HitResult.Type.MISS) break block10;
            }
            hit = RaycastHelper.raycast(player, 1.0f, LivingEntity.class::isInstance);
        }
        if (hit == null) {
            hit = RaycastHelper.findDetachRift((Entity)player, RaycastHelper.DETACH);
        }
        if (world.f_46443_) {
            if (RaycastHelper.hitsLivingEntity(hit) || RaycastHelper.hitsRift(hit, (BlockGetter)world)) {
                return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
            }
            player.m_5661_((Component)Component.m_237115_((String)(this.m_5524_() + ".rift_miss")), true);
            RiftBlockEntity.showRiftCoreUntil = System.currentTimeMillis() + (long)DimensionalDoors.getConfig().getGraphicsConfig().highlightRiftCoreFor;
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)stack);
        }
        if (RaycastHelper.hitsLivingEntity(hit)) {
            Vec3 targetVec = hit.m_82450_();
            BlockPos teleportPosition = new BlockPos((int)targetVec.m_7096_(), (int)targetVec.m_7098_(), (int)targetVec.m_7094_());
            while (world.m_8055_(teleportPosition).m_280555_()) {
                teleportPosition = teleportPosition.m_7494_();
            }
            world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11757_, SoundSource.PLAYERS, 1.0f, 1.0f);
            player.m_6021_((double)teleportPosition.m_123341_() + 0.5, (double)teleportPosition.m_123342_(), (double)teleportPosition.m_123343_() + 0.5);
            Vec3 direction = targetVec.m_82546_(player.m_20182_()).m_82541_();
            float yaw = (float)(Math.atan2(direction.f_82481_, direction.f_82479_) * 57.29577951308232) - 90.0f;
            player.m_146922_(yaw);
            stack.m_41622_(1, (LivingEntity)player, a -> a.m_21190_(hand));
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        if (RaycastHelper.hitsDetachedRift(hit, (BlockGetter)world)) {
            BlockHitResult blockHitResult = (BlockHitResult)hit;
            BlockPos pos = blockHitResult.m_82425_();
            RiftBlockEntity rift = (RiftBlockEntity)world.m_7702_(blockHitResult.m_82425_());
            world.m_46597_(pos, (BlockState)((Block)ModBlocks.DIMENSIONAL_PORTAL.get()).m_49966_().m_61124_((Property)DimensionalPortalBlock.FACING, (Comparable)blockHitResult.m_82434_().m_122424_()));
            ((EntranceRiftBlockEntity)world.m_7702_(pos)).setData(rift.getData());
            stack.m_41622_(1, (LivingEntity)player, a -> a.m_21190_(hand));
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return new InteractionResultHolder(InteractionResult.FAIL, (Object)stack);
    }
}

