/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.block.entity;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Rotations;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.api.client.DefaultTransformation;
import org.dimdev.dimdoors.api.client.Transformer;
import org.dimdev.dimdoors.api.util.EntityUtils;
import org.dimdev.dimdoors.api.util.Location;
import org.dimdev.dimdoors.api.util.TeleportUtil;
import org.dimdev.dimdoors.api.util.math.TransformationMatrix3d;
import org.dimdev.dimdoors.block.CoordinateTransformerBlock;
import org.dimdev.dimdoors.block.DimensionalPortalBlock;
import org.dimdev.dimdoors.block.ModBlocks;
import org.dimdev.dimdoors.block.RiftProvider;
import org.dimdev.dimdoors.block.door.DimensionalDoorBlock;
import org.dimdev.dimdoors.block.door.WaterLoggableDoorBlock;
import org.dimdev.dimdoors.block.entity.DetachedRiftBlockEntity;
import org.dimdev.dimdoors.block.entity.ModBlockEntityTypes;
import org.dimdev.dimdoors.block.entity.RiftBlockEntity;
import org.dimdev.dimdoors.item.RiftKeyItem;
import org.dimdev.dimdoors.pockets.DefaultDungeonDestinations;
import org.dimdev.dimdoors.rift.registry.Rift;
import org.dimdev.dimdoors.rift.targets.EscapeTarget;
import org.dimdev.dimdoors.world.ModDimensions;

public class EntranceRiftBlockEntity
extends RiftBlockEntity<DimensionalDoorBlock> {
    private static final EscapeTarget ESCAPE_TARGET = new EscapeTarget(true);
    private static final Logger LOGGER = LogManager.getLogger();
    private boolean locked;

    public EntranceRiftBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType<? extends RiftBlockEntity>)((BlockEntityType)ModBlockEntityTypes.ENTRANCE_RIFT.get()), pos, state);
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.locked = nbt.m_128471_("locked");
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        nbt.m_128379_("locked", this.locked);
        super.m_183515_(nbt);
    }

    @Override
    public boolean teleport(Entity entity) {
        if (this.isLocked()) {
            if (entity instanceof LivingEntity) {
                Rift rift;
                ItemStack stack = ((LivingEntity)entity).m_21120_(((LivingEntity)entity).m_7655_());
                if (RiftKeyItem.has(stack, (rift = this.asRift()).getId())) {
                    return this.innerTeleport(entity);
                }
                EntityUtils.chat(entity, (Component)Component.m_237115_((String)"rifts.isLocked"));
            }
            return false;
        }
        return this.innerTeleport(entity);
    }

    private boolean innerTeleport(Entity entity) {
        boolean status = super.teleport(entity);
        if (this.riftStateChanged && !this.data.isAlwaysDelete()) {
            this.m_6596_();
        }
        return status;
    }

    @Override
    public boolean receiveEntity(Entity entity, Vec3 relativePos, Rotations relativeAngle, Vec3 relativeVelocity, Location location) {
        BlockState state = this.m_58904_().m_8055_(this.m_58899_());
        Block block = state.m_60734_();
        Vec3 targetPos = Vec3.m_82512_((Vec3i)this.m_58899_()).m_82549_(Vec3.m_82528_((Vec3i)this.getOrientation().m_122424_().m_122436_()).m_82490_(DimensionalDoors.getConfig().getGeneralConfig().teleportOffset + 0.01));
        if (block instanceof CoordinateTransformerBlock) {
            CoordinateTransformerBlock transformer = (CoordinateTransformerBlock)block;
            if (transformer.isExitFlipped()) {
                TransformationMatrix3d flipper = (TransformationMatrix3d)TransformationMatrix3d.builder().rotateY(Math.PI).build();
                relativePos = flipper.transform(relativePos);
                relativeAngle = flipper.transform(relativeAngle);
                relativeVelocity = flipper.transform(relativeVelocity);
            }
            TransformationMatrix3d.TransformationMatrix3dBuilder transformationBuilder = transformer.transformationBuilder(state, this.m_58899_());
            TransformationMatrix3d.TransformationMatrix3dBuilder rotatorBuilder = transformer.rotatorBuilder(state, this.m_58899_());
            targetPos = transformer.transformOut(transformationBuilder, relativePos);
            relativeAngle = transformer.rotateOut(rotatorBuilder, relativeAngle);
            relativeVelocity = transformer.rotateOut(rotatorBuilder, relativeVelocity);
        }
        Direction direction = this.getOrientation().m_122424_();
        targetPos = targetPos.m_82520_((double)direction.m_122436_().m_123341_() / 2.0, (double)direction.m_122436_().m_123342_() / 2.0, (double)direction.m_122436_().m_123343_() / 2.0);
        TeleportUtil.teleport(entity, this.f_58857_, targetPos, relativeAngle, relativeVelocity);
        return true;
    }

    public Direction getOrientation() {
        return Optional.of(this.f_58857_.m_8055_(this.f_58858_)).filter(state -> state.m_61138_((Property)HorizontalDirectionalBlock.f_54117_)).map(state -> (Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).orElse(Direction.NORTH);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Transformer getTransformer() {
        return DefaultTransformation.fromDirection(this.getOrientation());
    }

    public boolean hasOrientation() {
        return this.f_58857_ != null && this.f_58857_.m_8055_(this.f_58858_).m_61138_((Property)HorizontalDirectionalBlock.f_54117_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isTall() {
        return ((RiftProvider)this.m_58900_().m_60734_()).isTall(this.m_58900_());
    }

    @Override
    public boolean isDetached() {
        return false;
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public void setPortalDestination(ServerLevel world) {
        if (ModDimensions.isLimboDimension((Level)world)) {
            this.setDestination(ESCAPE_TARGET);
        } else {
            this.setDestination(DefaultDungeonDestinations.getGateway());
            this.setProperties(DefaultDungeonDestinations.POCKET_LINK_PROPERTIES);
        }
    }

    public void generateDetached(Level world) {
        BlockState blockState = this.m_58900_();
        BlockPos pos = this.m_58899_();
        world.m_46597_(pos, (BlockState)((Block)ModBlocks.DETACHED_RIFT.get()).m_49966_().m_61124_((Property)WaterLoggableDoorBlock.WATERLOGGED, (Comparable)((Boolean)blockState.m_61143_((Property)WaterLoggableDoorBlock.WATERLOGGED))));
        ((DetachedRiftBlockEntity)world.m_7702_(pos)).setData(this.getData());
    }

    @Override
    protected void onClose(Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        if (block instanceof DimensionalDoorBlock) {
            DimensionalDoorBlock dimensionalDoorBlock = (DimensionalDoorBlock)block;
            Block base = dimensionalDoorBlock.baseBlock();
            if (base instanceof DoorBlock) {
                DoorBlock doorBlock = (DoorBlock)base;
                BlockState newState = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)doorBlock.m_49966_().m_61124_((Property)DoorBlock.f_52726_, (Comparable)((Direction)state.m_61143_((Property)DoorBlock.f_52726_)))).m_61124_((Property)DoorBlock.f_52727_, (Comparable)((Boolean)state.m_61143_((Property)DoorBlock.f_52727_)))).m_61124_((Property)DoorBlock.f_52728_, (Comparable)((DoorHingeSide)state.m_61143_((Property)DoorBlock.f_52728_)))).m_61124_((Property)DoorBlock.f_52729_, (Comparable)((Boolean)state.m_61143_((Property)DoorBlock.f_52729_)))).m_61124_((Property)DoorBlock.f_52730_, (Comparable)DoubleBlockHalf.UPPER);
                level.m_7471_(pos, false);
                level.m_46597_(pos.m_7494_(), newState);
                level.m_46597_(pos.m_7494_(), (BlockState)newState.m_61124_((Property)DoorBlock.f_52730_, (Comparable)DoubleBlockHalf.LOWER));
            }
        } else if (block instanceof DimensionalPortalBlock) {
            level.m_7471_(pos, false);
        }
    }

    @Override
    protected Class<DimensionalDoorBlock> blockClass() {
        return DimensionalDoorBlock.class;
    }

    @Override
    public boolean stablized() {
        return true;
    }
}

