/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.api.util;

import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.TickTask;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public enum BlockPlacementType implements StringRepresentable
{
    SECTION_NO_UPDATE_QUEUE_BLOCK_ENTITY("section_no_update_queue_block_entity", true, false, BlockPlacementType::queueBlockEntity),
    SECTION_NO_UPDATE("section_no_update", true, false, Level::m_151523_),
    SECTION_UPDATE("section_update", true, true, Level::m_151523_),
    SET_BLOCK_STATE("set_block_state", false, false, Level::m_151523_),
    SET_BLOCK_STATE_QUEUE_BLOCK_ENTITY("set_block_state_queue_block_entity", false, false, BlockPlacementType::queueBlockEntity);

    private static final Map<String, BlockPlacementType> idMap;
    public static final Codec<BlockPlacementType> CODEC;
    final String id;
    final boolean useSection;
    final boolean markForUpdate;
    final BiConsumer<Level, BlockEntity> blockEntityPlacer;

    private BlockPlacementType(String id, boolean useSection, boolean markForUpdate, BiConsumer<Level, BlockEntity> blockEntityPlacer) {
        this.id = id;
        this.useSection = useSection;
        this.markForUpdate = markForUpdate;
        this.blockEntityPlacer = blockEntityPlacer;
    }

    public boolean useSection() {
        return this.useSection;
    }

    public boolean shouldMarkForUpdate() {
        return this.markForUpdate;
    }

    public BiConsumer<Level, BlockEntity> getBlockEntityPlacer() {
        return this.blockEntityPlacer;
    }

    public String getId() {
        return this.id;
    }

    public static BlockPlacementType getFromId(String id) {
        return idMap.get(id);
    }

    private static void queueBlockEntity(Level world, BlockEntity blockEntity) {
        MinecraftServer server = world.m_7654_();
        server.m_6937_((Runnable)new TickTask(server.m_129921_(), () -> world.m_151523_(blockEntity)));
    }

    public String m_7912_() {
        return this.id;
    }

    static {
        idMap = new HashMap<String, BlockPlacementType>();
        CODEC = StringRepresentable.m_216439_(BlockPlacementType::values);
        for (BlockPlacementType type : BlockPlacementType.values()) {
            idMap.put(type.getId(), type);
        }
    }
}

