/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.gui;

import blusunrize.immersiveengineering.common.util.Utils;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public abstract class ItemContainer
extends AbstractContainerMenu
implements Supplier<Level> {
    protected final Inventory inventoryPlayer;
    protected final Level world;
    protected int blockedSlot;
    protected final EquipmentSlot equipmentSlot;
    protected final ItemStack heldItem;
    protected final Player player;
    public int internalSlots;

    public ItemContainer(MenuType<?> type, int id, Inventory inventoryPlayer, Level world, EquipmentSlot entityEquipmentSlot, ItemStack heldItem) {
        super(type, id);
        this.inventoryPlayer = inventoryPlayer;
        this.world = world;
        this.player = inventoryPlayer.f_35978_;
        this.equipmentSlot = entityEquipmentSlot;
        this.heldItem = heldItem.m_41777_();
        this.updateSlots();
    }

    protected void updateSlots() {
        this.internalSlots = this.addSlots();
        this.blockedSlot = this.inventoryPlayer.f_35977_ + 27 + this.internalSlots;
    }

    abstract int addSlots();

    public EquipmentSlot getEquipmentSlot() {
        return this.equipmentSlot;
    }

    @Nonnull
    public ItemStack m_7648_(Player par1EntityPlayer, int slot) {
        ItemStack oldStackInSlot = ItemStack.f_41583_;
        Slot slotObject = (Slot)this.f_38839_.get(slot);
        if (slotObject != null && slotObject.m_6657_()) {
            ItemStack stackInSlot = slotObject.m_7993_();
            oldStackInSlot = stackInSlot.m_41777_();
            if (slot < this.internalSlots) {
                if (!this.m_38903_(stackInSlot, this.internalSlots, this.internalSlots + 36, true)) {
                    return ItemStack.f_41583_;
                }
            } else if (this.allowShiftclicking() && !stackInSlot.m_41619_()) {
                boolean b = true;
                for (int i = 0; i < this.internalSlots; ++i) {
                    Slot s = (Slot)this.f_38839_.get(i);
                    if (s == null || !s.m_5857_(stackInSlot) || !s.m_7993_().m_41619_() && (!ItemStack.m_41656_((ItemStack)stackInSlot, (ItemStack)s.m_7993_()) || !Utils.compareItemNBT(stackInSlot, s.m_7993_()))) continue;
                    int space = Math.min(s.m_5866_(stackInSlot), stackInSlot.m_41741_());
                    if (!s.m_7993_().m_41619_()) {
                        space -= s.m_7993_().m_41613_();
                    }
                    if (space <= 0) continue;
                    ItemStack insert = stackInSlot;
                    if (space < stackInSlot.m_41613_()) {
                        insert = stackInSlot.m_41620_(space);
                    }
                    if (!this.m_38903_(insert, i, i + 1, true)) continue;
                    b = false;
                }
                if (b) {
                    return ItemStack.f_41583_;
                }
            }
            if (stackInSlot.m_41613_() == 0) {
                slotObject.m_5852_(ItemStack.f_41583_);
            } else {
                slotObject.m_6654_();
            }
            slotObject.f_40218_.m_6596_();
            if (stackInSlot.m_41613_() == oldStackInSlot.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slotObject.m_142406_(this.player, oldStackInSlot);
            this.m_38946_();
        }
        return oldStackInSlot;
    }

    protected boolean allowShiftclicking() {
        return true;
    }

    public boolean m_6875_(@Nonnull Player entityplayer) {
        return ItemStack.m_41656_((ItemStack)this.player.m_6844_(this.equipmentSlot), (ItemStack)this.heldItem);
    }

    public void m_150399_(int par1, int par2, ClickType par3, Player par4EntityPlayer) {
        if (par1 == this.blockedSlot || par3 == ClickType.SWAP && par2 == par4EntityPlayer.m_150109_().f_35977_) {
            return;
        }
        super.m_150399_(par1, par2, par3, par4EntityPlayer);
        this.m_38946_();
    }

    @Override
    public Level get() {
        return this.world;
    }
}

