/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks.logic.arcfurnace;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.crafting.ArcFurnaceRecipe;
import blusunrize.immersiveengineering.api.energy.AveragingEnergyStorage;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.ComparatorManager;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IClientTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.RedstoneControl;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.CapabilityPosition;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MBInventoryUtils;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.StoredCapability;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.arcfurnace.ArcFurnaceInputHandler;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.arcfurnace.ArcFurnaceProcess;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcess;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessor;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.ProcessContext;
import blusunrize.immersiveengineering.common.blocks.multiblocks.shapes.ArcFurnaceSelectionShapes;
import blusunrize.immersiveengineering.common.blocks.multiblocks.shapes.ArcFurnaceShapes;
import blusunrize.immersiveengineering.common.register.IEParticles;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.WrappingItemHandler;
import blusunrize.immersiveengineering.common.util.sound.MultiblockSound;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.List;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class ArcFurnaceLogic
implements IMultiblockLogic<State>,
IServerTickableComponent<State>,
IClientTickableComponent<State> {
    private static final Set<CapabilityPosition> ENERGY_INPUTS = Set.of(new CapabilityPosition(1, 1, 0, RelativeBlockFace.FRONT), new CapabilityPosition(2, 1, 0, RelativeBlockFace.FRONT), new CapabilityPosition(3, 1, 0, RelativeBlockFace.FRONT));
    private static final List<Vec3> ELECTRODE_OFFSETS = List.of(new Vec3(2.5, 3.9, 2.75), new Vec3(2.125, 3.9, 2.25), new Vec3(2.875, 3.9, 2.25));
    private static final Vec3 SMOKE_OFFSET = new Vec3(2.5, 3.9, 2.5);
    private static final double[] PARTICLE_Y_SPEEDS = new double[]{0.025, 0.05};
    public static final BlockPos REDSTONE_POS = new BlockPos(0, 1, 4);
    private static final BlockPos ELECTRODE_COMPARATOR_POS = new BlockPos(2, 4, 2);
    public static final int FIRST_IN_SLOT = 0;
    public static final int IN_SLOT_COUNT = 12;
    public static final int FIRST_ADDITIVE_SLOT = 12;
    public static final int ADDITIVE_SLOT_COUNT = 4;
    public static final int FIRST_OUT_SLOT = 16;
    public static final int OUT_SLOT_COUNT = 6;
    public static final int SLAG_SLOT = 22;
    public static final int FIRST_ELECTRODE_SLOT = 23;
    public static final int ELECTRODE_COUNT = 3;
    private static final MultiblockFace SLAG_OUT_POS = new MultiblockFace(2, 0, -1, RelativeBlockFace.BACK);
    private static final MultiblockFace MAIN_OUT_POS = new MultiblockFace(2, 0, 5, RelativeBlockFace.FRONT);
    private static final CapabilityPosition SLAG_CAP_POS = CapabilityPosition.opposing(SLAG_OUT_POS);
    private static final CapabilityPosition MAIN_CAP_POS = CapabilityPosition.opposing(MAIN_OUT_POS);
    private static final int[] OUTPUT_SLOTS = (int[])Util.m_137469_((Object)new int[6], slots -> {
        for (int i = 0; i < 6; ++i) {
            slots[i] = 16 + i;
        }
    });
    public static final int NUM_SLOTS = 26;
    public static final int ENERGY_CAPACITY = 64000;

    @Override
    public void tickServer(IMultiblockContext<State> context) {
        boolean canWork;
        IMultiblockLevel level;
        State state = context.getState();
        boolean tickedAny = state.processor.tickServer(state, level = context.getLevel(), canWork = state.rsControl.isEnabled(context));
        if (state.active != tickedAny || state.updateElectrodePresence()) {
            state.active = tickedAny;
            context.requestMasterBESync();
        }
        if (!canWork || state.energy.getEnergyStored() <= 0) {
            return;
        }
        if (tickedAny) {
            for (int i = 23; i < 26; ++i) {
                if (!state.inventory.getStackInSlot(i).m_220157_(1, ApiUtils.RANDOM_SOURCE, null)) continue;
                state.inventory.setStackInSlot(i, ItemStack.f_41583_);
            }
        }
        if (state.processor.getQueueSize() < state.processor.getMaxQueueSize()) {
            this.enqueueProcesses(state, level.getRawLevel());
        }
        if (level.shouldTickModulo(8)) {
            this.outputItems(state);
        }
        if (tickedAny && ApiUtils.RANDOM.nextInt(10) == 0) {
            Level rawLevel = level.getRawLevel();
            Vec3 soundPos = level.toAbsolute(new Vec3(1.5, 1.5, 1.5));
            rawLevel.m_6263_(null, soundPos.f_82479_, soundPos.f_82480_, soundPos.f_82481_, SoundEvents.f_12090_, SoundSource.BLOCKS, 0.6f + ApiUtils.RANDOM.nextFloat() * 0.4f, 1.0f);
        }
    }

    @Override
    public void tickClient(IMultiblockContext<State> context) {
        State state = context.getState();
        if (state.pouringMetal > 0) {
            --state.pouringMetal;
        }
        if (!state.isPlayingSound.getAsBoolean()) {
            Vec3 soundPos = context.getLevel().toAbsolute(new Vec3(2.5, 3.0, 2.5));
            state.isPlayingSound = MultiblockSound.startSound(() -> state.active, context.isValid(), soundPos, IESounds.arcFurnace, 0.375f);
        }
        if (!state.active) {
            return;
        }
        IMultiblockLevel level = context.getLevel();
        Level rawLevel = level.getRawLevel();
        int i = 0;
        while ((double)i < Math.max(1.0, (double)state.queueSize * 0.51)) {
            if (ApiUtils.RANDOM.nextInt(6) == 0) {
                for (Vec3 offset : ELECTRODE_OFFSETS) {
                    Vec3 absPos = level.toAbsolute(offset);
                    for (double ySpeed : PARTICLE_Y_SPEEDS) {
                        rawLevel.m_7107_((ParticleOptions)IEParticles.SPARKS.get(), absPos.f_82479_, absPos.f_82480_, absPos.f_82481_, ArcFurnaceLogic.particleSpeed(0.025), ySpeed, ArcFurnaceLogic.particleSpeed(0.025));
                    }
                }
            }
            Vec3 smokePos = level.toAbsolute(SMOKE_OFFSET);
            rawLevel.m_7107_((ParticleOptions)ParticleTypes.f_123777_, smokePos.f_82479_, smokePos.f_82480_, smokePos.f_82481_, ArcFurnaceLogic.particleSpeed(0.009375), 0.0625, ArcFurnaceLogic.particleSpeed(0.009375));
            ++i;
        }
    }

    private static double particleSpeed(double max) {
        return ApiUtils.RANDOM.nextDouble(-max, max);
    }

    private void enqueueProcesses(State state, Level level) {
        Int2IntOpenHashMap usedInvSlots = new Int2IntOpenHashMap();
        for (MultiblockProcess process : state.processor.getQueue()) {
            if (!(process instanceof ArcFurnaceProcess)) continue;
            ArcFurnaceProcess arcProcess = (ArcFurnaceProcess)process;
            int[] inputSlots = arcProcess.getInputSlots();
            int[] inputAmounts = arcProcess.getInputAmounts();
            if (inputAmounts == null) continue;
            for (int i = 0; i < inputSlots.length; ++i) {
                if (inputAmounts[i] <= 0) continue;
                usedInvSlots.addTo(inputSlots[i], inputAmounts[i]);
            }
        }
        NonNullList additives = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
        for (int i = 0; i < 4; ++i) {
            ItemStack additive = state.inventory.getStackInSlot(12 + i);
            if (additive.m_41619_()) continue;
            additives.set(i, (Object)additive.m_41777_());
            if (!usedInvSlots.containsKey(12 + i)) continue;
            ((ItemStack)additives.get(i)).m_41774_(usedInvSlots.get(12 + i));
        }
        for (int slot = 0; slot < 12; ++slot) {
            int[] consumedAdditives;
            ArcFurnaceProcess process;
            ArcFurnaceRecipe recipe;
            ItemStack stack;
            if (usedInvSlots.containsKey(slot) || (stack = state.inventory.getStackInSlot(slot)).m_41619_() || (recipe = ArcFurnaceRecipe.findRecipe(level, stack, (NonNullList<ItemStack>)additives)) == null || !state.processor.addProcessToQueue(process = new ArcFurnaceProcess(recipe, ApiUtils.RANDOM.nextLong(), slot, 12, 13, 14, 15), level, false) || (consumedAdditives = recipe.getConsumedAdditives((NonNullList<ItemStack>)additives, true)) == null) continue;
            process.setInputAmounts(recipe.input.getCount(), consumedAdditives[0], consumedAdditives[1], consumedAdditives[2], consumedAdditives[3]);
        }
    }

    private void outputItems(State state) {
        ItemStack slagStack;
        IItemHandler outputHandler = state.output.getNullable();
        if (outputHandler != null) {
            for (int j : OUTPUT_SLOTS) {
                ItemStack nextStack = state.inventory.getStackInSlot(j);
                if (nextStack.m_41619_()) continue;
                ItemStack stack = ItemHandlerHelper.copyStackWithSize((ItemStack)nextStack, (int)1);
                if (!(stack = ItemHandlerHelper.insertItem((IItemHandler)outputHandler, (ItemStack)stack, (boolean)false)).m_41619_()) continue;
                nextStack.m_41774_(1);
            }
        }
        if ((slagStack = state.inventory.getStackInSlot(22)).m_41619_()) {
            return;
        }
        IItemHandler slagOutputHandler = state.slagOutput.getNullable();
        if (slagOutputHandler != null) {
            int out = Math.min(slagStack.m_41613_(), 16);
            ItemStack stack = ItemHandlerHelper.copyStackWithSize((ItemStack)slagStack, (int)out);
            stack = ItemHandlerHelper.insertItem((IItemHandler)slagOutputHandler, (ItemStack)stack, (boolean)false);
            slagStack.m_41774_(out -= stack.m_41613_());
        }
    }

    @Override
    public <T> LazyOptional<T> getCapability(IMultiblockContext<State> ctx, CapabilityPosition position, Capability<T> cap) {
        State state = ctx.getState();
        if (cap == ForgeCapabilities.ENERGY && (position.side() == null || ENERGY_INPUTS.contains(position))) {
            return state.energyCap.cast(ctx);
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (MAIN_CAP_POS.equals(position)) {
                return state.outputHandler.cast(ctx);
            }
            if (SLAG_CAP_POS.equals(position)) {
                return state.slagHandler.cast(ctx);
            }
            if (new BlockPos(1, 3, 2).equals((Object)position.posInMultiblock())) {
                return state.insertionHandler.cast(ctx);
            }
            if (new BlockPos(3, 3, 2).equals((Object)position.posInMultiblock())) {
                return state.additiveHandler.cast(ctx);
            }
        }
        return LazyOptional.empty();
    }

    @Override
    public void dropExtraItems(State state, Consumer<ItemStack> drop) {
        MBInventoryUtils.dropItems((IItemHandler)state.inventory, drop);
    }

    @Override
    public State createInitialState(IInitialMultiblockContext<State> capabilitySource) {
        return new State(capabilitySource);
    }

    @Override
    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType forType) {
        if (forType == ShapeType.SELECTION) {
            return ArcFurnaceSelectionShapes.SHAPE_GETTER;
        }
        return ArcFurnaceShapes.SHAPE_GETTER;
    }

    public static ComparatorManager<State> makeInventoryComparator() {
        return ComparatorManager.makeSimple(state -> Utils.calcRedstoneFromInventory(12, (IItemHandler)state.inventory), REDSTONE_POS);
    }

    public static ComparatorManager<State> makeElectrodeComparator() {
        return ComparatorManager.makeSimple(State::getElectrodeComparatorValue, ELECTRODE_COMPARATOR_POS);
    }

    public static class State
    implements IMultiblockState,
    ProcessContext.ProcessContextInMachine<ArcFurnaceRecipe> {
        private final AveragingEnergyStorage energy = new AveragingEnergyStorage(64000);
        public ItemStackHandler inventory = new ItemStackHandler(26);
        private final MultiblockProcessor.InMachineProcessor<ArcFurnaceRecipe> processor;
        private final CapabilityReference<IItemHandler> output;
        private final CapabilityReference<IItemHandler> slagOutput;
        private final StoredCapability<IEnergyStorage> energyCap;
        private final StoredCapability<IItemHandler> insertionHandler;
        private final StoredCapability<IItemHandler> additiveHandler;
        private final StoredCapability<IItemHandler> outputHandler;
        private final StoredCapability<IItemHandler> slagHandler;
        public final RedstoneControl.RSState rsControl = RedstoneControl.RSState.enabledByDefault();
        private boolean active;
        public byte electrodePresence;
        private int queueSize;
        public int pouringMetal = 0;
        private BooleanSupplier isPlayingSound = () -> false;

        public State(IInitialMultiblockContext<State> ctx) {
            this.processor = new MultiblockProcessor.InMachineProcessor<ArcFurnaceRecipe>(12, $ -> 0.0, 12, ctx.getMarkDirtyRunnable(), ctx.getSyncRunnable(), ArcFurnaceRecipe.RECIPES::getById);
            this.output = ctx.getCapabilityAt(ForgeCapabilities.ITEM_HANDLER, MAIN_OUT_POS);
            this.slagOutput = ctx.getCapabilityAt(ForgeCapabilities.ITEM_HANDLER, SLAG_OUT_POS);
            this.energyCap = new StoredCapability<AveragingEnergyStorage>(this.energy);
            this.insertionHandler = new StoredCapability<ArcFurnaceInputHandler>(new ArcFurnaceInputHandler((IItemHandlerModifiable)this.inventory, ctx.getMarkDirtyRunnable()));
            this.additiveHandler = new StoredCapability<WrappingItemHandler>(new WrappingItemHandler((IItemHandler)this.inventory, true, false, new WrappingItemHandler.IntRange(12, 16)));
            this.outputHandler = new StoredCapability<WrappingItemHandler>(new WrappingItemHandler((IItemHandler)this.inventory, false, true, new WrappingItemHandler.IntRange(16, 22)));
            this.slagHandler = new StoredCapability<WrappingItemHandler>(new WrappingItemHandler((IItemHandler)this.inventory, false, true, new WrappingItemHandler.IntRange(22, 23)));
        }

        @Override
        public void writeSaveNBT(CompoundTag nbt) {
            nbt.m_128365_("energy", this.energy.serializeNBT());
            nbt.m_128365_("inventory", (Tag)this.inventory.serializeNBT());
            nbt.m_128365_("processor", this.processor.toNBT());
        }

        @Override
        public void readSaveNBT(CompoundTag nbt) {
            this.energy.deserializeNBT(nbt.m_128423_("energy"));
            this.inventory.deserializeNBT(nbt.m_128469_("inventory"));
            this.processor.fromNBT(nbt.m_128423_("processor"), ArcFurnaceProcess::new);
        }

        @Override
        public void writeSyncNBT(CompoundTag nbt) {
            nbt.m_128344_("electrodeMask", this.electrodePresence);
            nbt.m_128379_("active", this.active);
            nbt.m_128405_("pouringMetal", this.pouringMetal);
            nbt.m_128405_("queueSize", this.processor.getQueueSize());
        }

        @Override
        public void readSyncNBT(CompoundTag nbt) {
            this.electrodePresence = nbt.m_128445_("electrodeMask");
            this.active = nbt.m_128471_("active");
            this.pouringMetal = nbt.m_128451_("pouringMetal");
            this.queueSize = nbt.m_128451_("queueSize");
        }

        private boolean updateElectrodePresence() {
            byte electrodePresence = 0;
            for (int i = 0; i < 3; ++i) {
                if (this.inventory.getStackInSlot(i + 23).m_41619_()) continue;
                electrodePresence = (byte)(electrodePresence | (byte)(1 << i));
            }
            if (electrodePresence != this.electrodePresence) {
                this.electrodePresence = electrodePresence;
                return true;
            }
            return false;
        }

        @Override
        public AveragingEnergyStorage getEnergy() {
            return this.energy;
        }

        public ItemStackHandler getInventory() {
            return this.inventory;
        }

        @Override
        public int[] getOutputSlots() {
            return OUTPUT_SLOTS;
        }

        public boolean isClientActive() {
            return this.active;
        }

        public List<MultiblockProcess<ArcFurnaceRecipe, ProcessContext.ProcessContextInMachine<ArcFurnaceRecipe>>> getProcessQueue() {
            return this.processor.getQueue();
        }

        private int getElectrodeComparatorValue() {
            float f = 0.0f;
            for (int i = 23; i < 26; ++i) {
                ItemStack electrode = this.inventory.getStackInSlot(i);
                if (electrode.m_41619_()) continue;
                f += 1.0f - (float)electrode.m_41773_() / (float)electrode.m_41776_();
            }
            return Mth.m_14167_((float)(Math.max(f / 3.0f, 0.0f) * 15.0f));
        }

        public boolean hasElectrodes() {
            for (int i = 23; i < 26; ++i) {
                if (!this.inventory.getStackInSlot(i).m_41619_()) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean additionalCanProcessCheck(MultiblockProcess<ArcFurnaceRecipe, ?> process, Level level) {
            if (!this.hasElectrodes()) {
                return false;
            }
            ArcFurnaceRecipe recipe = process.getRecipe(level);
            if (recipe == null || ((ItemStack)recipe.slag.get()).m_41619_()) {
                return true;
            }
            ItemStack slag = this.inventory.getStackInSlot(22);
            if (slag.m_41619_()) {
                return true;
            }
            return ItemHandlerHelper.canItemStacksStack((ItemStack)slag, (ItemStack)((ItemStack)recipe.slag.get())) && slag.m_41613_() + ((ItemStack)recipe.slag.get()).m_41613_() <= 64;
        }

        @Override
        public void onProcessFinish(MultiblockProcess<ArcFurnaceRecipe, ?> process, Level level) {
            ArcFurnaceRecipe recipe = process.getRecipe(level);
            if (recipe == null || ((ItemStack)recipe.slag.get()).m_41619_()) {
                return;
            }
            ItemStack slag = this.inventory.getStackInSlot(22);
            if (slag.m_41619_()) {
                this.inventory.setStackInSlot(22, ((ItemStack)recipe.slag.get()).m_41777_());
            } else if (ItemHandlerHelper.canItemStacksStack((ItemStack)slag, (ItemStack)((ItemStack)recipe.slag.get()))) {
                slag.m_41769_(((ItemStack)recipe.slag.get()).m_41613_());
            }
        }
    }
}

