/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.energy.MutableEnergyStorage;
import blusunrize.immersiveengineering.api.fluid.IFluidPipe;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import blusunrize.immersiveengineering.client.utils.TextUtils;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlock;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.metal.FluidPipeBlockEntity;
import blusunrize.immersiveengineering.common.blocks.ticking.IEServerTickableBE;
import blusunrize.immersiveengineering.common.config.IEClientConfig;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.MultiblockCapability;
import blusunrize.immersiveengineering.common.util.ResettableCapability;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class FluidPumpBlockEntity
extends IEBaseBlockEntity
implements IEServerTickableBE,
IEBlockInterfaces.IBlockBounds,
IEBlockInterfaces.IHasDummyBlocks,
IEBlockInterfaces.IConfigurableSides,
IFluidPipe,
IEBlockInterfaces.IBlockOverlayText {
    public Map<Direction, IEEnums.IOSideConfig> sideConfig = new EnumMap<Direction, IEEnums.IOSideConfig>(Direction.class);
    private final FluidTank tank;
    private final MutableEnergyStorage energyStorage;
    private boolean placeCobble;
    private final MultiblockCapability<IEnergyStorage> energyCap;
    private boolean checkingArea;
    private Fluid searchFluid;
    private final List<BlockPos> openList;
    private final List<BlockPos> closedList;
    private final Set<BlockPos> checked;
    private final Map<Direction, CapabilityReference<IFluidHandler>> neighborFluids;
    private final Map<Direction, ResettableCapability<IFluidHandler>> sidedFluidHandler;

    public FluidPumpBlockEntity(BlockEntityType<FluidPumpBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        for (Direction d : DirectionUtils.VALUES) {
            if (d == Direction.DOWN) {
                this.sideConfig.put(d, IEEnums.IOSideConfig.INPUT);
                continue;
            }
            this.sideConfig.put(d, IEEnums.IOSideConfig.NONE);
        }
        this.tank = new FluidTank(4000);
        this.energyStorage = new MutableEnergyStorage(8000);
        this.placeCobble = true;
        this.energyCap = MultiblockCapability.make(this, be -> be.energyCap, FluidPumpBlockEntity::master, this.registerEnergyInput(this.energyStorage));
        this.checkingArea = false;
        this.searchFluid = null;
        this.openList = new ArrayList<BlockPos>();
        this.closedList = new ArrayList<BlockPos>();
        this.checked = new HashSet<BlockPos>();
        this.neighborFluids = CapabilityReference.forAllNeighbors(this, ForgeCapabilities.FLUID_HANDLER);
        this.sidedFluidHandler = new EnumMap<Direction, ResettableCapability<IFluidHandler>>(Direction.class);
    }

    @Override
    public void tickServer() {
        BlockEntity above;
        if (this.isDummy()) {
            return;
        }
        if (this.tank.getFluidAmount() > 0) {
            int i = this.outputFluid(this.tank.getFluid(), IFluidHandler.FluidAction.EXECUTE);
            this.tank.drain(i, IFluidHandler.FluidAction.EXECUTE);
        }
        int consumption = (Integer)IEServerConfig.MACHINES.pump_consumption.get();
        boolean hasRSSignal = this.isRSPowered();
        if (!hasRSSignal && (above = this.f_58857_.m_7702_(this.m_58899_().m_7494_())) instanceof FluidPumpBlockEntity) {
            hasRSSignal = ((FluidPumpBlockEntity)above).isRSPowered();
        }
        if (hasRSSignal) {
            for (BlockEntity f : Direction.values()) {
                if (this.sideConfig.get(f) != IEEnums.IOSideConfig.INPUT) continue;
                IFluidHandler input = this.neighborFluids.get(f).getNullable();
                if (input != null) {
                    int drainAmount = IFluidPipe.getTransferableAmount(this.canOutputPressurized(false));
                    FluidStack drain = input.drain(drainAmount, IFluidHandler.FluidAction.SIMULATE);
                    if (drain.isEmpty()) continue;
                    int out = this.outputFluid(drain, IFluidHandler.FluidAction.EXECUTE);
                    input.drain(out, IFluidHandler.FluidAction.EXECUTE);
                    continue;
                }
                this.gatherInfiniteFluidFromWorld((Direction)f);
            }
            if (this.f_58857_.m_46467_() % 40L == (long)(((this.m_58899_().m_123341_() ^ this.m_58899_().m_123343_()) % 40 + 40) % 40)) {
                if (this.closedList.isEmpty()) {
                    this.prepareAreaCheck();
                } else {
                    int target = this.closedList.size() - 1;
                    BlockPos pos = this.closedList.get(target);
                    FluidStack fs = Utils.drainFluidBlock(this.f_58857_, pos, IFluidHandler.FluidAction.SIMULATE);
                    if (fs == null) {
                        this.closedList.remove(target);
                    } else if (this.tank.fill(fs, IFluidHandler.FluidAction.SIMULATE) == fs.getAmount() && this.energyStorage.extractEnergy(consumption, true) >= consumption) {
                        this.energyStorage.extractEnergy(consumption, false);
                        fs = Utils.drainFluidBlock(this.f_58857_, pos, IFluidHandler.FluidAction.EXECUTE);
                        if (((Boolean)IEServerConfig.MACHINES.pump_placeCobble.get()).booleanValue() && this.placeCobble) {
                            this.f_58857_.m_46597_(pos, Blocks.f_50652_.m_49966_());
                        }
                        this.tank.fill(fs, IFluidHandler.FluidAction.EXECUTE);
                        this.closedList.remove(target);
                    }
                }
            }
        }
        if (this.checkingArea) {
            this.checkAreaTick();
        }
    }

    public void prepareAreaCheck() {
        this.openList.clear();
        this.closedList.clear();
        this.checked.clear();
        this.searchFluid = null;
        for (Direction f : Direction.values()) {
            if (this.sideConfig.get(f) != IEEnums.IOSideConfig.INPUT) continue;
            this.openList.add(this.m_58899_().m_121945_(f));
            this.checkingArea = true;
        }
    }

    private void gatherInfiniteFluidFromWorld(Direction gatherFrom) {
        if (this.f_58857_.m_46467_() % 20L != (long)Mth.m_14100_((int)(this.m_58899_().m_123341_() ^ this.m_58899_().m_123343_()), (int)20)) {
            return;
        }
        int consumption = (Integer)IEServerConfig.MACHINES.pump_consumption.get();
        if (this.energyStorage.extractEnergy(consumption, true) < consumption) {
            return;
        }
        BlockPos neighborPos = this.m_58899_().m_121945_(gatherFrom);
        FluidState neighborFluidState = this.f_58857_.m_6425_(neighborPos);
        if (!neighborFluidState.m_76170_() || !neighborFluidState.canConvertToSource(this.getLevelNonnull(), neighborPos)) {
            return;
        }
        Fluid fluid = neighborFluidState.m_76152_();
        FluidStack gatheredFluid = new FluidStack(fluid, 1000);
        if (this.tank.fill(gatheredFluid, IFluidHandler.FluidAction.SIMULATE) != gatheredFluid.getAmount()) {
            return;
        }
        int connectedSources = 0;
        for (Direction sourceNeighbor : DirectionUtils.BY_HORIZONTAL_INDEX) {
            FluidState neighboringSource = this.f_58857_.m_6425_(neighborPos.m_121945_(sourceNeighbor));
            if (neighboringSource.m_76152_() != fluid || !neighboringSource.m_76170_()) continue;
            ++connectedSources;
        }
        if (connectedSources > 1) {
            this.energyStorage.extractEnergy(consumption, false);
            this.tank.fill(gatheredFluid, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    public void checkAreaTick() {
        int closedListMax = 2048;
        int timeout = 0;
        while (timeout < 64 && this.closedList.size() < 2048 && !this.openList.isEmpty()) {
            FluidState fluidState;
            ++timeout;
            BlockPos next = this.openList.remove(0);
            if (!this.checked.add(next) || (fluidState = this.getLevelNonnull().m_6425_(next)).m_76178_() || fluidState.canConvertToSource(this.getLevelNonnull(), next)) continue;
            Fluid fluid = fluidState.m_76152_();
            if (this.searchFluid != null && fluid != this.searchFluid) continue;
            if (this.searchFluid == null) {
                this.searchFluid = fluid;
            }
            if (!Utils.drainFluidBlock(this.f_58857_, next, IFluidHandler.FluidAction.SIMULATE).isEmpty()) {
                this.closedList.add(next);
            }
            for (Direction f : Direction.values()) {
                FluidState neighborFluidState;
                BlockPos neighborPos = next.m_121945_(f);
                if (this.checked.contains(neighborPos) || (neighborFluidState = this.getLevelNonnull().m_6425_(neighborPos)).m_76178_()) continue;
                Fluid neighborFluid = Utils.getRelatedFluid(this.f_58857_, neighborPos);
                if (neighborFluidState.canConvertToSource(this.getLevelNonnull(), neighborPos) || neighborFluid != this.searchFluid) continue;
                this.openList.add(neighborPos);
            }
        }
        if (this.closedList.size() >= 2048 || this.openList.isEmpty()) {
            this.checkingArea = false;
        }
    }

    public int outputFluid(FluidStack fs, IFluidHandler.FluidAction action) {
        FluidStack insertResource;
        if (fs.isEmpty()) {
            return 0;
        }
        int canAccept = fs.getAmount();
        if (canAccept <= 0) {
            return 0;
        }
        int accelPower = (Integer)IEServerConfig.MACHINES.pump_consumption_accelerate.get();
        int fluidForSort = canAccept;
        int sum = 0;
        HashMap<FluidPipeBlockEntity.DirectionalFluidOutput, Integer> sorting = new HashMap<FluidPipeBlockEntity.DirectionalFluidOutput, Integer>();
        for (Direction f : Direction.values()) {
            int temp;
            IFluidHandler handler;
            if (this.sideConfig.get(f) != IEEnums.IOSideConfig.OUTPUT || (handler = this.neighborFluids.get(f).getNullable()) == null) continue;
            BlockEntity tile = this.getLevelNonnull().m_7702_(this.f_58858_.m_121945_(f));
            insertResource = Utils.copyFluidStackWithAmount(fs, fs.getAmount(), true);
            if (tile instanceof FluidPipeBlockEntity && this.energyStorage.extractEnergy(accelPower, true) >= accelPower) {
                insertResource.getOrCreateTag().m_128379_("pressurized", true);
            }
            if ((temp = handler.fill(insertResource, IFluidHandler.FluidAction.SIMULATE)) <= 0) continue;
            sorting.put(new FluidPipeBlockEntity.DirectionalFluidOutput(handler, f, tile), temp);
            sum += temp;
        }
        if (sum > 0) {
            int f = 0;
            int i = 0;
            for (FluidPipeBlockEntity.DirectionalFluidOutput output : sorting.keySet()) {
                float prio = (float)((Integer)sorting.get(output)).intValue() / (float)sum;
                int amount = (int)((float)fluidForSort * prio);
                if (i++ == sorting.size() - 1) {
                    amount = canAccept;
                }
                insertResource = Utils.copyFluidStackWithAmount(fs, amount, true);
                if (output.containingTile() instanceof FluidPipeBlockEntity && this.energyStorage.extractEnergy(accelPower, true) >= accelPower) {
                    this.energyStorage.extractEnergy(accelPower, false);
                    insertResource.getOrCreateTag().m_128379_("pressurized", true);
                }
                int r = output.output().fill(insertResource, action);
                f += r;
                if ((canAccept -= r) > 0) continue;
                break;
            }
            return f;
        }
        return 0;
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
        int[] sideConfigArray = nbt.m_128465_("sideConfig");
        for (Direction d : DirectionUtils.VALUES) {
            this.sideConfig.put(d, IEEnums.IOSideConfig.VALUES[sideConfigArray[d.ordinal()]]);
        }
        if (nbt.m_128425_("placeCobble", 1)) {
            this.placeCobble = nbt.m_128471_("placeCobble");
        }
        this.tank.readFromNBT(nbt.m_128469_("tank"));
        EnergyHelper.deserializeFrom(this.energyStorage, nbt);
        if (descPacket) {
            this.markContainingBlockForUpdate(null);
        }
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        int[] sideConfigArray = new int[6];
        for (Direction d : DirectionUtils.VALUES) {
            sideConfigArray[d.ordinal()] = this.sideConfig.get(d).ordinal();
        }
        nbt.m_128385_("sideConfig", sideConfigArray);
        nbt.m_128379_("placeCobble", this.placeCobble);
        nbt.m_128365_("tank", (Tag)this.tank.writeToNBT(new CompoundTag()));
        EnergyHelper.serializeTo(this.energyStorage, nbt);
    }

    @Override
    public IEEnums.IOSideConfig getSideConfig(Direction side) {
        return this.sideConfig.get(side);
    }

    @Override
    public boolean toggleSide(Direction side, Player p) {
        if (side != Direction.UP && !this.isDummy()) {
            this.sideConfig.put(side, IEEnums.IOSideConfig.next(this.sideConfig.get(side)));
            this.m_6596_();
            this.markContainingBlockForUpdate(null);
            this.getLevelNonnull().m_7696_(this.m_58899_(), this.m_58900_().m_60734_(), 0, 0);
            return true;
        }
        if (p.m_6144_()) {
            BlockEntity tmp;
            FluidPumpBlockEntity master = this;
            if (this.isDummy() && (tmp = this.f_58857_.m_7702_(this.f_58858_.m_7495_())) instanceof FluidPumpBlockEntity) {
                master = (FluidPumpBlockEntity)tmp;
            }
            master.placeCobble = !master.placeCobble;
            p.m_5661_((Component)Component.m_237115_((String)("chat.immersiveengineering.info.pump.placeCobble." + master.placeCobble)), true);
            return true;
        }
        return false;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == ForgeCapabilities.ENERGY && (facing == null || facing == Direction.UP && this.isDummy())) {
            return this.energyCap.getAndCast();
        }
        if (capability == ForgeCapabilities.FLUID_HANDLER && facing != null && !this.isDummy()) {
            if (!this.sidedFluidHandler.containsKey(facing)) {
                this.sidedFluidHandler.put(facing, this.registerCapability(new SidedFluidHandler(this, facing)));
            }
            return this.sidedFluidHandler.get(facing).cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public Component[] getOverlayText(Player player, HitResult mop, boolean hammer) {
        if (hammer && ((Boolean)IEClientConfig.showTextOverlay.get()).booleanValue() && !this.isDummy() && mop instanceof BlockHitResult) {
            BlockHitResult brtr = (BlockHitResult)mop;
            IEEnums.IOSideConfig i = this.sideConfig.get(brtr.m_82434_());
            IEEnums.IOSideConfig j = this.sideConfig.get(brtr.m_82434_().m_122424_());
            return TextUtils.sideConfigWithOpposite("desc.immersiveengineering.info.blockSide.connectFluid.", i, j);
        }
        return null;
    }

    @Override
    public boolean useNixieFont(Player player, HitResult mop) {
        return false;
    }

    public void setDummy(boolean dummy) {
        BlockState old = this.m_58900_();
        BlockState newState = (BlockState)old.m_61124_((Property)IEProperties.MULTIBLOCKSLAVE, (Comparable)Boolean.valueOf(dummy));
        this.setState(newState);
    }

    @Override
    public boolean isDummy() {
        return (Boolean)this.m_58900_().m_61143_((Property)IEProperties.MULTIBLOCKSLAVE);
    }

    @Override
    @Nullable
    public FluidPumpBlockEntity master() {
        FluidPumpBlockEntity pump;
        if (!this.isDummy()) {
            return this;
        }
        BlockPos masterPos = this.m_58899_().m_7495_();
        BlockEntity te = Utils.getExistingTileEntity(this.f_58857_, masterPos);
        return te instanceof FluidPumpBlockEntity ? (pump = (FluidPumpBlockEntity)te) : null;
    }

    @Override
    public void placeDummies(BlockPlaceContext ctx, BlockState state) {
        BlockPos dummyPos = this.f_58858_.m_7494_();
        this.getLevelNonnull().m_46597_(dummyPos, IEBaseBlock.applyLocationalWaterlogging((BlockState)state.m_61124_((Property)IEProperties.MULTIBLOCKSLAVE, (Comparable)Boolean.valueOf(true)), this.getLevelNonnull(), dummyPos));
    }

    @Override
    public void breakDummies(BlockPos pos, BlockState state) {
        for (int i = 0; i <= 1; ++i) {
            if (!Utils.isBlockAt(this.f_58857_, this.m_58899_().m_7918_(0, this.isDummy() ? -1 : 0, 0).m_7918_(0, i, 0), IEBlocks.MetalDevices.FLUID_PUMP.get())) continue;
            this.f_58857_.m_7471_(this.m_58899_().m_7918_(0, this.isDummy() ? -1 : 0, 0).m_7918_(0, i, 0), false);
        }
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable CollisionContext ctx) {
        if (!this.isDummy()) {
            return Shapes.m_83144_();
        }
        return Shapes.m_83048_((double)0.1875, (double)0.0, (double)0.1875, (double)0.8125, (double)1.0, (double)0.8125);
    }

    @Override
    public boolean canOutputPressurized(boolean consumePower) {
        int accelPower = (Integer)IEServerConfig.MACHINES.pump_consumption_accelerate.get();
        if (this.energyStorage.extractEnergy(accelPower, true) >= accelPower) {
            if (consumePower) {
                this.energyStorage.extractEnergy(accelPower, false);
            }
            return true;
        }
        return false;
    }

    static class SidedFluidHandler
    implements IFluidHandler {
        FluidPumpBlockEntity pump;
        Direction facing;

        SidedFluidHandler(FluidPumpBlockEntity pump, Direction facing) {
            this.pump = pump;
            this.facing = facing;
        }

        public int getTanks() {
            return this.pump.tank.getTanks();
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return this.pump.tank.getFluidInTank(tank);
        }

        public int getTankCapacity(int tank) {
            return this.pump.tank.getTankCapacity(tank);
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            if (this.pump.sideConfig.get(this.facing) != IEEnums.IOSideConfig.INPUT) {
                return false;
            }
            return this.pump.tank.isFluidValid(tank, stack);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (resource.isEmpty() || this.pump.sideConfig.get(this.facing) != IEEnums.IOSideConfig.INPUT) {
                return 0;
            }
            return this.pump.tank.fill(resource, action);
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return this.drain(resource.getAmount(), action);
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            if (this.pump.sideConfig.get(this.facing) != IEEnums.IOSideConfig.OUTPUT) {
                return FluidStack.EMPTY;
            }
            return this.pump.tank.drain(maxDrain, action);
        }
    }
}

