/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.entity;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.utils.client.ModelDataUtils;
import blusunrize.immersiveengineering.client.models.obj.callback.DynamicSubmodelCallbacks;
import blusunrize.immersiveengineering.client.render.tile.DynamicModel;
import blusunrize.immersiveengineering.common.entities.SawbladeEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Quaternionf;

public class SawbladeRenderer
extends EntityRenderer<SawbladeEntity> {
    public static final String NAME = "sawblade_entity";
    public static DynamicModel MODEL;
    public static final ResourceLocation SAWBLADE;
    private static final IEProperties.VisibilityList DYNAMIC_GROUPS;
    private final ItemRenderer itemRenderer;

    public SawbladeRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager);
        this.itemRenderer = renderManager.m_174025_();
    }

    public void render(SawbladeEntity entity, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        VertexConsumer builder = bufferIn.m_6299_(RenderType.m_110466_());
        BlockRenderDispatcher blockRenderer = Minecraft.m_91087_().m_91289_();
        BlockPos blockPos = entity.m_20183_();
        BlockState state = entity.m_20193_().m_8055_(blockPos);
        BakedModel model = MODEL.get();
        matrixStackIn.m_85836_();
        matrixStackIn.m_85841_(0.75f, 0.75f, 0.75f);
        double yaw = entity.f_19859_ + (entity.m_146908_() - entity.f_19859_) * partialTicks - 90.0f;
        double pitch = entity.f_19860_ + (entity.m_146909_() - entity.f_19860_) * partialTicks;
        matrixStackIn.m_252781_(new Quaternionf().rotateY((float)Math.toRadians(yaw)).rotateZ((float)Math.toRadians(pitch)));
        if (!entity.isInGround()) {
            float spin = ((float)entity.f_19797_ + partialTicks) % 10.0f / 10.0f * ((float)Math.PI * 2);
            matrixStackIn.m_252781_(new Quaternionf().rotateY(spin));
        }
        RenderType renderType = Sheets.m_110790_();
        List quads = model.getQuads(state, null, RandomSource.m_216327_(), ModelDataUtils.single(DynamicSubmodelCallbacks.getProperty(), DYNAMIC_GROUPS), renderType);
        this.itemRenderer.m_115162_(matrixStackIn, bufferIn.m_6299_(renderType), quads, entity.getAmmo(), packedLightIn, OverlayTexture.f_118083_);
        matrixStackIn.m_85849_();
    }

    public ResourceLocation getTextureLocation(@Nonnull SawbladeEntity entity) {
        return SAWBLADE;
    }

    static {
        SAWBLADE = new ResourceLocation("immersiveengineering", "item/sawblade_blade");
        DYNAMIC_GROUPS = IEProperties.VisibilityList.show("blade");
    }
}

