/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.custom_bogeys.renderer.standard;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.core.PartialModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.railwayteam.railways.content.handcar.ik.DoubleArmIK;
import com.railwayteam.railways.registry.CRBlockPartials;
import com.simibubi.create.content.trains.bogey.BogeyRenderer;
import com.simibubi.create.content.trains.bogey.BogeySizes;
import com.simibubi.create.content.trains.entity.CarriageBogey;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.foundation.utility.Iterate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class HandcarBogeyRenderer
extends BogeyRenderer {
    private CarriageBogey carriageBogey;

    public void initialiseContraptionModelData(MaterialManager materialManager, CarriageBogey carriageBogey) {
        this.createModelInstance(materialManager, CRBlockPartials.HANDCAR_WHEELS, 2);
        this.createModelInstance(materialManager, new PartialModel[]{CRBlockPartials.HANDCAR_COUPLING, CRBlockPartials.HANDCAR_FRAME, CRBlockPartials.HANDCAR_HANDLE_FIRST_PERSON, CRBlockPartials.HANDCAR_HANDLE, CRBlockPartials.HANDCAR_LARGE_COG, CRBlockPartials.HANDCAR_SMALL_COG});
        this.carriageBogey = carriageBogey;
    }

    public BogeySizes.BogeySize getSize() {
        return BogeySizes.SMALL;
    }

    private boolean isFirstPerson() {
        Entity entity;
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (!mc.f_91066_.m_92176_().m_90612_()) {
            return false;
        }
        if (player != null && (entity = player.m_20201_()) instanceof CarriageContraptionEntity) {
            CarriageContraptionEntity cce = (CarriageContraptionEntity)entity;
            if (this.carriageBogey == null) {
                return true;
            }
            return cce.trainId.equals(this.carriageBogey.carriage.train.id) && cce.carriageIndex == this.carriageBogey.carriage.train.carriages.indexOf(this.carriageBogey.carriage);
        }
        return false;
    }

    public void render(CompoundTag bogeyData, float wheelAngle, PoseStack ms, int light, VertexConsumer vb, boolean inContraption) {
        boolean inInstancedContraption = vb == null;
        this.getTransform(CRBlockPartials.HANDCAR_FRAME, ms, inInstancedContraption).translate(0.0, 0.3125, 0.0).render(ms, light, vb);
        double couple_r = 0.1875 * (double)Mth.f_13994_;
        double couple_degrees = (double)(-(wheelAngle *= 2.0f) / 2.0f) - 22.5;
        float couple_radians = (float)(couple_degrees * 0.01745329238474369);
        double couple_x = couple_r * (double)Mth.m_14031_((float)couple_radians);
        double couple_y = couple_r * (double)Mth.m_14089_((float)couple_radians);
        Vec3 coupling_pos = new Vec3(0.109375, 0.75 + couple_y, -0.21875 + couple_x);
        Vec2 upperVec2 = new Vec2(0.0f, 2.4375f);
        Vec2 couplingVec2 = new Vec2((float)coupling_pos.f_82481_, (float)coupling_pos.f_82480_);
        Vec2 hingeOffset = DoubleArmIK.calculateJointOffset(upperVec2, couplingVec2, 0.875, 1.125);
        Vec2 hingePos2 = hingeOffset.m_165910_(couplingVec2);
        double couplingAngle = Mth.m_14136_((double)hingeOffset.f_82471_, (double)hingeOffset.f_82470_);
        Vec2 handle_offset = hingePos2.m_165910_(upperVec2.m_165913_());
        double handleAngle = Mth.m_14136_((double)handle_offset.f_82471_, (double)handle_offset.f_82470_);
        boolean firstPerson = this.isFirstPerson();
        ((BogeyRenderer.BogeyModelData)((BogeyRenderer.BogeyModelData)((BogeyRenderer.BogeyModelData)((BogeyRenderer.BogeyModelData)((BogeyRenderer.BogeyModelData)this.getTransform(CRBlockPartials.HANDCAR_HANDLE, ms, inInstancedContraption).translateY(2.4375)).rotateZ(180.0)).rotateXRadians(handleAngle - Math.toRadians(57.5))).translateY(-2.125)).scale(firstPerson ? 0.0f : 1.0f)).render(ms, light, vb);
        ((BogeyRenderer.BogeyModelData)((BogeyRenderer.BogeyModelData)((BogeyRenderer.BogeyModelData)((BogeyRenderer.BogeyModelData)((BogeyRenderer.BogeyModelData)this.getTransform(CRBlockPartials.HANDCAR_HANDLE_FIRST_PERSON, ms, inInstancedContraption).translateY(2.4375)).rotateZ(180.0)).rotateXRadians(handleAngle - Math.toRadians(57.5))).translateY(-2.125)).scale(firstPerson ? 1.0f : 0.0f)).render(ms, light, vb);
        ((BogeyRenderer.BogeyModelData)((BogeyRenderer.BogeyModelData)this.getTransform(CRBlockPartials.HANDCAR_COUPLING, ms, inInstancedContraption).translate(coupling_pos)).rotateXRadians(-(couplingAngle - 1.5707963705062866))).render(ms, light, vb);
        ((BogeyRenderer.BogeyModelData)((BogeyRenderer.BogeyModelData)this.getTransform(CRBlockPartials.HANDCAR_LARGE_COG, ms, inInstancedContraption).translate(-0.5, 0.75, -0.21875).rotateX((double)(-wheelAngle / 2.0f) + 22.5)).rotateZ(90.0)).translate(0.0, -0.4375, 0.0).render(ms, light, vb);
        ((BogeyRenderer.BogeyModelData)((BogeyRenderer.BogeyModelData)this.getTransform(CRBlockPartials.HANDCAR_SMALL_COG, ms, inInstancedContraption).translate(-0.5, 0.75, -1.0).rotateX((double)wheelAngle)).rotateZ(90.0)).translate(0.0, -0.4375, 0.0).render(ms, light, vb);
        BogeyRenderer.BogeyModelData[] wheels = this.getTransform(CRBlockPartials.HANDCAR_WHEELS, ms, inInstancedContraption, 2);
        for (int side : Iterate.positiveAndNegative) {
            if (!inInstancedContraption) {
                ms.m_85836_();
            }
            ((BogeyRenderer.BogeyModelData)wheels[(side + 1) / 2].translate(0.0, 0.75, (double)side).rotateX((double)wheelAngle)).translate(0.0, -0.75, 0.0).render(ms, light, vb);
            if (inInstancedContraption) continue;
            ms.m_85849_();
        }
    }
}

