/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.conductor;

import com.railwayteam.railways.Railways;
import com.railwayteam.railways.content.conductor.ConductorEntity;
import com.railwayteam.railways.content.conductor.forge.ConductorCapItemImpl;
import com.simibubi.create.AllBlocks;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public abstract class ConductorCapItem
extends ArmorItem {
    public final DyeColor color;
    public final ResourceLocation textureId;
    public final String textureStr;

    protected ConductorCapItem(Item.Properties props, DyeColor color) {
        super((ArmorMaterial)new ConductorArmorMaterial(), ArmorItem.Type.HELMET, props);
        this.color = color;
        String colorName = color.m_41065_().toLowerCase(Locale.ROOT);
        this.textureId = Railways.asResource("textures/entity/caps/%s_conductor_cap.png".formatted(colorName));
        this.textureStr = this.textureId.toString();
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ConductorCapItem create(Item.Properties props, DyeColor color) {
        void var1_1;
        return ConductorCapItemImpl.create(props, (DyeColor)var1_1);
    }

    static boolean isCasing(Block block) {
        return block.equals(AllBlocks.ANDESITE_CASING.get());
    }

    static boolean isCasing(BlockState state) {
        return ConductorCapItem.isCasing(state.m_60734_());
    }

    static boolean isCasing(Level level, BlockPos pos) {
        return ConductorCapItem.isCasing(level.m_8055_(pos));
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext ctx) {
        BlockPos pos;
        Level level = ctx.m_43725_();
        if (ConductorCapItem.isCasing(level, pos = ctx.m_8083_())) {
            if (level.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            level.m_7471_(pos, false);
            ConductorEntity.spawn(level, pos, ctx.m_43722_().m_41777_());
            if (ctx.m_43723_() != null && !ctx.m_43723_().m_7500_()) {
                ctx.m_43722_().m_41774_(1);
                return InteractionResult.CONSUME;
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6225_(ctx);
    }

    static class ConductorArmorMaterial
    implements ArmorMaterial {
        ConductorArmorMaterial() {
        }

        public int m_266425_(@NotNull ArmorItem.Type type) {
            return 0;
        }

        public int m_7366_(@NotNull ArmorItem.Type type) {
            return 0;
        }

        public int m_6646_() {
            return 0;
        }

        @NotNull
        public SoundEvent m_7344_() {
            return SoundEvents.f_11678_;
        }

        @NotNull
        public Ingredient m_6230_() {
            return Ingredient.f_43901_;
        }

        @NotNull
        public String m_6082_() {
            return "conductor_cap";
        }

        public float m_6651_() {
            return 0.0f;
        }

        public float m_6649_() {
            return 0.0f;
        }
    }
}

