/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks.blockimpl;

import blusunrize.immersiveengineering.api.multiblocks.blocks.MultiblockRegistration;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IClientTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IMultiblockComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.CapabilityPosition;
import blusunrize.immersiveengineering.common.blocks.multiblocks.blockimpl.WrappingMultiblockContext;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public record ComponentInstance<S>(IMultiblockComponent<S> component, IMultiblockContext<S> wrappedContext) {
    public static <S, O> ComponentInstance<S> make(MultiblockRegistration.ExtraComponent<O, S> c, O state, IMultiblockContext<?> ctx) {
        S wrappedState = c.makeWrapper().wrapState(state);
        IMultiblockContext<Object> wrapped = wrappedState == state ? ctx : new WrappingMultiblockContext<S>(ctx, c.makeWrapper().wrapState(state));
        return new ComponentInstance<S>(c.component(), wrapped);
    }

    public <T> LazyOptional<T> getCapability(CapabilityPosition position, Capability<T> cap) {
        return this.component.getCapability(this.wrappedContext, position, cap);
    }

    public void onEntityCollision(BlockPos positionInMB, Entity collided) {
        this.component.onEntityCollision(this.wrappedContext, positionInMB, collided);
    }

    public InteractionResult click(BlockPos positionInMB, Player player, InteractionHand hand, BlockHitResult hit, boolean isClientSide) {
        return this.component.click(this.wrappedContext, positionInMB, player, hand, hit, isClientSide);
    }

    public void dropExtraItems(Consumer<ItemStack> drop) {
        this.component.dropExtraItems(this.wrappedContext().getState(), drop);
    }

    public void tickServer() {
        IMultiblockComponent<S> iMultiblockComponent = this.component;
        if (iMultiblockComponent instanceof IServerTickableComponent) {
            IServerTickableComponent serverTickable = (IServerTickableComponent)iMultiblockComponent;
            serverTickable.tickServer(this.wrappedContext);
        }
    }

    public void tickClient() {
        IMultiblockComponent<S> iMultiblockComponent = this.component;
        if (iMultiblockComponent instanceof IClientTickableComponent) {
            IClientTickableComponent clientTickable = (IClientTickableComponent)iMultiblockComponent;
            clientTickable.tickClient(this.wrappedContext);
        }
    }

    public S state() {
        return this.wrappedContext.getState();
    }
}

