/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.utils;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.utils.BakedQuadBuilder;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import blusunrize.immersiveengineering.mixin.accessors.client.SimpleModelAccess;
import com.mojang.math.Transformation;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.RenderTypeGroup;
import net.minecraftforge.client.model.data.ModelData;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ModelUtils {
    public static RenderTypeGroup copyTypes(SimpleBakedModel simpleModel) {
        SimpleModelAccess access = (SimpleModelAccess)simpleModel;
        ChunkRenderTypeSet blockTypes = access.getBlockRenderTypes();
        if (blockTypes == null || blockTypes.isEmpty()) {
            return RenderTypeGroup.EMPTY;
        }
        List<RenderType> itemTypes = access.getItemRenderTypes();
        List<RenderType> fabulousItemTypes = access.getFabulousItemRenderTypes();
        return new RenderTypeGroup((RenderType)blockTypes.iterator().next(), itemTypes.get(0), fabulousItemTypes.get(0));
    }

    public static Transformation fromItemTransform(ItemTransform transform, boolean leftHand) {
        Vector3f translate = transform.f_111756_;
        if (leftHand) {
            translate = new Vector3f((Vector3fc)translate);
            translate.setComponent(0, -translate.x());
        }
        float leftRX = transform.f_111755_.x();
        float leftRY = transform.f_111755_.y();
        float leftRZ = transform.f_111755_.z();
        if (leftHand) {
            leftRY = -leftRY;
            leftRZ = -leftRZ;
        }
        Quaternionf leftRotation = new Quaternionf().rotateXYZ((float)Math.PI / 180 * leftRX, (float)Math.PI / 180 * leftRY, (float)Math.PI / 180 * leftRZ);
        float rightRX = transform.rightRotation.x();
        float rightRY = transform.rightRotation.y() * (float)(leftHand ? -1 : 1);
        float rightRZ = transform.rightRotation.z() * (float)(leftHand ? -1 : 1);
        Quaternionf rightRotation = new Quaternionf().rotateXYZ((float)Math.PI / 180 * rightRX, (float)Math.PI / 180 * rightRY, (float)Math.PI / 180 * rightRZ);
        return new Transformation(translate, leftRotation, transform.f_111757_, rightRotation);
    }

    public static Set<BakedQuad> createBakedBox(Vec3 from, Vec3 to, Matrix4 matrix, Direction facing, Function<Direction, TextureAtlasSprite> textureGetter, float[] colour) {
        return ModelUtils.createBakedBox(from, to, matrix, facing, vertices -> vertices, textureGetter, colour);
    }

    @Nonnull
    public static Set<BakedQuad> createBakedBox(Vec3 from, Vec3 to, Matrix4 matrixIn, Direction facing, Function<Vec3[], Vec3[]> vertexTransformer, Function<Direction, TextureAtlasSprite> textureGetter, float[] colour) {
        Vec3 v2;
        int i;
        Transformation matrix = matrixIn.toTransformationMatrix();
        HashSet<BakedQuad> quads = new HashSet<BakedQuad>();
        if (vertexTransformer == null) {
            vertexTransformer = v -> v;
        }
        Vec3[] vertices = new Vec3[]{new Vec3(from.f_82479_, from.f_82480_, from.f_82481_), new Vec3(from.f_82479_, from.f_82480_, to.f_82481_), new Vec3(to.f_82479_, from.f_82480_, to.f_82481_), new Vec3(to.f_82479_, from.f_82480_, from.f_82481_)};
        TextureAtlasSprite sprite = textureGetter.apply(Direction.DOWN);
        if (sprite != null) {
            quads.add(ModelUtils.createBakedQuad(ClientUtils.applyMatrixToVertices(matrix, vertexTransformer.apply(vertices)), Utils.rotateFacingTowardsDir(Direction.DOWN, facing), sprite, new double[]{from.f_82479_ * 16.0, 16.0 - from.f_82481_ * 16.0, to.f_82479_ * 16.0, 16.0 - to.f_82481_ * 16.0}, colour, true));
        }
        for (i = 0; i < vertices.length; ++i) {
            v2 = vertices[i];
            vertices[i] = new Vec3(v2.f_82479_, to.f_82480_, v2.f_82481_);
        }
        sprite = textureGetter.apply(Direction.UP);
        if (sprite != null) {
            quads.add(ModelUtils.createBakedQuad(ClientUtils.applyMatrixToVertices(matrix, vertexTransformer.apply(vertices)), Utils.rotateFacingTowardsDir(Direction.UP, facing), sprite, new double[]{from.f_82479_ * 16.0, from.f_82481_ * 16.0, to.f_82479_ * 16.0, to.f_82481_ * 16.0}, colour, false));
        }
        vertices = new Vec3[]{new Vec3(to.f_82479_, to.f_82480_, from.f_82481_), new Vec3(to.f_82479_, from.f_82480_, from.f_82481_), new Vec3(from.f_82479_, from.f_82480_, from.f_82481_), new Vec3(from.f_82479_, to.f_82480_, from.f_82481_)};
        sprite = textureGetter.apply(Direction.NORTH);
        if (sprite != null) {
            quads.add(ModelUtils.createBakedQuad(ClientUtils.applyMatrixToVertices(matrix, vertexTransformer.apply(vertices)), Utils.rotateFacingTowardsDir(Direction.NORTH, facing), sprite, new double[]{from.f_82479_ * 16.0, 16.0 - to.f_82480_ * 16.0, to.f_82479_ * 16.0, 16.0 - from.f_82480_ * 16.0}, colour, false));
        }
        for (i = 0; i < vertices.length; ++i) {
            v2 = vertices[i];
            vertices[i] = new Vec3(v2.f_82479_, v2.f_82480_, to.f_82481_);
        }
        sprite = textureGetter.apply(Direction.SOUTH);
        if (sprite != null) {
            quads.add(ModelUtils.createBakedQuad(ClientUtils.applyMatrixToVertices(matrix, vertexTransformer.apply(vertices)), Utils.rotateFacingTowardsDir(Direction.SOUTH, facing), sprite, new double[]{to.f_82479_ * 16.0, 16.0 - to.f_82480_ * 16.0, from.f_82479_ * 16.0, 16.0 - from.f_82480_ * 16.0}, colour, true));
        }
        vertices = new Vec3[]{new Vec3(from.f_82479_, to.f_82480_, to.f_82481_), new Vec3(from.f_82479_, from.f_82480_, to.f_82481_), new Vec3(from.f_82479_, from.f_82480_, from.f_82481_), new Vec3(from.f_82479_, to.f_82480_, from.f_82481_)};
        sprite = textureGetter.apply(Direction.WEST);
        if (sprite != null) {
            quads.add(ModelUtils.createBakedQuad(ClientUtils.applyMatrixToVertices(matrix, vertexTransformer.apply(vertices)), Utils.rotateFacingTowardsDir(Direction.WEST, facing), sprite, new double[]{to.f_82481_ * 16.0, 16.0 - to.f_82480_ * 16.0, from.f_82481_ * 16.0, 16.0 - from.f_82480_ * 16.0}, colour, true));
        }
        for (i = 0; i < vertices.length; ++i) {
            v2 = vertices[i];
            vertices[i] = new Vec3(to.f_82479_, v2.f_82480_, v2.f_82481_);
        }
        sprite = textureGetter.apply(Direction.EAST);
        if (sprite != null) {
            quads.add(ModelUtils.createBakedQuad(ClientUtils.applyMatrixToVertices(matrix, vertexTransformer.apply(vertices)), Utils.rotateFacingTowardsDir(Direction.EAST, facing), sprite, new double[]{16.0 - to.f_82481_ * 16.0, 16.0 - to.f_82480_ * 16.0, 16.0 - from.f_82481_ * 16.0, 16.0 - from.f_82480_ * 16.0}, colour, false));
        }
        return quads;
    }

    public static BakedQuad createBakedQuad(Vec3[] vertices, Direction facing, TextureAtlasSprite sprite, double[] uvs, float[] colour, boolean invert) {
        BakedQuadBuilder builder = new BakedQuadBuilder();
        Vec3i normalInt = facing.m_122436_();
        Vec3 faceNormal = new Vec3((double)normalInt.m_123341_(), (double)normalInt.m_123342_(), (double)normalInt.m_123343_());
        int vId = invert ? 3 : 0;
        int u = vId > 1 ? 2 : 0;
        builder.putVertexData(vertices[vId], faceNormal, uvs[u], uvs[1], sprite, colour, 1.0f);
        vId = invert ? 2 : 1;
        u = vId > 1 ? 2 : 0;
        builder.putVertexData(vertices[vId], faceNormal, uvs[u], uvs[3], sprite, colour, 1.0f);
        vId = invert ? 1 : 2;
        u = vId > 1 ? 2 : 0;
        builder.putVertexData(vertices[vId], faceNormal, uvs[u], uvs[3], sprite, colour, 1.0f);
        vId = invert ? 0 : 3;
        u = vId > 1 ? 2 : 0;
        builder.putVertexData(vertices[vId], faceNormal, uvs[u], uvs[1], sprite, colour, 1.0f);
        return builder.bake(-1, facing, sprite, true);
    }

    public static ResourceLocation getSideTexture(@Nonnull ItemStack stack, Direction side) {
        BakedModel model = ClientUtils.mc().m_91291_().m_174264_(stack, null, null, 0);
        return ModelUtils.getSideTexture(model, side, null);
    }

    public static ResourceLocation getSideTexture(@Nonnull BlockState state, Direction side) {
        BakedModel model = ClientUtils.mc().m_91289_().m_110910_(state);
        return ModelUtils.getSideTexture(model, side, state);
    }

    public static ResourceLocation getSideTexture(@Nonnull BakedModel model, Direction side, @Nullable BlockState state) {
        List quads = model.getQuads(state, side, ApiUtils.RANDOM_SOURCE, ModelData.EMPTY, null);
        if (quads.isEmpty()) {
            quads = model.getQuads(state, null, ApiUtils.RANDOM_SOURCE, ModelData.EMPTY, null);
        }
        if (quads.isEmpty()) {
            return null;
        }
        return ((BakedQuad)quads.get(0)).m_173410_().m_245424_().m_246162_();
    }

    public static BakedQuad reverseOrder(BakedQuad in) {
        int[] oldData = in.m_111303_();
        int[] newData = new int[oldData.length];
        int vertexLength = oldData.length / 4;
        for (int i = 0; i < 4; ++i) {
            System.arraycopy(oldData, i * vertexLength, newData, (3 - i) * vertexLength, vertexLength);
        }
        return new BakedQuad(newData, in.m_111305_(), in.m_111306_(), in.m_173410_(), in.m_111307_());
    }
}

