/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.world.data;

import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityTombstone;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.world.data.MaidInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class MaidWorldData
extends SavedData {
    private static final String IDENTIFIER = "touhou_little_maid_world_data";
    private static final String MAID_INFOS_TAG = "MaidInfos";
    private static final String MAID_TOMBSTONES_TAG = "MaidTombstones";
    private final Map<UUID, List<MaidInfo>> infos = Maps.newHashMap();
    private final Map<UUID, List<MaidInfo>> tombstones = Maps.newHashMap();

    @Nullable
    public static MaidWorldData get(Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel overWorld = level.m_7654_().m_129880_(Level.f_46428_);
            if (overWorld == null) {
                return null;
            }
            DimensionDataStorage storage = overWorld.m_8895_();
            MaidWorldData data = (MaidWorldData)storage.m_164861_(MaidWorldData::load, MaidWorldData::new, IDENTIFIER);
            data.m_77762_();
            return data;
        }
        return null;
    }

    public static MaidWorldData load(CompoundTag tag) {
        MutableComponent name;
        long timestamp;
        UUID ownerId;
        BlockPos chunkPos;
        String dimension;
        CompoundTag infoTag;
        int i;
        ListTag listTag;
        MaidWorldData data = new MaidWorldData();
        if (tag.m_128425_(MAID_INFOS_TAG, 10)) {
            CompoundTag infosTag = tag.m_128469_(MAID_INFOS_TAG);
            for (String key : infosTag.m_128431_()) {
                listTag = infosTag.m_128437_(key, 10);
                for (i = 0; i < listTag.size(); ++i) {
                    infoTag = listTag.m_128728_(i);
                    dimension = infoTag.m_128461_("Dimension");
                    chunkPos = NbtUtils.m_129239_((CompoundTag)infoTag.m_128469_("ChunkPos"));
                    ownerId = infoTag.m_128342_("OwnerId");
                    UUID maidId = infoTag.m_128342_("MaidId");
                    timestamp = infoTag.m_128454_("Timestamp");
                    name = Component.Serializer.m_130701_((String)infoTag.m_128461_("Name"));
                    List maidInfos = data.infos.computeIfAbsent(ownerId, uuid -> Lists.newArrayList());
                    maidInfos.add(new MaidInfo(dimension, chunkPos, ownerId, maidId, timestamp, (Component)name));
                }
            }
        }
        if (tag.m_128425_(MAID_TOMBSTONES_TAG, 10)) {
            CompoundTag tombstonesTag = tag.m_128469_(MAID_TOMBSTONES_TAG);
            for (String key : tombstonesTag.m_128431_()) {
                listTag = tombstonesTag.m_128437_(key, 10);
                for (i = 0; i < listTag.size(); ++i) {
                    infoTag = listTag.m_128728_(i);
                    dimension = infoTag.m_128461_("Dimension");
                    chunkPos = NbtUtils.m_129239_((CompoundTag)infoTag.m_128469_("ChunkPos"));
                    ownerId = infoTag.m_128342_("OwnerId");
                    UUID tombstoneId = infoTag.m_128342_("TombstoneId");
                    timestamp = infoTag.m_128454_("Timestamp");
                    name = Component.Serializer.m_130701_((String)infoTag.m_128461_("Name"));
                    List tombstoneInfos = data.tombstones.computeIfAbsent(ownerId, uuid -> Lists.newArrayList());
                    tombstoneInfos.add(new MaidInfo(dimension, chunkPos, ownerId, tombstoneId, timestamp, (Component)name));
                }
            }
        }
        return data;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        CompoundTag infosTag = new CompoundTag();
        this.infos.forEach((id, data) -> {
            ListTag listTag = new ListTag();
            data.forEach(info -> {
                CompoundTag infoTag = new CompoundTag();
                infoTag.m_128359_("Dimension", info.getDimension());
                infoTag.m_128365_("ChunkPos", (Tag)NbtUtils.m_129224_((BlockPos)info.getChunkPos()));
                infoTag.m_128362_("OwnerId", info.getOwnerId());
                infoTag.m_128362_("MaidId", info.getEntityId());
                infoTag.m_128356_("Timestamp", info.getTimestamp());
                infoTag.m_128359_("Name", Component.Serializer.m_130703_((Component)info.getName()));
                listTag.add((Object)infoTag);
            });
            infosTag.m_128365_(id.toString(), (Tag)listTag);
        });
        CompoundTag tombstonesTag = new CompoundTag();
        this.tombstones.forEach((id, data) -> {
            ListTag listTag = new ListTag();
            data.forEach(info -> {
                CompoundTag infoTag = new CompoundTag();
                infoTag.m_128359_("Dimension", info.getDimension());
                infoTag.m_128365_("ChunkPos", (Tag)NbtUtils.m_129224_((BlockPos)info.getChunkPos()));
                infoTag.m_128362_("OwnerId", info.getOwnerId());
                infoTag.m_128362_("TombstoneId", info.getEntityId());
                infoTag.m_128356_("Timestamp", info.getTimestamp());
                infoTag.m_128359_("Name", Component.Serializer.m_130703_((Component)info.getName()));
                listTag.add((Object)infoTag);
            });
            tombstonesTag.m_128365_(id.toString(), (Tag)listTag);
        });
        tag.m_128365_(MAID_INFOS_TAG, (Tag)infosTag);
        tag.m_128365_(MAID_TOMBSTONES_TAG, (Tag)tombstonesTag);
        return tag;
    }

    public void addInfo(MaidInfo info) {
        UUID ownerId = info.getOwnerId();
        List maidInfos = this.infos.computeIfAbsent(ownerId, uuid -> Lists.newArrayList());
        maidInfos.add(info);
        this.m_77762_();
    }

    public void addInfo(EntityMaid maid) {
        String dimension = maid.f_19853_.m_46472_().m_135782_().toString();
        BlockPos chunkPos = maid.m_20183_();
        UUID ownerId = maid.m_21805_();
        UUID maidId = maid.m_20148_();
        long timestamp = System.currentTimeMillis();
        Component name = maid.m_5446_();
        this.addInfo(new MaidInfo(dimension, chunkPos, ownerId, maidId, timestamp, name));
    }

    public void removeInfo(EntityMaid maid) {
        UUID ownerId = maid.m_21805_();
        if (this.infos.containsKey(ownerId)) {
            UUID maidId = maid.m_20148_();
            this.infos.get(ownerId).removeIf(info -> info.getEntityId().equals(maidId));
            this.m_77762_();
        }
    }

    @Nullable
    public List<MaidInfo> getInfos(UUID owner) {
        return this.infos.get(owner);
    }

    @Nullable
    public List<MaidInfo> getPlayerMaidInfos(Player player) {
        return this.infos.get(player.m_20148_());
    }

    public void addTombstones(MaidInfo info) {
        UUID ownerId = info.getOwnerId();
        List tombstoneInfos = this.tombstones.computeIfAbsent(ownerId, uuid -> Lists.newArrayList());
        tombstoneInfos.add(info);
        this.m_77762_();
    }

    public void addTombstones(EntityMaid maid, EntityTombstone tombstone) {
        String dimension = maid.f_19853_.m_46472_().m_135782_().toString();
        BlockPos chunkPos = tombstone.m_20183_();
        UUID ownerId = maid.m_21805_();
        UUID tombstoneId = tombstone.m_20148_();
        long timestamp = System.currentTimeMillis();
        Component name = maid.m_5446_();
        this.addTombstones(new MaidInfo(dimension, chunkPos, ownerId, tombstoneId, timestamp, name));
    }

    public void removeTombstones(EntityTombstone tombstone) {
        UUID ownerId = tombstone.getOwnerId();
        if (this.tombstones.containsKey(ownerId)) {
            UUID tombstoneId = tombstone.m_20148_();
            this.tombstones.get(ownerId).removeIf(info -> info.getEntityId().equals(tombstoneId));
            this.m_77762_();
        }
    }

    @Nullable
    public List<MaidInfo> getTombstones(UUID owner) {
        return this.tombstones.get(owner);
    }

    @Nullable
    public List<MaidInfo> getPlayerMaidTombstones(Player player) {
        return this.tombstones.get(player.m_20148_());
    }
}

