/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.util;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class VoxelShapeUtils {
    private static final Vec3 FROM_ORIGIN = new Vec3(-0.5, -0.5, -0.5);

    public static void print(double x1, double y1, double z1, double x2, double y2, double z2) {
        TouhouLittleMaid.LOGGER.info("box({}, {}, {}, {}, {}, {}),", (Object)Math.min(x1, x2), (Object)Math.min(y1, y2), (Object)Math.min(z1, z2), (Object)Math.max(x1, x2), (Object)Math.max(y1, y2), (Object)Math.max(z1, z2));
    }

    public static void printSimplified(String name, VoxelShape shape) {
        TouhouLittleMaid.LOGGER.info("Simplified: {}", (Object)name);
        shape.m_83296_().m_83299_().forEach(box -> VoxelShapeUtils.print(box.f_82288_ * 16.0, box.f_82289_ * 16.0, box.f_82290_ * 16.0, box.f_82291_ * 16.0, box.f_82292_ * 16.0, box.f_82293_ * 16.0));
    }

    public static AABB rotate(AABB box, Direction side) {
        return switch (side) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> box;
            case Direction.UP -> new AABB(box.f_82288_, -box.f_82289_, -box.f_82290_, box.f_82291_, -box.f_82292_, -box.f_82293_);
            case Direction.NORTH -> new AABB(box.f_82288_, -box.f_82290_, box.f_82289_, box.f_82291_, -box.f_82293_, box.f_82292_);
            case Direction.SOUTH -> new AABB(-box.f_82288_, -box.f_82290_, -box.f_82289_, -box.f_82291_, -box.f_82293_, -box.f_82292_);
            case Direction.WEST -> new AABB(box.f_82289_, -box.f_82290_, -box.f_82288_, box.f_82292_, -box.f_82293_, -box.f_82291_);
            case Direction.EAST -> new AABB(-box.f_82289_, -box.f_82290_, box.f_82288_, -box.f_82292_, -box.f_82293_, box.f_82291_);
        };
    }

    public static AABB rotate(AABB box, Rotation rotation) {
        return switch (rotation) {
            default -> throw new IncompatibleClassChangeError();
            case Rotation.NONE -> box;
            case Rotation.CLOCKWISE_90 -> new AABB(-box.f_82290_, box.f_82289_, box.f_82288_, -box.f_82293_, box.f_82292_, box.f_82291_);
            case Rotation.CLOCKWISE_180 -> new AABB(-box.f_82288_, box.f_82289_, -box.f_82290_, -box.f_82291_, box.f_82292_, -box.f_82293_);
            case Rotation.COUNTERCLOCKWISE_90 -> new AABB(box.f_82290_, box.f_82289_, -box.f_82288_, box.f_82293_, box.f_82292_, -box.f_82291_);
        };
    }

    public static AABB rotateHorizontal(AABB box, Direction side) {
        return switch (side) {
            case Direction.NORTH -> VoxelShapeUtils.rotate(box, Rotation.NONE);
            case Direction.SOUTH -> VoxelShapeUtils.rotate(box, Rotation.CLOCKWISE_180);
            case Direction.WEST -> VoxelShapeUtils.rotate(box, Rotation.COUNTERCLOCKWISE_90);
            case Direction.EAST -> VoxelShapeUtils.rotate(box, Rotation.CLOCKWISE_90);
            default -> box;
        };
    }

    public static VoxelShape rotate(VoxelShape shape, Direction side) {
        return VoxelShapeUtils.rotate(shape, box -> VoxelShapeUtils.rotate(box, side));
    }

    public static VoxelShape rotate(VoxelShape shape, Rotation rotation) {
        return VoxelShapeUtils.rotate(shape, box -> VoxelShapeUtils.rotate(box, rotation));
    }

    public static VoxelShape rotateHorizontal(VoxelShape shape, Direction side) {
        return VoxelShapeUtils.rotate(shape, box -> VoxelShapeUtils.rotateHorizontal(box, side));
    }

    public static VoxelShape rotate(VoxelShape shape, UnaryOperator<AABB> rotateFunction) {
        ArrayList<VoxelShape> rotatedPieces = new ArrayList<VoxelShape>();
        List sourceBoundingBoxes = shape.m_83299_();
        for (AABB sourceBoundingBox : sourceBoundingBoxes) {
            rotatedPieces.add(Shapes.m_83064_((AABB)((AABB)rotateFunction.apply(sourceBoundingBox.m_82386_(VoxelShapeUtils.FROM_ORIGIN.f_82479_, VoxelShapeUtils.FROM_ORIGIN.f_82480_, VoxelShapeUtils.FROM_ORIGIN.f_82481_))).m_82386_(-VoxelShapeUtils.FROM_ORIGIN.f_82479_, -VoxelShapeUtils.FROM_ORIGIN.f_82481_, -VoxelShapeUtils.FROM_ORIGIN.f_82481_)));
        }
        return VoxelShapeUtils.combine(rotatedPieces);
    }

    public static VoxelShape combine(VoxelShape ... shapes) {
        return VoxelShapeUtils.batchCombine(Shapes.m_83040_(), BooleanOp.f_82695_, true, shapes);
    }

    public static VoxelShape combine(Collection<VoxelShape> shapes) {
        return VoxelShapeUtils.batchCombine(Shapes.m_83040_(), BooleanOp.f_82695_, true, shapes);
    }

    public static VoxelShape exclude(VoxelShape ... shapes) {
        return VoxelShapeUtils.batchCombine(Shapes.m_83144_(), BooleanOp.f_82685_, true, shapes);
    }

    public static VoxelShape batchCombine(VoxelShape initial, BooleanOp function, boolean simplify, Collection<VoxelShape> shapes) {
        VoxelShape combinedShape = initial;
        for (VoxelShape shape : shapes) {
            combinedShape = Shapes.m_83148_((VoxelShape)combinedShape, (VoxelShape)shape, (BooleanOp)function);
        }
        return simplify ? combinedShape.m_83296_() : combinedShape;
    }

    public static VoxelShape batchCombine(VoxelShape initial, BooleanOp function, boolean simplify, VoxelShape ... shapes) {
        VoxelShape combinedShape = initial;
        for (VoxelShape shape : shapes) {
            combinedShape = Shapes.m_83148_((VoxelShape)combinedShape, (VoxelShape)shape, (BooleanOp)function);
        }
        return simplify ? combinedShape.m_83296_() : combinedShape;
    }
}

