/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.animated;

import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.animated.AnimatedGeoBone;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.render.built.GeoBone;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.render.built.GeoModel;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class AnimatedGeoModel {
    private final GeoModel geoModel;
    private final List<AnimatedGeoBone> topLevelBones;
    private final Map<String, AnimatedGeoBone> bones;
    private final List<AnimatedGeoBone> leftHandBones;
    private final List<AnimatedGeoBone> rightHandBones;
    private final List<AnimatedGeoBone> leftWaistBones;
    private final List<AnimatedGeoBone> rightWaistBones;
    private final List<AnimatedGeoBone> backpackBones;
    private final List<AnimatedGeoBone> tacPistolBones;
    private final List<AnimatedGeoBone> tacRifleBones;
    private final List<AnimatedGeoBone> headBones;
    @Nullable
    private final AnimatedGeoBone head;

    public AnimatedGeoModel(GeoModel model) {
        this.geoModel = model;
        Object2ObjectOpenHashMap bones = new Object2ObjectOpenHashMap();
        this.topLevelBones = ObjectLists.unmodifiable((ObjectList)new ObjectArrayList(model.topLevelBones().stream().map(b -> new AnimatedGeoBone((GeoBone)b, (Map<String, AnimatedGeoBone>)bones)).toList()));
        this.bones = Object2ObjectMaps.unmodifiable((Object2ObjectMap)bones);
        this.leftHandBones = this.getLocatorHierarchy("LeftHandLocator");
        this.rightHandBones = this.getLocatorHierarchy("RightHandLocator");
        this.leftWaistBones = this.getLocatorHierarchy("LeftWaistLocator");
        this.rightWaistBones = this.getLocatorHierarchy("RightWaistLocator");
        this.backpackBones = this.getLocatorHierarchy("BackpackLocator");
        this.tacPistolBones = this.getLocatorHierarchy("PistolLocator");
        this.tacRifleBones = this.getLocatorHierarchy("RifleLocator");
        this.headBones = this.getLocatorHierarchy("Head");
        this.head = (AnimatedGeoBone)bones.get((Object)"Head");
    }

    private List<AnimatedGeoBone> getLocatorHierarchy(String locatorName) {
        AnimatedGeoBone bone = this.bones.get(locatorName);
        if (bone == null) {
            return ObjectLists.emptyList();
        }
        ObjectArrayList list = new ObjectArrayList();
        while (true) {
            list.add((Object)bone);
            if (bone.geoBone().parent() == null) break;
            bone = Objects.requireNonNull(this.bones.get(bone.geoBone().parent().name()));
        }
        Collections.reverse(list);
        return ObjectLists.unmodifiable((ObjectList)list);
    }

    public GeoModel geoModel() {
        return this.geoModel;
    }

    public List<AnimatedGeoBone> topLevelBones() {
        return this.topLevelBones;
    }

    public Map<String, AnimatedGeoBone> bones() {
        return this.bones;
    }

    public List<AnimatedGeoBone> leftHandBones() {
        return this.leftHandBones;
    }

    public List<AnimatedGeoBone> rightHandBones() {
        return this.rightHandBones;
    }

    public List<AnimatedGeoBone> leftWaistBones() {
        return this.leftWaistBones;
    }

    public List<AnimatedGeoBone> rightWaistBones() {
        return this.rightWaistBones;
    }

    public List<AnimatedGeoBone> backpackBones() {
        return this.backpackBones;
    }

    public List<AnimatedGeoBone> tacPistolBones() {
        return this.tacPistolBones;
    }

    public List<AnimatedGeoBone> tacRifleBones() {
        return this.tacRifleBones;
    }

    public List<AnimatedGeoBone> headBones() {
        return this.headBones;
    }

    @Nullable
    public AnimatedGeoBone head() {
        return this.head;
    }
}

