/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.task;

import com.github.tartaricacid.touhoulittlemaid.api.task.IAttackTask;
import com.github.tartaricacid.touhoulittlemaid.api.task.IRangedAttackTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidAttackStrafingTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidShootTargetTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.util.ItemsUtil;
import com.github.tartaricacid.touhoulittlemaid.util.SoundUtil;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class TaskBowAttack
implements IRangedAttackTask {
    public static final ResourceLocation UID = new ResourceLocation("touhou_little_maid", "ranged_attack");
    private static final int MAX_STOP_ATTACK_DISTANCE = 16;

    @Override
    public ResourceLocation getUid() {
        return UID;
    }

    @Override
    public ItemStack getIcon() {
        return Items.f_42411_.m_7968_();
    }

    @Override
    @Nullable
    public SoundEvent getAmbientSound(EntityMaid maid) {
        return SoundUtil.attackSound(maid, (SoundEvent)InitSounds.MAID_RANGE_ATTACK.get(), 0.5f);
    }

    @Override
    public List<Pair<Integer, BehaviorControl<? super EntityMaid>>> createBrainTasks(EntityMaid maid) {
        BehaviorControl supplementedTask = StartAttacking.m_257741_(e -> this.hasBow((EntityMaid)e) && this.hasArrow((EntityMaid)e), IAttackTask::findFirstValidAttackTarget);
        BehaviorControl findTargetTask = StopAttackingIfTargetInvalid.m_257990_(target -> !this.hasBow(maid) || !this.hasArrow(maid) || this.farAway((LivingEntity)target, maid));
        BehaviorControl moveToTargetTask = SetWalkTargetFromAttackTargetIfTargetOutOfReach.m_257469_((float)0.6f);
        MaidAttackStrafingTask maidAttackStrafingTask = new MaidAttackStrafingTask();
        MaidShootTargetTask shootTargetTask = new MaidShootTargetTask(2);
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)5, (Object)supplementedTask), Pair.of((Object)5, (Object)findTargetTask), Pair.of((Object)5, (Object)moveToTargetTask), Pair.of((Object)5, (Object)((Object)maidAttackStrafingTask)), Pair.of((Object)5, (Object)((Object)shootTargetTask))});
    }

    @Override
    public void performRangedAttack(EntityMaid shooter, LivingEntity target, float distanceFactor) {
        ItemStack mainHandItem;
        AbstractArrow entityArrow = this.getArrow(shooter, distanceFactor);
        if (entityArrow != null && (mainHandItem = shooter.m_21205_()).m_41720_() instanceof BowItem) {
            double x = target.m_20185_() - shooter.m_20185_();
            double y = target.m_20191_().f_82289_ + (double)(target.m_20206_() / 3.0f) - entityArrow.m_20182_().f_82480_;
            double z = target.m_20189_() - shooter.m_20189_();
            double pitch = Math.sqrt(x * x + z * z) * 0.15;
            entityArrow.m_6686_(x, y + pitch, z, 1.6f, 1.0f);
            mainHandItem.m_41622_(1, (LivingEntity)shooter, maid -> maid.m_21190_(InteractionHand.MAIN_HAND));
            shooter.m_5496_(SoundEvents.f_12382_, 1.0f, 1.0f / (shooter.m_217043_().m_188501_() * 0.4f + 0.8f));
            shooter.f_19853_.m_7967_((Entity)entityArrow);
        }
    }

    @Override
    public List<Pair<String, Predicate<EntityMaid>>> getConditionDescription(EntityMaid maid) {
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)"has_bow", this::hasBow), Pair.of((Object)"has_arrow", this::hasArrow)});
    }

    private boolean hasBow(EntityMaid maid) {
        return maid.m_21205_().m_41720_() instanceof BowItem;
    }

    private boolean hasArrow(EntityMaid maid) {
        return this.findArrow(maid) >= 0;
    }

    private int findArrow(EntityMaid maid) {
        ItemStack mainHandItem = maid.m_21205_();
        if (mainHandItem.m_41720_() instanceof BowItem) {
            CombinedInvWrapper handler = maid.getAvailableInv(true);
            return ItemsUtil.findStackSlot((IItemHandler)handler, ((BowItem)mainHandItem.m_41720_()).m_6437_());
        }
        return -1;
    }

    @Nullable
    private AbstractArrow getArrow(EntityMaid maid, float chargeTime) {
        int slot = this.findArrow(maid);
        if (slot < 0) {
            return null;
        }
        CombinedInvWrapper handler = maid.getAvailableInv(true);
        ItemStack arrowStack = handler.getStackInSlot(slot);
        ItemStack mainHandItem = maid.m_21205_();
        AbstractArrow arrowEntity = ProjectileUtil.m_37300_((LivingEntity)maid, (ItemStack)arrowStack, (float)chargeTime);
        if (mainHandItem.m_41720_() instanceof BowItem) {
            arrowEntity = ((BowItem)mainHandItem.m_41720_()).customArrow(arrowEntity);
        }
        if (EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44952_, (ItemStack)mainHandItem) <= 0) {
            arrowStack.m_41774_(1);
            handler.setStackInSlot(slot, arrowStack);
            arrowEntity.f_36705_ = AbstractArrow.Pickup.ALLOWED;
        }
        AttributeInstance attackDamage = maid.m_21051_(Attributes.f_22281_);
        double attackValue = 2.0;
        if (attackDamage != null) {
            attackValue = attackDamage.m_22115_();
        }
        float multiplier = (float)(attackValue / 2.0);
        arrowEntity.m_36781_(arrowEntity.m_36789_() * (double)multiplier);
        return arrowEntity;
    }

    private boolean farAway(LivingEntity target, EntityMaid maid) {
        return maid.m_20270_((Entity)target) > 16.0f;
    }
}

