/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.api.task.meal.IMaidMeal;
import com.github.tartaricacid.touhoulittlemaid.api.task.meal.MaidMealType;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidCheckRateTask;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.ChatBubbleManger;
import com.github.tartaricacid.touhoulittlemaid.entity.favorability.Type;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntitySit;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.task.meal.MaidMealManager;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityPicnicMat;
import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RangedWrapper;

public class MaidHomeMealTask
extends MaidCheckRateTask {
    private static final int MAX_DELAY_TIME = 50;
    @Nullable
    private TileEntityPicnicMat tmpPicnicMat = null;

    public MaidHomeMealTask() {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of());
        this.setMaxCheckRate(50);
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel serverLevel, EntityMaid maid) {
        BlockPos blockPos;
        BlockEntity blockEntity;
        EntitySit sit;
        if (!super.checkExtraStartConditions(serverLevel, maid)) {
            return false;
        }
        if (!maid.getFavorabilityManager().canAdd(Type.HOME_MEAL.getTypeName())) {
            return false;
        }
        Entity entity = maid.m_20202_();
        if (entity instanceof EntitySit && (sit = (EntitySit)entity).getJoyType().equals(Type.ON_HOME_MEAL.getTypeName()) && (blockEntity = serverLevel.m_7702_(blockPos = sit.getAssociatedBlockPos())) instanceof TileEntityPicnicMat) {
            TileEntityPicnicMat picnicMat;
            this.tmpPicnicMat = picnicMat = (TileEntityPicnicMat)blockEntity;
            return true;
        }
        return false;
    }

    protected void start(ServerLevel serverLevel, EntityMaid maid, long gameTime) {
        if (this.tmpPicnicMat == null) {
            return;
        }
        List<IMaidMeal> maidMeals = MaidMealManager.getMaidMeals(MaidMealType.HOME_MEAL);
        InteractionHand eanHand = InteractionHand.OFF_HAND;
        for (InteractionHand hand : InteractionHand.values()) {
            if (!maid.m_21120_(hand).m_41619_()) continue;
            eanHand = hand;
            break;
        }
        ItemStack itemInHand = maid.m_21120_(eanHand);
        RangedWrapper availableInv = maid.getAvailableBackpackInv();
        ItemStack leftoverStack = ItemHandlerHelper.insertItemStacked((IItemHandler)availableInv, (ItemStack)itemInHand.m_41777_(), (boolean)true);
        if (!leftoverStack.m_41619_()) {
            ChatBubbleManger.addInnerChatText(maid, "chat_bubble.touhou_little_maid.inner.home_meal.two_hand_is_full");
            return;
        }
        ItemStackHandler handler = this.tmpPicnicMat.getHandler();
        IntArrayList candidateFood = new IntArrayList();
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            for (IMaidMeal maidMeal : maidMeals) {
                if (!maidMeal.canMaidEat(maid, stack, eanHand)) continue;
                candidateFood.add(i);
            }
        }
        int size = candidateFood.size();
        if (size == 0) {
            ChatBubbleManger.addInnerChatText(maid, "chat_bubble.touhou_little_maid.inner.home_meal.meal_is_empty");
            return;
        }
        int skipCount = maid.m_217043_().m_188503_(size);
        InteractionHand hand = eanHand;
        candidateFood.intStream().skip(skipCount).findFirst().ifPresent(arg_0 -> this.lambda$start$0(handler, (IItemHandlerModifiable)availableInv, itemInHand, maid, hand, maidMeals, arg_0));
    }

    protected void stop(ServerLevel pLevel, EntityMaid pEntity, long pGameTime) {
        this.tmpPicnicMat = null;
    }

    private /* synthetic */ void lambda$start$0(ItemStackHandler handler, IItemHandlerModifiable availableInv, ItemStack itemInHand, EntityMaid maid, InteractionHand hand, List maidMeals, int slotIndex) {
        ItemStack outputStack = handler.extractItem(slotIndex, 1, false);
        this.tmpPicnicMat.refresh();
        ItemHandlerHelper.insertItemStacked((IItemHandler)availableInv, (ItemStack)itemInHand.m_41777_(), (boolean)false);
        maid.m_21008_(hand, outputStack);
        ItemStack refreshItemInHand = maid.m_21120_(hand);
        for (IMaidMeal maidMeal : maidMeals) {
            if (!maidMeal.canMaidEat(maid, refreshItemInHand, hand)) continue;
            maidMeal.onMaidEat(maid, refreshItemInHand, hand);
            return;
        }
    }
}

