/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.api.task.meal.IMaidMeal;
import com.github.tartaricacid.touhoulittlemaid.api.task.meal.MaidMealType;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidCheckRateTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.task.meal.MaidMealManager;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.RangedWrapper;

public class MaidHealSelfTask
extends MaidCheckRateTask {
    private static final int MAX_DELAY_TIME = 50;
    private static final int MAX_CHECK_MISSING_HEATH = 2;

    public MaidHealSelfTask() {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of());
        this.setMaxCheckRate(50);
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel serverLevel, EntityMaid maid) {
        if (super.checkExtraStartConditions(serverLevel, maid)) {
            float missingHealth = maid.m_21233_() - maid.m_21223_();
            return !maid.m_5803_() && missingHealth >= 2.0f;
        }
        return false;
    }

    protected void start(ServerLevel serverLevel, EntityMaid maid, long gameTime) {
        List<IMaidMeal> maidMeals = MaidMealManager.getMaidMeals(MaidMealType.HEAL_MEAL);
        for (InteractionHand hand : InteractionHand.values()) {
            ItemStack itemInHand = maid.m_21120_(hand);
            if (itemInHand.m_41619_()) continue;
            for (IMaidMeal maidMeal : maidMeals) {
                if (!maidMeal.canMaidEat(maid, itemInHand, hand)) continue;
                maidMeal.onMaidEat(maid, itemInHand, hand);
                return;
            }
        }
        InteractionHand eanHand = InteractionHand.OFF_HAND;
        for (InteractionHand hand : InteractionHand.values()) {
            if (!maid.m_21120_(hand).m_41619_()) continue;
            eanHand = hand;
            break;
        }
        ItemStack itemInHand = maid.m_21120_(eanHand);
        boolean hasFood = false;
        RangedWrapper backpackInv = maid.getAvailableBackpackInv();
        block3: for (int i = 0; i < backpackInv.getSlots(); ++i) {
            ItemStack stack = backpackInv.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            for (IMaidMeal maidMeal : maidMeals) {
                if (!maidMeal.canMaidEat(maid, stack, eanHand)) continue;
                ItemStack foodStack = stack.m_41777_();
                ItemStack handStack = itemInHand.m_41777_();
                maid.m_21008_(eanHand, foodStack);
                backpackInv.setStackInSlot(i, ItemStack.f_41583_);
                ItemHandlerHelper.insertItemStacked((IItemHandler)backpackInv, (ItemStack)handStack, (boolean)false);
                itemInHand = maid.m_21120_(eanHand);
                hasFood = true;
                break block3;
            }
        }
        if (hasFood) {
            for (IMaidMeal maidMeal : maidMeals) {
                if (!maidMeal.canMaidEat(maid, itemInHand, eanHand)) continue;
                maidMeal.onMaidEat(maid, itemInHand, eanHand);
                return;
            }
        }
    }
}

