/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.compat.tacz.client;

import com.github.tartaricacid.touhoulittlemaid.api.backpack.IMaidBackpack;
import com.github.tartaricacid.touhoulittlemaid.api.entity.IMaid;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.InGameMaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.backpack.BackpackManager;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.animated.AnimatedGeoModel;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.util.RenderUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.GunTabType;
import com.tacz.guns.api.item.IGun;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GunMaidRender {
    public static void addItemTranslate(PoseStack matrixStack, ItemStack itemStack, boolean isLeft) {
        if (!isLeft && itemStack.m_41720_() instanceof IGun) {
            matrixStack.m_85837_(0.0, -0.125, 0.0);
        }
    }

    public static void renderBackGun(PoseStack matrixStack, MultiBufferSource bufferIn, int packedLightIn, ItemStack stack, IMaid maid) {
        if (!(stack.m_41720_() instanceof IGun)) {
            return;
        }
        matrixStack.m_85836_();
        matrixStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        matrixStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
        matrixStack.m_85837_(0.0, 0.5, -0.25);
        if (InGameMaidConfig.INSTANCE.isShowBackpack()) {
            maid.getMaidBackpackType().offsetBackpackItem(matrixStack);
        } else {
            BackpackManager.getEmptyBackpack().offsetBackpackItem(matrixStack);
        }
        matrixStack.m_85836_();
        matrixStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
        matrixStack.m_252781_(Axis.f_252403_.m_252977_(-35.0f));
        matrixStack.m_85841_(0.6f, 0.6f, 0.6f);
        Mob mob = maid.asEntity();
        Minecraft.m_91087_().m_91291_().m_269491_((LivingEntity)mob, stack, ItemDisplayContext.FIXED, false, matrixStack, bufferIn, mob.m_9236_(), packedLightIn, OverlayTexture.f_118083_, mob.m_19879_());
        matrixStack.m_85849_();
        matrixStack.m_85849_();
    }

    public static void renderBackGun(ItemStack heldItem, AnimatedGeoModel geoModel, IMaid maid, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        IGun gun = IGun.getIGunOrNull((ItemStack)heldItem);
        if (gun == null) {
            return;
        }
        Mob entity = maid.asEntity();
        IMaidBackpack maidBackpackType = maid.getMaidBackpackType();
        if (InGameMaidConfig.INSTANCE.isShowBackpack() && maidBackpackType != BackpackManager.getEmptyBackpack()) {
            if (!geoModel.backpackBones().isEmpty()) {
                RenderUtils.prepMatrixForLocator(poseStack, geoModel.backpackBones());
            }
            poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
            poseStack.m_85837_(0.0, -1.0, 0.25);
            GunMaidRender.renderBackGun(poseStack, buffer, packedLight, heldItem, maid);
            return;
        }
        TimelessAPI.getCommonGunIndex((ResourceLocation)gun.getGunId(heldItem)).ifPresent(index -> {
            String weaponType = index.getType();
            ItemRenderer renderer = Minecraft.m_91087_().m_91291_();
            if (GunMaidRender.isPistol(weaponType) && !geoModel.tacPistolBones().isEmpty()) {
                RenderUtils.prepMatrixForLocator(poseStack, geoModel.tacPistolBones());
                poseStack.m_85837_(0.0, -0.125, 0.0);
                poseStack.m_85841_(0.65f, 0.65f, 0.65f);
                poseStack.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
                poseStack.m_252781_(Axis.f_252403_.m_252977_(90.0f));
                renderer.m_269128_(heldItem, ItemDisplayContext.FIXED, packedLight, OverlayTexture.f_118083_, poseStack, buffer, entity.m_9236_(), entity.m_19879_());
            }
            if (!GunMaidRender.isPistol(weaponType) && !geoModel.tacRifleBones().isEmpty()) {
                RenderUtils.prepMatrixForLocator(poseStack, geoModel.tacRifleBones());
                poseStack.m_85841_(0.65f, 0.65f, 0.65f);
                poseStack.m_252781_(Axis.f_252436_.m_252977_(-180.0f));
                renderer.m_269128_(heldItem, ItemDisplayContext.FIXED, packedLight, OverlayTexture.f_118083_, poseStack, buffer, entity.m_9236_(), entity.m_19879_());
            }
        });
    }

    private static boolean isPistol(String type) {
        return type.equals(GunTabType.PISTOL.name().toLowerCase(Locale.ENGLISH));
    }
}

