/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.tooltip;

import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.MaidModelInfo;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.inventory.tooltip.ItemMaidTooltip;
import com.github.tartaricacid.touhoulittlemaid.util.EntityCacheUtil;
import com.github.tartaricacid.touhoulittlemaid.util.ParseI18n;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.StringUtils;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class ClientMaidTooltip
implements ClientTooltipComponent {
    @Nullable
    private final MaidModelInfo info;
    private final MutableComponent name;
    private final String customName;

    public ClientMaidTooltip(ItemMaidTooltip tooltip) {
        this.info = CustomPackLoader.MAID_MODELS.getInfo(tooltip.modelId()).orElse(null);
        this.name = this.info == null ? Component.m_237119_() : Component.m_237115_((String)ParseI18n.getI18nKey(this.info.getName()));
        this.customName = tooltip.customName();
    }

    public int m_142103_() {
        return 70;
    }

    public int m_142069_(Font font) {
        return Math.max(font.m_92852_((FormattedText)this.name), 50);
    }

    public void m_183452_(Font font, int pX, int pY, GuiGraphics guiGraphics) {
        EntityMaid maid;
        if (this.info == null) {
            return;
        }
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world == null) {
            return;
        }
        MutableComponent customNameComponent = null;
        if (StringUtils.isNotBlank((CharSequence)this.customName)) {
            customNameComponent = Component.Serializer.m_130701_((String)this.customName);
            if (customNameComponent != null) {
                guiGraphics.m_280430_(font, (Component)customNameComponent.m_130940_(ChatFormatting.GRAY), pX, pY + 2, 0xFFFFFF);
            }
        } else {
            guiGraphics.m_280430_(font, (Component)this.name.m_130940_(ChatFormatting.GRAY), pX, pY + 2, 0xFFFFFF);
        }
        int width = this.m_142069_(font);
        int posX = pX + width / 2;
        int posY = pY + 64;
        double rot = (double)System.currentTimeMillis() / 25.0 % 360.0;
        Quaternionf pose = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf rotation = new Quaternionf().rotateY((float)Math.toRadians(rot));
        pose.mul((Quaternionfc)rotation);
        try {
            maid = (EntityMaid)EntityCacheUtil.ENTITY_CACHE.get(EntityMaid.TYPE, () -> ClientMaidTooltip.lambda$renderImage$1((Level)world));
        }
        catch (ClassCastException | ExecutionException e) {
            e.printStackTrace();
            return;
        }
        EntityCacheUtil.clearMaidDataResidue(maid, false);
        if (StringUtils.isNotBlank((CharSequence)this.customName)) {
            maid.m_6593_((Component)customNameComponent);
        }
        if (this.info.getEasterEgg() != null) {
            maid.setModelId("touhou_little_maid:easter_egg_model");
        } else {
            maid.setModelId(this.info.getModelId().toString());
        }
        guiGraphics.m_280588_(pX, posY - 50, pX + width, posY);
        InventoryScreen.m_280432_((GuiGraphics)guiGraphics, (int)posX, (int)posY, (int)((int)(25.0f * this.info.getRenderItemScale())), (Quaternionf)pose, null, (LivingEntity)maid);
        guiGraphics.m_280618_();
    }

    private static /* synthetic */ Entity lambda$renderImage$1(Level world) throws Exception {
        Entity e = EntityMaid.TYPE.m_20615_(world);
        return Objects.requireNonNullElseGet(e, () -> new EntityMaid(world));
    }
}

