/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.geckolayer;

import com.github.tartaricacid.touhoulittlemaid.api.entity.IMaid;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.GeckoEntityMaidRenderer;
import com.github.tartaricacid.touhoulittlemaid.compat.carryon.RenderFixer;
import com.github.tartaricacid.touhoulittlemaid.compat.slashblade.SlashBladeCompat;
import com.github.tartaricacid.touhoulittlemaid.compat.slashblade.SlashBladeRender;
import com.github.tartaricacid.touhoulittlemaid.compat.tacz.TacCompat;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.InGameMaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.backpack.BackpackManager;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.GeoLayerRenderer;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.animated.AnimatedGeoModel;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.util.RenderUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Vanishable;

public class GeckoLayerMaidBackItem<T extends Mob>
extends GeoLayerRenderer<T, GeckoEntityMaidRenderer<T>> {
    public GeckoLayerMaidBackItem(GeckoEntityMaidRenderer<T> entityRendererIn) {
        super(entityRendererIn);
    }

    @Override
    public void render(PoseStack matrixStack, MultiBufferSource bufferIn, int packedLightIn, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        IMaid maid = IMaid.convert(entity);
        if (maid == null) {
            return;
        }
        AnimatedGeoModel model = ((GeckoEntityMaidRenderer)this.entityRenderer).getAnimatableEntity(entity).getCurrentModel();
        if (model == null) {
            return;
        }
        ItemStack stack = maid.getBackpackShowItem();
        if (!((GeckoEntityMaidRenderer)this.entityRenderer).getAnimatableEntity(entity).getMaidInfo().isShowBackpack() || !InGameMaidConfig.INSTANCE.isShowBackItem() || entity.m_5803_() || entity.m_20145_() || RenderFixer.isCarryOnRender(stack, bufferIn)) {
            return;
        }
        if (stack.m_41720_() instanceof Vanishable) {
            matrixStack.m_85836_();
            if (!model.backpackBones().isEmpty()) {
                RenderUtils.prepMatrixForLocator(matrixStack, model.backpackBones());
            }
            matrixStack.m_85837_(0.0, 1.0, 0.25);
            matrixStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
            matrixStack.m_85837_(0.0, 0.5, -0.25);
            if (InGameMaidConfig.INSTANCE.isShowBackpack()) {
                maid.getMaidBackpackType().offsetBackpackItem(matrixStack);
            } else {
                BackpackManager.getEmptyBackpack().offsetBackpackItem(matrixStack);
            }
            if (SlashBladeCompat.isSlashBladeItem(stack)) {
                SlashBladeRender.renderGeckoMaidBackSlashBlade(matrixStack, bufferIn, packedLightIn, stack);
            } else {
                Minecraft.m_91087_().m_91291_().m_269491_(entity, stack, ItemDisplayContext.FIXED, false, matrixStack, bufferIn, entity.m_9236_(), packedLightIn, OverlayTexture.f_118083_, entity.m_19879_());
            }
            matrixStack.m_85849_();
            return;
        }
        TacCompat.renderBackGun(stack, model, maid, matrixStack, bufferIn, packedLightIn);
    }
}

