/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.overlay;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameType;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.common.Tags;

public class MaidTipsOverlay
implements IGuiOverlay {
    private static final ResourceLocation ICON = new ResourceLocation("touhou_little_maid", "textures/gui/maid_tips_icon.png");
    private static final Map<Item, MutableComponent> TIPS = Maps.newHashMap();

    public static void init() {
        MaidTipsOverlay.addTips("overlay.touhou_little_maid.compass.tips", Items.f_42522_);
        MaidTipsOverlay.addTips("overlay.touhou_little_maid.golden_apple.tips", Items.f_42436_, Items.f_42437_);
        MaidTipsOverlay.addTips("overlay.touhou_little_maid.potion.tips", Items.f_42589_);
        MaidTipsOverlay.addTips("overlay.touhou_little_maid.milk_bucket.tips", Items.f_42455_);
        MaidTipsOverlay.addTips("overlay.touhou_little_maid.script_book.tips", Items.f_42614_, Items.f_42615_);
        MaidTipsOverlay.addTips("overlay.touhou_little_maid.glass_bottle.tips", Items.f_42590_);
        MaidTipsOverlay.addTips("overlay.touhou_little_maid.name_tag.tips", Items.f_42656_);
        MaidTipsOverlay.addTips("overlay.touhou_little_maid.lead.tips", Items.f_42655_);
        MaidTipsOverlay.addTips("overlay.touhou_little_maid.debug_stick.tips", Items.f_42751_);
        MaidTipsOverlay.addTips("overlay.touhou_little_maid.saddle.tips", Items.f_42450_);
    }

    private static MutableComponent checkSpecialTips(ItemStack mainhandItem, EntityMaid maid, LocalPlayer player) {
        if (!maid.m_21830_((LivingEntity)player) && EntityMaid.getNtrItem().test(mainhandItem)) {
            return Component.m_237115_((String)"overlay.touhou_little_maid.ntr_item.tips");
        }
        if (maid.m_21830_((LivingEntity)player) && maid.hasBackpack() && mainhandItem.m_204117_(Tags.Items.SHEARS)) {
            return Component.m_237115_((String)"overlay.touhou_little_maid.remove_backpack.tips");
        }
        return null;
    }

    public void render(ForgeGui gui, GuiGraphics guiGraphics, float partialTick, int screenWidth, int screenHeight) {
        Minecraft minecraft = gui.getMinecraft();
        Options options = minecraft.f_91066_;
        if (!options.m_92176_().m_90612_()) {
            return;
        }
        if (minecraft.f_91072_ == null || minecraft.f_91072_.m_105295_() == GameType.SPECTATOR) {
            return;
        }
        HitResult hitResult = minecraft.f_91077_;
        if (!(hitResult instanceof EntityHitResult)) {
            return;
        }
        EntityHitResult result = (EntityHitResult)hitResult;
        Entity entity = result.m_82443_();
        if (!(entity instanceof EntityMaid)) {
            return;
        }
        EntityMaid maid = (EntityMaid)entity;
        LocalPlayer player = minecraft.f_91074_;
        if (player == null) {
            return;
        }
        if (!maid.m_6084_()) {
            return;
        }
        MutableComponent tip = null;
        if (maid.m_21830_((LivingEntity)player)) {
            tip = TIPS.get(player.m_21205_().m_41720_());
        }
        if (tip == null) {
            tip = MaidTipsOverlay.checkSpecialTips(player.m_21205_(), maid, player);
        }
        if (tip != null) {
            gui.setupOverlayRenderState(true, false);
            List split = minecraft.f_91062_.m_92923_((FormattedText)tip, 150);
            int offset = screenHeight / 2 - 5 - split.size() * 10;
            guiGraphics.m_280480_(player.m_21205_(), screenWidth / 2 - 8, offset);
            guiGraphics.m_280163_(ICON, screenWidth / 2 + 2, offset - 4, 16.0f, 16.0f, 16, 16, 16, 16);
            offset += 18;
            for (FormattedCharSequence sequence : split) {
                int width = minecraft.f_91062_.m_92724_(sequence);
                guiGraphics.m_280648_(minecraft.f_91062_, sequence, (screenWidth - width) / 2, offset, 0xFFFFFF);
                offset += 10;
            }
        }
    }

    private static void addTips(String key, Item ... items) {
        for (Item item : items) {
            TIPS.put(item, Component.m_237115_((String)key));
        }
    }
}

