/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.init;

import com.github.tartaricacid.touhoulittlemaid.client.renderer.item.PerspectiveBakedModel;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.item.ReplaceableBakedModel;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.VanillaConfig;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public final class InitSpecialItemRender {
    private static final List<Pair<ModelResourceLocation, ModelResourceLocation>> PERSPECTIVE_MODEL_LIST = Lists.newArrayList();
    private static final List<Triple<ModelResourceLocation, ModelResourceLocation, Supplier<Boolean>>> REPLACEABLE_MODEL_LIST = Lists.newArrayList();
    private static final ResourceLocation LIFE_POINT = new ResourceLocation("touhou_little_maid", "life_point");
    private static final ResourceLocation POINT_ITEM = new ResourceLocation("touhou_little_maid", "point_item");

    @SubscribeEvent
    public static void register(RegisterEvent event) {
        if (event.getRegistryKey().equals((Object)Registries.f_256913_)) {
            InitSpecialItemRender.addInHandModel((Item)InitItems.HAKUREI_GOHEI.get());
            InitSpecialItemRender.addInHandModel((Item)InitItems.SANAE_GOHEI.get());
            InitSpecialItemRender.addInHandModel((Item)InitItems.EXTINGUISHER.get());
            InitSpecialItemRender.addInHandModel((Item)InitItems.CAMERA.get());
            InitSpecialItemRender.addInHandModel((Item)InitItems.MAID_BEACON.get());
            InitSpecialItemRender.addReplaceableModel(Items.f_42747_, LIFE_POINT, () -> (Boolean)VanillaConfig.REPLACE_TOTEM_TEXTURE.get());
            InitSpecialItemRender.addReplaceableModel(Items.f_42612_, POINT_ITEM, () -> (Boolean)VanillaConfig.REPLACE_XP_BOTTLE_TEXTURE.get());
        }
    }

    @SubscribeEvent
    public static void onBakedModel(ModelEvent.BakingCompleted event) {
        Object model;
        Map registry = event.getModelBakery().m_119251_();
        for (Pair<ModelResourceLocation, ModelResourceLocation> pair : PERSPECTIVE_MODEL_LIST) {
            model = new PerspectiveBakedModel((BakedModel)registry.get(pair.getLeft()), (BakedModel)registry.get(pair.getRight()));
            registry.put((ResourceLocation)pair.getLeft(), model);
        }
        for (Triple triple : REPLACEABLE_MODEL_LIST) {
            model = new ReplaceableBakedModel((BakedModel)registry.get(triple.getLeft()), (BakedModel)registry.get(triple.getMiddle()), (Supplier)triple.getRight());
            registry.put((ResourceLocation)triple.getLeft(), model);
        }
    }

    @SubscribeEvent
    public static void registerModels(ModelEvent.RegisterAdditional event) {
        PERSPECTIVE_MODEL_LIST.forEach(pair -> event.register((ResourceLocation)pair.getRight()));
        REPLACEABLE_MODEL_LIST.forEach(triple -> event.register((ResourceLocation)triple.getMiddle()));
    }

    public static void addInHandModel(Item item) {
        ResourceLocation res = ForgeRegistries.ITEMS.getKey((Object)item);
        if (res != null) {
            ModelResourceLocation rawName = new ModelResourceLocation(res, "inventory");
            ModelResourceLocation inHandName = new ModelResourceLocation(res.m_135827_(), res.m_135815_() + "_in_hand", "inventory");
            PERSPECTIVE_MODEL_LIST.add((Pair<ModelResourceLocation, ModelResourceLocation>)Pair.of((Object)rawName, (Object)inHandName));
        }
    }

    public static void addReplaceableModel(Item item, ResourceLocation replacedModel, Supplier<Boolean> isReplace) {
        ResourceLocation res = ForgeRegistries.ITEMS.getKey((Object)item);
        if (res != null) {
            ModelResourceLocation rawModelResourceLocation = new ModelResourceLocation(res, "inventory");
            ModelResourceLocation replacedModelResourceLocation = new ModelResourceLocation(replacedModel, "inventory");
            REPLACEABLE_MODEL_LIST.add((Triple<ModelResourceLocation, ModelResourceLocation, Supplier<Boolean>>)Triple.of((Object)rawModelResourceLocation, (Object)replacedModelResourceLocation, isReplace));
        }
    }
}

