/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.animation.gecko;

import com.github.tartaricacid.touhoulittlemaid.api.entity.IMaid;
import com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.AnimationManager;
import com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.AnimationState;
import com.github.tartaricacid.touhoulittlemaid.entity.favorability.Type;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntitySit;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.builder.ILoopType;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.event.predicate.AnimationEvent;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.LazyVariable;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.MolangParser;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.model.provider.data.EntityModelData;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.resource.GeckoLibCache;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.util.MolangUtils;
import java.util.function.BiPredicate;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.phys.Vec3;

public class AnimationRegister {
    private static final double MIN_SPEED = 0.05;

    public static void registerAnimationState() {
        AnimationRegister.register("death", ILoopType.EDefaultLoopTypes.PLAY_ONCE, 0, (maid, event) -> maid.asEntity().m_21224_());
        AnimationRegister.register("sleep", 0, (maid, event) -> maid.asEntity().m_20089_() == Pose.SLEEPING);
        AnimationRegister.register("swim", 0, (maid, event) -> maid.asEntity().m_6069_());
        AnimationRegister.register("boat", 1, (maid, event) -> maid.asEntity().m_20202_() instanceof Boat);
        AnimationRegister.register("gomoku", 1, (maid, event) -> {
            EntitySit sit;
            Entity patt2064$temp = maid.asEntity().m_20202_();
            return patt2064$temp instanceof EntitySit && (sit = (EntitySit)patt2064$temp).getJoyType().equals(Type.GOMOKU.getTypeName());
        });
        AnimationRegister.register("bookshelf", 1, (maid, event) -> {
            EntitySit sit;
            Entity patt2237$temp = maid.asEntity().m_20202_();
            return patt2237$temp instanceof EntitySit && (sit = (EntitySit)patt2237$temp).getJoyType().equals(Type.BOOKSHELF.getTypeName());
        });
        AnimationRegister.register("computer", 1, (maid, event) -> {
            EntitySit sit;
            Entity patt2412$temp = maid.asEntity().m_20202_();
            return patt2412$temp instanceof EntitySit && (sit = (EntitySit)patt2412$temp).getJoyType().equals(Type.COMPUTER.getTypeName());
        });
        AnimationRegister.register("keyboard", 1, (maid, event) -> {
            EntitySit sit;
            Entity patt2586$temp = maid.asEntity().m_20202_();
            return patt2586$temp instanceof EntitySit && (sit = (EntitySit)patt2586$temp).getJoyType().equals(Type.KEYBOARD.getTypeName());
        });
        AnimationRegister.register("picnic", 1, (maid, event) -> {
            EntitySit sit;
            Entity patt2758$temp = maid.asEntity().m_20202_();
            return patt2758$temp instanceof EntitySit && (sit = (EntitySit)patt2758$temp).getJoyType().equals(Type.ON_HOME_MEAL.getTypeName());
        });
        AnimationRegister.register("sit", 1, (maid, event) -> maid.isMaidInSittingPose());
        AnimationRegister.register("chair", 1, (maid, event) -> maid.asEntity().m_20159_());
        AnimationRegister.register("swim_stand", 2, (maid, event) -> maid.asEntity().m_20069_());
        AnimationRegister.register("attacked", ILoopType.EDefaultLoopTypes.PLAY_ONCE, 2, (maid, event) -> maid.asEntity().f_20916_ > 0);
        AnimationRegister.register("jump", 2, (maid, event) -> !maid.asEntity().m_20096_() && !maid.asEntity().m_20069_());
        AnimationRegister.register("run", 3, (maid, event) -> maid.asEntity().m_20096_() && maid.asEntity().m_20142_());
        AnimationRegister.register("walk", 3, (maid, event) -> maid.asEntity().m_20096_() && (double)event.getLimbSwingAmount() > 0.05);
        AnimationRegister.register("idle", 4, (maid, event) -> true);
    }

    public static void registerVariables() {
        MolangParser parser = GeckoLibCache.getInstance().parser;
        parser.register(new LazyVariable("query.actor_count", 0.0));
        parser.register(new LazyVariable("query.anim_time", 0.0));
        parser.register(new LazyVariable("query.body_x_rotation", 0.0));
        parser.register(new LazyVariable("query.body_y_rotation", 0.0));
        parser.register(new LazyVariable("query.cardinal_facing_2d", 0.0));
        parser.register(new LazyVariable("query.distance_from_camera", 0.0));
        parser.register(new LazyVariable("query.equipment_count", 0.0));
        parser.register(new LazyVariable("query.eye_target_x_rotation", 0.0));
        parser.register(new LazyVariable("query.eye_target_y_rotation", 0.0));
        parser.register(new LazyVariable("query.ground_speed", 0.0));
        parser.register(new LazyVariable("query.has_cape", 0.0));
        parser.register(new LazyVariable("query.has_rider", 0.0));
        parser.register(new LazyVariable("query.head_x_rotation", 0.0));
        parser.register(new LazyVariable("query.head_y_rotation", 0.0));
        parser.register(new LazyVariable("query.health", 0.0));
        parser.register(new LazyVariable("query.hurt_time", 0.0));
        parser.register(new LazyVariable("query.is_eating", 0.0));
        parser.register(new LazyVariable("query.is_first_person", 0.0));
        parser.register(new LazyVariable("query.is_in_water", 0.0));
        parser.register(new LazyVariable("query.is_in_water_or_rain", 0.0));
        parser.register(new LazyVariable("query.is_jumping", 0.0));
        parser.register(new LazyVariable("query.is_on_fire", 0.0));
        parser.register(new LazyVariable("query.is_on_ground", 0.0));
        parser.register(new LazyVariable("query.is_playing_dead", 0.0));
        parser.register(new LazyVariable("query.is_riding", 0.0));
        parser.register(new LazyVariable("query.is_sleeping", 0.0));
        parser.register(new LazyVariable("query.is_sneaking", 0.0));
        parser.register(new LazyVariable("query.is_spectator", 0.0));
        parser.register(new LazyVariable("query.is_sprinting", 0.0));
        parser.register(new LazyVariable("query.is_swimming", 0.0));
        parser.register(new LazyVariable("query.is_using_item", 0.0));
        parser.register(new LazyVariable("query.item_in_use_duration", 0.0));
        parser.register(new LazyVariable("query.item_max_use_duration", 0.0));
        parser.register(new LazyVariable("query.item_remaining_use_duration", 0.0));
        parser.register(new LazyVariable("query.life_time", 0.0));
        parser.register(new LazyVariable("query.max_health", 0.0));
        parser.register(new LazyVariable("query.modified_distance_moved", 0.0));
        parser.register(new LazyVariable("query.moon_phase", 0.0));
        parser.register(new LazyVariable("query.player_level", 0.0));
        parser.register(new LazyVariable("query.time_of_day", 0.0));
        parser.register(new LazyVariable("query.time_stamp", 0.0));
        parser.register(new LazyVariable("query.vertical_speed", 0.0));
        parser.register(new LazyVariable("query.walk_distance", 0.0));
        parser.register(new LazyVariable("query.yaw_speed", 0.0));
        parser.register(new LazyVariable("ysm.head_yaw", 0.0));
        parser.register(new LazyVariable("ysm.head_pitch", 0.0));
        parser.register(new LazyVariable("ysm.has_helmet", 0.0));
        parser.register(new LazyVariable("ysm.has_chest_plate", 0.0));
        parser.register(new LazyVariable("ysm.has_leggings", 0.0));
        parser.register(new LazyVariable("ysm.has_boots", 0.0));
        parser.register(new LazyVariable("ysm.has_mainhand", 0.0));
        parser.register(new LazyVariable("ysm.has_offhand", 0.0));
        parser.register(new LazyVariable("ysm.has_elytra", 0.0));
        parser.register(new LazyVariable("ysm.elytra_rot_x", 0.0));
        parser.register(new LazyVariable("ysm.elytra_rot_y", 0.0));
        parser.register(new LazyVariable("ysm.elytra_rot_z", 0.0));
        parser.register(new LazyVariable("ysm.is_close_eyes", 0.0));
        parser.register(new LazyVariable("ysm.is_passenger", 0.0));
        parser.register(new LazyVariable("ysm.is_sleep", 0.0));
        parser.register(new LazyVariable("ysm.is_sneak", 0.0));
        parser.register(new LazyVariable("ysm.is_riptide", 0.0));
        parser.register(new LazyVariable("ysm.armor_value", 0.0));
        parser.register(new LazyVariable("ysm.hurt_time", 0.0));
        parser.register(new LazyVariable("ysm.food_level", 20.0));
        parser.register(new LazyVariable("ysm.first_person_mod_hide", 0.0));
        parser.register(new LazyVariable("tlm.is_begging", 0.0));
        parser.register(new LazyVariable("tlm.is_sitting", 0.0));
        parser.register(new LazyVariable("tlm.has_backpack", 0.0));
    }

    public static void setParserValue(AnimationEvent<?> animationEvent, MolangParser parser, EntityModelData data, IMaid maid) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return;
        }
        Mob mob = maid.asEntity();
        parser.setValue("query.actor_count", () -> mc.f_91073_.m_104813_());
        parser.setValue("query.body_x_rotation", () -> ((Mob)mob).m_146909_());
        parser.setValue("query.body_y_rotation", () -> Mth.m_14177_((float)mob.m_146908_()));
        parser.setValue("query.cardinal_facing_2d", () -> mob.m_6350_().m_122411_());
        parser.setValue("query.distance_from_camera", () -> mc.f_91063_.m_109153_().m_90583_().m_82554_(mob.m_20182_()));
        parser.setValue("query.equipment_count", () -> AnimationRegister.getEquipmentCount(mob));
        parser.setValue("query.eye_target_x_rotation", () -> mob.m_5686_(0.0f));
        parser.setValue("query.eye_target_y_rotation", () -> mob.m_5675_(0.0f));
        parser.setValue("query.ground_speed", () -> AnimationRegister.getGroundSpeed(mob));
        parser.setValue("query.has_rider", () -> MolangUtils.booleanToFloat(mob.m_20160_()));
        parser.setValue("query.head_x_rotation", () -> data.netHeadYaw);
        parser.setValue("query.head_y_rotation", () -> data.headPitch);
        parser.setValue("query.health", () -> ((Mob)mob).m_21223_());
        parser.setValue("query.hurt_time", () -> mob.f_20916_);
        parser.setValue("query.is_eating", () -> MolangUtils.booleanToFloat(mob.m_21211_().m_41780_() == UseAnim.EAT));
        parser.setValue("query.is_first_person", () -> MolangUtils.booleanToFloat(mc.f_91066_.m_92176_() == CameraType.FIRST_PERSON));
        parser.setValue("query.is_in_water", () -> MolangUtils.booleanToFloat(mob.m_20069_()));
        parser.setValue("query.is_in_water_or_rain", () -> MolangUtils.booleanToFloat(mob.m_20071_()));
        parser.setValue("query.is_jumping", () -> MolangUtils.booleanToFloat(!mob.m_20159_() && !mob.m_20096_() && !mob.m_20069_()));
        parser.setValue("query.is_on_fire", () -> MolangUtils.booleanToFloat(mob.m_6060_()));
        parser.setValue("query.is_on_ground", () -> MolangUtils.booleanToFloat(mob.m_20096_()));
        parser.setValue("query.is_playing_dead", () -> MolangUtils.booleanToFloat(mob.m_21224_()));
        parser.setValue("query.is_riding", () -> MolangUtils.booleanToFloat(mob.m_20159_()));
        parser.setValue("query.is_sleeping", () -> MolangUtils.booleanToFloat(mob.m_5803_()));
        parser.setValue("query.is_sneaking", () -> MolangUtils.booleanToFloat(mob.m_20096_() && mob.m_20089_() == Pose.CROUCHING));
        parser.setValue("query.is_spectator", () -> MolangUtils.booleanToFloat(mob.m_5833_()));
        parser.setValue("query.is_sprinting", () -> MolangUtils.booleanToFloat(mob.m_20142_()));
        parser.setValue("query.is_swimming", () -> MolangUtils.booleanToFloat(mob.m_6069_()));
        parser.setValue("query.is_using_item", () -> MolangUtils.booleanToFloat(mob.m_6117_()));
        parser.setValue("query.item_in_use_duration", () -> (double)mob.m_21252_() / 20.0);
        parser.setValue("query.item_max_use_duration", () -> AnimationRegister.getMaxUseDuration(mob) / 20.0);
        parser.setValue("query.item_remaining_use_duration", () -> (double)mob.m_21212_() / 20.0);
        parser.setValue("query.max_health", () -> ((Mob)mob).m_21233_());
        parser.setValue("query.modified_distance_moved", () -> mob.f_19787_);
        parser.setValue("query.moon_phase", () -> mc.f_91073_.m_46941_());
        parser.setValue("query.player_level", () -> (double)maid.getExperience() / 120.0);
        parser.setValue("query.time_of_day", () -> MolangUtils.normalizeTime(mc.f_91073_.m_46468_()));
        parser.setValue("query.time_stamp", () -> mc.f_91073_.m_46468_());
        parser.setValue("query.vertical_speed", () -> AnimationRegister.getVerticalSpeed(mob));
        parser.setValue("query.walk_distance", () -> mob.f_19788_);
        parser.setValue("query.yaw_speed", () -> AnimationRegister.getYawSpeed(animationEvent, mob));
        parser.setValue("ysm.head_yaw", () -> data.netHeadYaw);
        parser.setValue("ysm.head_pitch", () -> data.headPitch);
        parser.setValue("ysm.has_helmet", () -> AnimationRegister.getSlotValue(mob, EquipmentSlot.HEAD));
        parser.setValue("ysm.has_chest_plate", () -> AnimationRegister.getSlotValue(mob, EquipmentSlot.CHEST));
        parser.setValue("ysm.has_leggings", () -> AnimationRegister.getSlotValue(mob, EquipmentSlot.LEGS));
        parser.setValue("ysm.has_boots", () -> AnimationRegister.getSlotValue(mob, EquipmentSlot.FEET));
        parser.setValue("ysm.has_mainhand", () -> AnimationRegister.getSlotValue(mob, EquipmentSlot.MAINHAND));
        parser.setValue("ysm.has_offhand", () -> AnimationRegister.getSlotValue(mob, EquipmentSlot.OFFHAND));
        parser.setValue("ysm.has_elytra", () -> MolangUtils.booleanToFloat(mob.m_6844_(EquipmentSlot.CHEST).m_41720_() == Items.f_42741_));
        parser.setValue("ysm.is_close_eyes", () -> AnimationRegister.getEyeCloseState(animationEvent, mob));
        parser.setValue("ysm.is_passenger", () -> MolangUtils.booleanToFloat(mob.m_20159_()));
        parser.setValue("ysm.is_sleep", () -> MolangUtils.booleanToFloat(mob.m_20089_() == Pose.SLEEPING));
        parser.setValue("ysm.is_sneak", () -> MolangUtils.booleanToFloat(mob.m_20096_() && mob.m_20089_() == Pose.CROUCHING));
        parser.setValue("ysm.is_riptide", () -> MolangUtils.booleanToFloat(mob.m_21209_()));
        parser.setValue("ysm.armor_value", () -> ((Mob)mob).m_21230_());
        parser.setValue("ysm.hurt_time", () -> mob.f_20916_);
        parser.setValue("tlm.is_begging", () -> MolangUtils.booleanToFloat(maid.isBegging()));
        parser.setValue("tlm.is_sitting", () -> MolangUtils.booleanToFloat(maid.isMaidInSittingPose()));
        parser.setValue("tlm.has_backpack", () -> MolangUtils.booleanToFloat(maid.hasBackpack()));
    }

    private static void register(String animationName, ILoopType loopType, int priority, BiPredicate<IMaid, AnimationEvent<?>> predicate) {
        AnimationManager manager = AnimationManager.getInstance();
        manager.register(new AnimationState(animationName, loopType, priority, predicate));
    }

    private static void register(String animationName, int priority, BiPredicate<IMaid, AnimationEvent<?>> predicate) {
        AnimationRegister.register(animationName, ILoopType.EDefaultLoopTypes.LOOP, priority, predicate);
    }

    private static int getEquipmentCount(Mob maid) {
        int count = 0;
        for (ItemStack s : maid.m_6168_()) {
            if (s.m_41619_()) continue;
            ++count;
        }
        return count;
    }

    private static double getMaxUseDuration(Mob maid) {
        ItemStack useItem = maid.m_21211_();
        if (useItem.m_41619_()) {
            return 0.0;
        }
        return useItem.m_41779_();
    }

    private static float getYawSpeed(AnimationEvent<?> animationEvent, Mob maid) {
        double seekTime = animationEvent.getAnimationTick();
        return maid.m_5675_((float)seekTime - maid.m_5675_((float)seekTime - 0.1f));
    }

    private static float getGroundSpeed(Mob maid) {
        Vec3 velocity = maid.m_20184_();
        return 20.0f * Mth.m_14116_((float)((float)(velocity.f_82479_ * velocity.f_82479_ + velocity.f_82481_ * velocity.f_82481_)));
    }

    private static float getVerticalSpeed(Mob maid) {
        return 20.0f * (float)(maid.m_20182_().f_82480_ - maid.f_19855_);
    }

    private static double getEyeCloseState(AnimationEvent<?> animationEvent, Mob maid) {
        double remainder = (animationEvent.getAnimationTick() + (double)(Math.abs(maid.m_20148_().getLeastSignificantBits()) % 10L)) % 90.0;
        boolean isBlinkTime = 85.0 < remainder && remainder < 90.0;
        return MolangUtils.booleanToFloat(maid.m_5803_() || isBlinkTime);
    }

    private static double getSlotValue(Mob maid, EquipmentSlot slot) {
        return MolangUtils.booleanToFloat(!maid.m_6844_(slot).m_41619_());
    }
}

