/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.block;

import com.github.tartaricacid.touhoulittlemaid.block.properties.PicnicMatPart;
import com.github.tartaricacid.touhoulittlemaid.entity.favorability.Type;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntitySit;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitBlocks;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.item.ItemPicnicBasket;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityPicnicMat;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class BlockPicnicMat
extends Block
implements EntityBlock {
    public static final EnumProperty<PicnicMatPart> PART = EnumProperty.m_61587_((String)"part", PicnicMatPart.class);
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final VoxelShape AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);

    public BlockPicnicMat() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_60918_(SoundType.f_56736_).m_60913_(2.0f, 3.0f).m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(PART, (Comparable)((Object)PicnicMatPart.CENTER)));
    }

    public void startMaidSit(EntityMaid maid, BlockState state, Level worldIn, BlockPos pos) {
        if (worldIn instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)worldIn;
            BlockEntity blockEntity = worldIn.m_7702_(pos);
            if (blockEntity instanceof TileEntityPicnicMat) {
                TileEntityPicnicMat picnicMat = (TileEntityPicnicMat)blockEntity;
                if (!((PicnicMatPart)((Object)state.m_61143_(PART))).isCenter()) {
                    return;
                }
                boolean hasEmptySit = false;
                int sitIndex = -1;
                for (UUID uuid : picnicMat.getSitIds()) {
                    ++sitIndex;
                    if (uuid.equals(Util.f_137441_)) {
                        hasEmptySit = true;
                        break;
                    }
                    Entity oldSitEntity = serverLevel.m_8791_(uuid);
                    if (oldSitEntity != null && oldSitEntity.m_6084_()) continue;
                    hasEmptySit = true;
                    break;
                }
                if (hasEmptySit) {
                    Vec3 sitPosition = this.sitPosition(sitIndex);
                    EntitySit newSitEntity = new EntitySit(worldIn, Vec3.m_272021_((Vec3i)pos, (double)sitPosition.f_82479_, (double)(sitPosition.f_82480_ + 0.0625), (double)sitPosition.f_82481_), Type.ON_HOME_MEAL.getTypeName(), pos);
                    double y = sitPosition.f_82481_ < 0.0 ? -1.0 : 1.0;
                    double x = sitPosition.f_82479_ < 0.0 ? -1.0 : 1.0;
                    double rotOffset = Math.toDegrees(Math.atan2(y, x));
                    newSitEntity.m_146922_((float)rotOffset + 90.0f);
                    worldIn.m_7967_((Entity)newSitEntity);
                    picnicMat.setSitId(sitIndex, newSitEntity.m_20148_());
                    maid.m_20329_(newSitEntity);
                }
            }
        }
    }

    private Vec3 sitPosition(int sitIndex) {
        switch (sitIndex) {
            case 0: {
                return new Vec3(2.0, 0.0, 2.0);
            }
            case 1: {
                return new Vec3(-1.0, 0.0, 2.0);
            }
            case 2: {
                return new Vec3(-1.0, 0.0, -1.0);
            }
        }
        return new Vec3(2.0, 0.0, -1.0);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player playerIn, InteractionHand hand, BlockHitResult hit) {
        if (worldIn.f_46443_) {
            return InteractionResult.PASS;
        }
        if (hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (!(blockEntity instanceof TileEntityPicnicMat)) {
            return InteractionResult.FAIL;
        }
        TileEntityPicnicMat picnicMat = (TileEntityPicnicMat)blockEntity;
        BlockPos centerPos = picnicMat.getCenterPos();
        BlockEntity blockEntity2 = worldIn.m_7702_(centerPos);
        if (!(blockEntity2 instanceof TileEntityPicnicMat)) {
            return InteractionResult.FAIL;
        }
        TileEntityPicnicMat picnicMatCenter = (TileEntityPicnicMat)blockEntity2;
        ItemStack itemInHand = playerIn.m_21120_(hand);
        if (itemInHand.m_41614_()) {
            return BlockPicnicMat.placeFood(itemInHand, playerIn, picnicMatCenter);
        }
        if (itemInHand.m_41619_() && playerIn.m_20163_()) {
            return BlockPicnicMat.takeFood(playerIn, picnicMatCenter);
        }
        return InteractionResult.PASS;
    }

    private static InteractionResult placeFood(ItemStack food, Player playerIn, TileEntityPicnicMat picnicMatCenter) {
        int count = food.m_41613_();
        ItemStack resultStack = ItemHandlerHelper.insertItemStacked((IItemHandler)picnicMatCenter.getHandler(), (ItemStack)food.m_41777_(), (boolean)false);
        picnicMatCenter.refresh();
        int shrinkCount = count - resultStack.m_41613_();
        if (shrinkCount <= 0) {
            return InteractionResult.FAIL;
        }
        food.m_41774_(shrinkCount);
        return InteractionResult.SUCCESS;
    }

    private static InteractionResult takeFood(Player playerIn, TileEntityPicnicMat picnicMatCenter) {
        int size;
        ItemStackHandler handler = picnicMatCenter.getHandler();
        for (int i = size = handler.getSlots() - 1; i >= 0; --i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            ItemStack outputStack = handler.extractItem(i, handler.getSlotLimit(i), false);
            picnicMatCenter.refresh();
            ItemHandlerHelper.giveItemToPlayer((Player)playerIn, (ItemStack)outputStack);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        BlockPicnicMat.handlePicnicMatRemove(world, pos, state);
        super.m_5707_(world, pos, state, player);
    }

    public void onBlockExploded(BlockState state, Level world, BlockPos pos, Explosion explosion) {
        BlockPicnicMat.handlePicnicMatRemove(world, pos, state);
        super.onBlockExploded(state, world, pos, explosion);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos centerPos = context.m_8083_();
        for (int i = -2; i < 3; ++i) {
            for (int j = -2; j < 3; ++j) {
                BlockPos searchPos = centerPos.m_7918_(i, 0, j);
                if (context.m_43725_().m_8055_(searchPos).m_60629_(context)) continue;
                return null;
            }
        }
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(worldIn, pos, state, placer, stack);
        if (worldIn.f_46443_) {
            return;
        }
        for (int i = -2; i < 3; ++i) {
            for (int j = -2; j < 3; ++j) {
                BlockEntity blockEntity;
                BlockPos searchPos = pos.m_7918_(i, 0, j);
                if (!searchPos.equals((Object)pos)) {
                    worldIn.m_7731_(searchPos, (BlockState)state.m_61124_(PART, (Comparable)((Object)PicnicMatPart.SIDE)), 3);
                }
                if (!((blockEntity = worldIn.m_7702_(searchPos)) instanceof TileEntityPicnicMat)) continue;
                TileEntityPicnicMat picnicMat = (TileEntityPicnicMat)blockEntity;
                picnicMat.setCenterPos(pos);
            }
        }
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (blockEntity instanceof TileEntityPicnicMat) {
            TileEntityPicnicMat picnicMat = (TileEntityPicnicMat)blockEntity;
            if (stack.m_150930_((Item)InitItems.PICNIC_BASKET.get())) {
                picnicMat.setHandler(ItemPicnicBasket.getContainer(stack));
            }
        }
    }

    public boolean m_7898_(BlockState blockState, LevelReader level, BlockPos blockPos) {
        BlockPos below = blockPos.m_7495_();
        return level.m_8055_(below).m_60783_((BlockGetter)level, below, Direction.UP);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, PART});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileEntityPicnicMat(pos, state);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return true;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return AABB;
    }

    private static void handlePicnicMatRemove(Level world, BlockPos pos, BlockState state) {
        if (world.f_46443_) {
            return;
        }
        BlockEntity blockEntity = world.m_7702_(pos);
        if (!(blockEntity instanceof TileEntityPicnicMat)) {
            return;
        }
        TileEntityPicnicMat picnicMat = (TileEntityPicnicMat)blockEntity;
        BlockPos centerPos = picnicMat.getCenterPos();
        BlockEntity blockEntity2 = world.m_7702_(centerPos);
        if (blockEntity2 instanceof TileEntityPicnicMat) {
            TileEntityPicnicMat picnicMatCenter = (TileEntityPicnicMat)blockEntity2;
            ItemStack stack = ((Item)InitItems.PICNIC_BASKET.get()).m_7968_();
            ItemPicnicBasket.setContainer(stack, picnicMatCenter.getHandler());
            BlockPicnicMat.m_49840_((Level)world, (BlockPos)centerPos, (ItemStack)stack);
            if (world instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)world;
                for (UUID uuid : picnicMatCenter.getSitIds()) {
                    Entity entity;
                    if (uuid.equals(Util.f_137441_) || !((entity = serverLevel.m_8791_(uuid)) instanceof EntitySit)) continue;
                    entity.m_146870_();
                }
            }
        }
        for (int i = -2; i < 3; ++i) {
            for (int j = -2; j < 3; ++j) {
                BlockPos offset = centerPos.m_7918_(i, 0, j);
                if (!world.m_8055_(offset).m_60713_((Block)InitBlocks.PICNIC_MAT.get())) continue;
                world.m_46597_(offset, Blocks.f_50016_.m_49966_());
            }
        }
    }
}

