/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.recipes;

import com.google.gson.JsonObject;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.items.IWeaponTableRecipe;
import de.teamlapen.vampirism.core.ModRecipes;
import de.teamlapen.vampirism.recipes.VampirismRecipeHelper;
import de.teamlapen.vampirism.util.RegUtil;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IShapedRecipe;
import org.jetbrains.annotations.NotNull;

public class ShapedWeaponTableRecipe
implements CraftingRecipe,
IWeaponTableRecipe,
IShapedRecipe<CraftingContainer> {
    protected static final int MAX_WIDTH = 4;
    protected static final int MAX_HEIGHT = 4;
    private final CraftingBookCategory category;
    private final ResourceLocation id;
    private final String group;
    private final int recipeWidth;
    private final int recipeHeight;
    private final NonNullList<Ingredient> recipeItems;
    private final ItemStack recipeOutput;
    private final int requiredLevel;
    @NotNull
    private final ISkill<IHunterPlayer>[] requiredSkills;
    private final int requiredLava;

    public ShapedWeaponTableRecipe(ResourceLocation idIn, String groupIn, CraftingBookCategory category, int recipeWidthIn, int recipeHeightIn, NonNullList<Ingredient> recipeItemsIn, ItemStack recipeOutputIn, int requiredLevel, @NotNull ISkill<IHunterPlayer>[] requiredSkills, int requiredLava) {
        this.category = category;
        this.id = idIn;
        this.group = groupIn;
        this.recipeWidth = recipeWidthIn;
        this.recipeHeight = recipeHeightIn;
        this.recipeItems = recipeItemsIn;
        this.recipeOutput = recipeOutputIn;
        this.requiredLevel = requiredLevel;
        this.requiredSkills = requiredSkills;
        this.requiredLava = requiredLava;
    }

    @Override
    @NotNull
    public ItemStack assemble(@NotNull CraftingContainer inv, @NotNull RegistryAccess registryAccess) {
        return this.recipeOutput.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return width >= this.recipeWidth && height >= this.recipeHeight;
    }

    @NotNull
    public String m_6076_() {
        return this.group;
    }

    public int getHeight() {
        return this.recipeHeight;
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Override
    @NotNull
    public NonNullList<Ingredient> m_7527_() {
        return this.recipeItems;
    }

    public int getRecipeHeight() {
        return this.getHeight();
    }

    @NotNull
    public ItemStack m_8043_(@NotNull RegistryAccess registryAccess) {
        return this.recipeOutput;
    }

    public int getRecipeWidth() {
        return this.getWidth();
    }

    @Override
    public int getRequiredLavaUnits() {
        return this.requiredLava;
    }

    @Override
    public int getRequiredLevel() {
        return this.requiredLevel;
    }

    @Override
    @NotNull
    public ISkill<IHunterPlayer>[] getRequiredSkills() {
        return this.requiredSkills;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.SHAPED_CRAFTING_WEAPONTABLE.get();
    }

    @NotNull
    public RecipeType<IWeaponTableRecipe> m_6671_() {
        return (RecipeType)ModRecipes.WEAPONTABLE_CRAFTING_TYPE.get();
    }

    public int getWidth() {
        return this.recipeWidth;
    }

    public boolean matches(@NotNull CraftingContainer inv, @NotNull Level worldIn) {
        for (int i = 0; i <= inv.m_39347_() - this.recipeWidth; ++i) {
            for (int j = 0; j <= inv.m_39346_() - this.recipeHeight; ++j) {
                if (this.checkMatch(inv, i, j, true)) {
                    return true;
                }
                if (!this.checkMatch(inv, i, j, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkMatch(@NotNull CraftingContainer craftingInventory, int startRow, int startColumn, boolean p_77573_4_) {
        for (int i = 0; i < craftingInventory.m_39347_(); ++i) {
            for (int j = 0; j < craftingInventory.m_39346_(); ++j) {
                int k = i - startRow;
                int l = j - startColumn;
                Ingredient ingredient = Ingredient.f_43901_;
                if (k >= 0 && l >= 0 && k < this.recipeWidth && l < this.recipeHeight) {
                    ingredient = p_77573_4_ ? (Ingredient)this.recipeItems.get(this.recipeWidth - k - 1 + l * this.recipeWidth) : (Ingredient)this.recipeItems.get(k + l * this.recipeWidth);
                }
                if (ingredient.test(craftingInventory.m_8020_(i + j * craftingInventory.m_39347_()))) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    public CraftingBookCategory m_245232_() {
        return this.category;
    }

    public static class Serializer
    implements RecipeSerializer<ShapedWeaponTableRecipe> {
        @NotNull
        public ShapedWeaponTableRecipe fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            CraftingBookCategory craftingbookcategory = (CraftingBookCategory)CraftingBookCategory.f_244644_.m_262792_(GsonHelper.m_13851_((JsonObject)json, (String)"category", (String)null), (Enum)CraftingBookCategory.MISC);
            Map<String, Ingredient> map = VampirismRecipeHelper.deserializeKey(GsonHelper.m_13930_((JsonObject)json, (String)"key"));
            String[] astring = VampirismRecipeHelper.shrink(VampirismRecipeHelper.patternFromJson(GsonHelper.m_13933_((JsonObject)json, (String)"pattern"), 4));
            int width = astring[0].length();
            int length = astring.length;
            NonNullList<Ingredient> ingredients = VampirismRecipeHelper.deserializeIngredients(astring, map, width, length);
            ItemStack result = CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"), (boolean)true);
            int level = GsonHelper.m_13824_((JsonObject)json, (String)"level", (int)1);
            ISkill<?>[] skill = VampirismRecipeHelper.deserializeSkills(GsonHelper.m_13832_((JsonObject)json, (String)"skill", null));
            int lava = GsonHelper.m_13824_((JsonObject)json, (String)"lava", (int)0);
            return new ShapedWeaponTableRecipe(recipeId, group, craftingbookcategory, width, length, ingredients, result, level, skill, lava);
        }

        public ShapedWeaponTableRecipe fromNetwork(@NotNull ResourceLocation recipeId, @NotNull FriendlyByteBuf buffer) {
            int width = buffer.m_130242_();
            int height = buffer.m_130242_();
            String group = buffer.m_130136_(Short.MAX_VALUE);
            CraftingBookCategory craftingbookcategory = (CraftingBookCategory)buffer.m_130066_(CraftingBookCategory.class);
            NonNullList ingredients = NonNullList.m_122780_((int)(height * width), (Object)Ingredient.f_43901_);
            ingredients.replaceAll(ignored -> Ingredient.m_43940_((FriendlyByteBuf)buffer));
            ItemStack itemstack = buffer.m_130267_();
            int level = buffer.m_130242_();
            int lava = buffer.m_130242_();
            ISkill[] skills = new ISkill[buffer.m_130242_()];
            if (skills.length != 0) {
                for (int i = 0; i < skills.length; ++i) {
                    skills[i] = RegUtil.getSkill(new ResourceLocation(buffer.m_130136_(Short.MAX_VALUE)));
                }
            }
            return new ShapedWeaponTableRecipe(recipeId, group, craftingbookcategory, width, height, (NonNullList<Ingredient>)ingredients, itemstack, level, skills, lava);
        }

        public void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull ShapedWeaponTableRecipe recipe) {
            buffer.m_130130_(recipe.recipeWidth);
            buffer.m_130130_(recipe.recipeHeight);
            buffer.m_130070_(recipe.group);
            buffer.m_130068_((Enum)recipe.category);
            for (Ingredient ingredient : recipe.recipeItems) {
                ingredient.m_43923_(buffer);
            }
            buffer.m_130055_(recipe.recipeOutput);
            buffer.m_130130_(recipe.requiredLevel);
            buffer.m_130130_(recipe.requiredLava);
            buffer.m_130130_(recipe.requiredSkills.length);
            if (recipe.requiredSkills.length != 0) {
                for (ISkill<IHunterPlayer> skill : recipe.requiredSkills) {
                    buffer.m_130070_(RegUtil.id(skill).toString());
                }
            }
        }
    }
}

