/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.lib.lib.util.ModDisplayItemGenerator;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.items.IItemWithTier;
import de.teamlapen.vampirism.items.VampirismHunterWeaponItem;
import de.teamlapen.vampirism.util.ToolMaterial;
import java.util.HashMap;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.Tags;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HunterAxeItem
extends VampirismHunterWeaponItem
implements IItemWithTier,
ModDisplayItemGenerator.CreativeTabItemProvider {
    public static final ToolMaterial.Tiered NORMAL = new ToolMaterial.Tiered(IItemWithTier.TIER.NORMAL, 2, 250, 3.6f, 7.0f, 14, () -> Ingredient.m_204132_((TagKey)Tags.Items.INGOTS_IRON));
    public static final ToolMaterial.Tiered ENHANCED = new ToolMaterial.Tiered(IItemWithTier.TIER.ENHANCED, 2, 1561, 3.6f, 7.0f, 14, () -> Ingredient.m_204132_((TagKey)Tags.Items.GEMS_DIAMOND));
    public static final ToolMaterial.Tiered ULTIMATE = new ToolMaterial.Tiered(IItemWithTier.TIER.ULTIMATE, 2, 2031, 3.6f, 7.0f, 14, () -> Ingredient.m_204132_((TagKey)Tags.Items.INGOTS_NETHERITE));
    private final IItemWithTier.TIER tier;

    public HunterAxeItem(ToolMaterial.Tiered material) {
        super(material, 3, -2.9f, new Item.Properties());
        this.tier = material.getTier();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@NotNull ItemStack stack, @Nullable Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        this.addTierInformation(tooltip);
        tooltip.add((Component)Component.m_237110_((String)"text.vampirism.deals_more_damage_to", (Object[])new Object[]{Math.round((this.getVampireMult() - 1.0f) * 100.0f), VReference.VAMPIRE_FACTION.getNamePlural()}).m_130940_(ChatFormatting.GRAY));
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    @Override
    public void generateCreativeTab(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull CreativeModeTab.ItemDisplayParameters parameters, CreativeModeTab.Output output) {
        output.m_246342_(this.getEnchantedStack());
    }

    @Override
    public float getDamageMultiplierForFaction(@NotNull ItemStack stack) {
        return this.getVampireMult();
    }

    @NotNull
    public ItemStack getEnchantedStack() {
        ItemStack stack = new ItemStack((ItemLike)this);
        HashMap<Enchantment, Integer> map = new HashMap<Enchantment, Integer>();
        map.put(Enchantments.f_44980_, this.getKnockback());
        EnchantmentHelper.m_44865_(map, (ItemStack)stack);
        return stack;
    }

    @Override
    public int getMinLevel(@NotNull ItemStack stack) {
        return this.getMinLevel();
    }

    @Override
    public IItemWithTier.TIER getVampirismTier() {
        return this.tier;
    }

    public boolean m_5812_(@NotNull ItemStack stack) {
        return false;
    }

    private int getKnockback() {
        return switch (this.tier) {
            case IItemWithTier.TIER.ULTIMATE -> 4;
            case IItemWithTier.TIER.ENHANCED -> 3;
            default -> 2;
        };
    }

    private int getMinLevel() {
        return switch (this.tier) {
            case IItemWithTier.TIER.ULTIMATE -> 8;
            case IItemWithTier.TIER.ENHANCED -> 6;
            default -> 4;
        };
    }

    private float getVampireMult() {
        return switch (this.tier) {
            case IItemWithTier.TIER.ULTIMATE -> 1.3f;
            case IItemWithTier.TIER.ENHANCED -> 1.3f;
            default -> 1.2f;
        };
    }

    public boolean canDisableShield(ItemStack stack, ItemStack shield, LivingEntity entity, LivingEntity attacker) {
        return true;
    }
}

