/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.player.skills;

import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillManager;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillType;
import de.teamlapen.vampirism.core.ModRegistries;
import de.teamlapen.vampirism.util.RegUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SkillManager
implements ISkillManager {
    private static final Logger LOGGER = LogManager.getLogger(SkillManager.class);
    private final Map<ResourceLocation, ISkillType> skillTypes = new HashMap<ResourceLocation, ISkillType>();

    @NotNull
    public <T extends IFactionPlayer<T>> ISkill<T> getRootSkill(@NotNull IPlayableFaction<T> faction, @NotNull ISkillType type) {
        if (!type.isForFaction(faction)) {
            throw new IllegalStateException("The skilltype " + type + " is not applicable for the faction " + faction.getID());
        }
        ISkill<?> skill = RegUtil.getSkill(type.createIdForFaction(faction.getID()));
        if (skill == null) {
            LOGGER.warn("No root skill exists for faction {}", (Object)faction.getID());
            throw new IllegalStateException("You need to register a root skill for your faction " + faction.getID());
        }
        return skill;
    }

    @Override
    @NotNull
    public <T extends IFactionPlayer<T>> List<ISkill<T>> getSkillsForFaction(IPlayableFaction<T> faction) {
        return RegUtil.values(ModRegistries.SKILLS).stream().filter(action -> action.getFaction().map(f -> f == faction).orElse(true)).map(action -> action).collect(Collectors.toList());
    }

    @Override
    @NotNull
    public Collection<ISkillType> getSkillTypes() {
        return this.skillTypes.values();
    }

    public void printSkills(IPlayableFaction<?> faction, @NotNull CommandSourceStack sender) {
        for (ISkill<?> s : this.getSkillsForFaction(faction)) {
            sender.m_288197_(() -> Component.m_237113_((String)("ID: " + RegUtil.id(s) + " Skill: ")).m_7220_(s.getName()), true);
        }
    }

    @Override
    @Nullable
    public ISkillType getSkillType(@NotNull ResourceLocation id) {
        return this.skillTypes.get(id);
    }

    @Override
    @NotNull
    public ISkillType registerSkillType(@NotNull ISkillType type) {
        if (this.skillTypes.containsKey(type.getRegistryName())) {
            throw new IllegalStateException("A skill type with the id " + type.getRegistryName() + " has already been registered");
        }
        this.skillTypes.put(type.getRegistryName(), type);
        return type;
    }
}

