/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib.entity;

import de.teamlapen.lib.HelperRegistry;
import de.teamlapen.lib.VampLib;
import de.teamlapen.lib.lib.entity.IPlayerEventListener;
import de.teamlapen.lib.lib.network.ISyncable;
import de.teamlapen.lib.network.ClientboundUpdateEntityPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

public class EntityEventHandler {
    private final Capability<IPlayerEventListener>[] listeners;

    public EntityEventHandler(Capability<IPlayerEventListener>[] listeners) {
        this.listeners = listeners;
    }

    @SubscribeEvent
    public void onChangedDimension(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull PlayerEvent.PlayerChangedDimensionEvent event) {
        for (Capability<IPlayerEventListener> listener : this.listeners) {
            event.getEntity().getCapability(listener, null).ifPresent(cap -> cap.onChangedDimension((ResourceKey<Level>)event.getFrom(), (ResourceKey<Level>)event.getTo()));
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(@NotNull EntityJoinLevelEvent event) {
        if (event.getEntity() instanceof Player) {
            for (Capability<IPlayerEventListener> listener : this.listeners) {
                event.getEntity().getCapability(listener, null).ifPresent(IPlayerEventListener::onJoinWorld);
            }
        }
    }

    @SubscribeEvent
    public void onLivingAttack(@NotNull LivingAttackEvent event) {
        if (event.getEntity() instanceof Player) {
            for (Capability<IPlayerEventListener> listener : this.listeners) {
                boolean cancel = event.getEntity().getCapability(listener, null).map(cap -> cap.onEntityAttacked(event.getSource(), event.getAmount())).orElse(false);
                if (!cancel) continue;
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onLivingDeath(@NotNull LivingDeathEvent event) {
        if (event.getEntity() instanceof Player) {
            for (Capability<IPlayerEventListener> listener : this.listeners) {
                event.getEntity().getCapability(listener, null).ifPresent(cap -> cap.onDeath(event.getSource()));
            }
        }
        if (event.getSource().m_7639_() instanceof Player) {
            for (Capability<IPlayerEventListener> listener : this.listeners) {
                event.getSource().m_7639_().getCapability(listener, null).ifPresent(cap -> cap.onEntityKilled(event.getEntity(), event.getSource()));
            }
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull LivingEvent.LivingTickEvent event) {
        if (event.getEntity() instanceof Player) {
            for (Capability<IPlayerEventListener> listener : this.listeners) {
                event.getEntity().getCapability(listener, null).ifPresent(IPlayerEventListener::onUpdate);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onPlayerClone(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull PlayerEvent.Clone event) {
        for (Capability<IPlayerEventListener> listener : this.listeners) {
            event.getEntity().getCapability(listener, null).ifPresent(cap -> cap.onPlayerClone(event.getOriginal(), event.isWasDeath()));
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull PlayerEvent.PlayerLoggedInEvent event) {
        for (Capability<IPlayerEventListener> listener : this.listeners) {
            event.getEntity().getCapability(listener, null).ifPresent(IPlayerEventListener::onPlayerLoggedIn);
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedOut(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull PlayerEvent.PlayerLoggedOutEvent event) {
        for (Capability<IPlayerEventListener> listener : this.listeners) {
            event.getEntity().getCapability(listener, null).ifPresent(IPlayerEventListener::onPlayerLoggedOut);
        }
    }

    @SubscribeEvent
    public void onPlayerUpdate(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull TickEvent.PlayerTickEvent event) {
        for (Capability<IPlayerEventListener> listener : this.listeners) {
            event.player.getCapability(listener, null).ifPresent(cap -> cap.onUpdatePlayer(event.phase));
        }
    }

    @SubscribeEvent
    public void onStartTracking(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull PlayerEvent.StartTracking event) {
        ClientboundUpdateEntityPacket packet;
        if ((event.getTarget() instanceof PathfinderMob && HelperRegistry.getSyncableEntityCaps().size() > 0 || event.getTarget() instanceof ISyncable || event.getTarget() instanceof Player && HelperRegistry.getSyncablePlayerCaps().size() > 0) && (packet = ClientboundUpdateEntityPacket.createJoinWorldPacket(event.getTarget())) != null) {
            VampLib.dispatcher.sendTo(packet, (ServerPlayer)event.getEntity());
        }
    }
}

