/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.harvest;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import snownee.jade.addon.harvest.ShearsToolHandler;
import snownee.jade.addon.harvest.SimpleToolHandler;
import snownee.jade.addon.harvest.ToolHandler;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.Identifiers;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.impl.ui.SubTextElement;
import snownee.jade.util.ClientProxy;
import snownee.jade.util.CommonProxy;

public enum HarvestToolProvider implements IBlockComponentProvider,
ResourceManagerReloadListener
{
    INSTANCE;

    public static final Cache<BlockState, ImmutableList<ItemStack>> resultCache;
    public static final Map<String, ToolHandler> TOOL_HANDLERS;
    private static final Component CHECK;
    private static final Component X;
    private static final Vec2 ITEM_SIZE;

    public static ImmutableList<ItemStack> getTool(BlockState state, Level world, BlockPos pos) {
        ImmutableList.Builder tools = ImmutableList.builder();
        for (ToolHandler handler : TOOL_HANDLERS.values()) {
            ItemStack tool = handler.test(state, world, pos);
            if (tool.m_41619_()) continue;
            tools.add((Object)tool);
        }
        return tools.build();
    }

    public static synchronized void registerHandler(ToolHandler handler) {
        TOOL_HANDLERS.put(handler.getName(), handler);
    }

    @Override
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        Player player = accessor.getPlayer();
        if (!config.get(Identifiers.MC_HARVEST_TOOL_CREATIVE) && (player.m_7500_() || player.m_5833_())) {
            return;
        }
        BlockState state = accessor.getBlockState();
        Level level = accessor.getLevel();
        BlockPos pos = accessor.getPosition();
        float destroySpeed = state.m_60800_((BlockGetter)level, pos);
        float destroyProgress = state.m_60625_(player, (BlockGetter)level, pos);
        if (destroySpeed < 0.0f || destroyProgress <= 0.0f) {
            if (config.get(Identifiers.MC_SHOW_UNBREAKABLE)) {
                MutableComponent text = IThemeHelper.get().failure(Component.m_237115_((String)"jade.harvest_tool.unbreakable"));
                tooltip.add(IElementHelper.get().text((Component)text).message(null));
            }
            return;
        }
        boolean newLine = config.get(Identifiers.MC_HARVEST_TOOL_NEW_LINE);
        List<IElement> elements = this.getText(accessor, config);
        if (elements.isEmpty()) {
            return;
        }
        elements.forEach(e -> e.message(null));
        if (newLine) {
            tooltip.add(elements);
        } else {
            elements.forEach(e -> e.align(IElement.Align.RIGHT));
            tooltip.append(0, elements);
        }
    }

    public List<IElement> getText(BlockAccessor accessor, IPluginConfig config) {
        BlockState state = accessor.getBlockState();
        if (!state.m_60834_() && !config.get(Identifiers.MC_EFFECTIVE_TOOL)) {
            return List.of();
        }
        List tools = List.of();
        try {
            tools = (List)resultCache.get((Object)state, () -> HarvestToolProvider.getTool(state, accessor.getLevel(), accessor.getPosition()));
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        if (tools.isEmpty()) {
            return List.of();
        }
        int offsetY = -3;
        boolean newLine = config.get(Identifiers.MC_HARVEST_TOOL_NEW_LINE);
        ArrayList elements = Lists.newArrayList();
        for (ItemStack tool : tools) {
            elements.add(IElementHelper.get().item(tool, 0.75f).translate(new Vec2(-1.0f, (float)offsetY)).size(ITEM_SIZE).message(null));
        }
        if (!elements.isEmpty()) {
            elements.add(0, IElementHelper.get().spacer(newLine ? -2 : 5, newLine ? 10 : 0));
            ItemStack held = accessor.getPlayer().m_21205_();
            boolean canHarvest = held.m_41735_(state);
            if (CommonProxy.isShearable(state) && CommonProxy.isShears(held)) {
                canHarvest = true;
            }
            if (state.m_60834_() || canHarvest) {
                IThemeHelper t = IThemeHelper.get();
                MutableComponent text = canHarvest ? t.success(CHECK) : t.danger(X);
                elements.add(new SubTextElement((Component)text).translate(new Vec2(-3.0f, (float)(7 + offsetY))));
            }
        }
        return elements;
    }

    public void m_6213_(ResourceManager resourceManager) {
        resultCache.invalidateAll();
    }

    @Override
    public ResourceLocation getUid() {
        return Identifiers.MC_HARVEST_TOOL;
    }

    @Override
    public int getDefaultPriority() {
        return -8000;
    }

    static {
        resultCache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build();
        TOOL_HANDLERS = Maps.newLinkedHashMap();
        CHECK = Component.m_237113_((String)"\u2714");
        X = Component.m_237113_((String)"\u2715");
        ITEM_SIZE = new Vec2(10.0f, 0.0f);
        if (CommonProxy.isPhysicallyClient()) {
            HarvestToolProvider.registerHandler(new SimpleToolHandler("pickaxe", (TagKey<Block>)BlockTags.f_144282_, Items.f_42422_, Items.f_42427_, Items.f_42385_, Items.f_42390_, Items.f_42395_));
            HarvestToolProvider.registerHandler(new SimpleToolHandler("axe", (TagKey<Block>)BlockTags.f_144280_, Items.f_42423_, Items.f_42428_, Items.f_42386_, Items.f_42391_, Items.f_42396_));
            HarvestToolProvider.registerHandler(new SimpleToolHandler("shovel", (TagKey<Block>)BlockTags.f_144283_, Items.f_42421_, Items.f_42426_, Items.f_42384_, Items.f_42389_, Items.f_42394_));
            HarvestToolProvider.registerHandler(new SimpleToolHandler("hoe", (TagKey<Block>)BlockTags.f_144281_, Items.f_42424_, Items.f_42429_, Items.f_42387_, Items.f_42392_, Items.f_42397_));
            HarvestToolProvider.registerHandler(ClientProxy.createSwordToolHandler());
            HarvestToolProvider.registerHandler(new ShearsToolHandler());
        }
    }
}

