/*
 * Decompiled with CFR 0.152.
 */
package com.abdelaziz.canary.mixin.chunk.serialization;

import com.abdelaziz.canary.common.world.chunk.CanaryHashPalette;
import com.abdelaziz.canary.common.world.chunk.CompactingPackedIntegerArray;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.LongStream;
import net.minecraft.core.IdMap;
import net.minecraft.util.BitStorage;
import net.minecraft.util.SimpleBitStorage;
import net.minecraft.util.ZeroBitStorage;
import net.minecraft.world.level.chunk.Palette;
import net.minecraft.world.level.chunk.PaletteResize;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PalettedContainer.class})
public abstract class PalettedContainerMixin<T> {
    private static final ThreadLocal<short[]> CACHED_ARRAY_4096 = ThreadLocal.withInitial(() -> new short[4096]);
    private static final ThreadLocal<short[]> CACHED_ARRAY_64 = ThreadLocal.withInitial(() -> new short[64]);
    @Shadow
    @Final
    private PaletteResize<T> f_63070_;
    @Shadow
    private volatile PalettedContainer.Data<T> f_188032_;

    @Shadow
    protected abstract T m_63085_(int var1);

    @Shadow
    public abstract void m_63084_();

    @Shadow
    public abstract void m_63120_();

    @Overwrite
    public PalettedContainerRO.PackedData<T> m_188064_(IdMap<T> idList, PalettedContainer.Strategy provider) {
        this.m_63084_();
        CanaryHashPalette hashPalette = null;
        Optional<Object> data = Optional.empty();
        List<Object> elements = null;
        Palette palette = this.f_188032_.f_188102_();
        BitStorage storage = this.f_188032_.f_188101_();
        if (storage instanceof ZeroBitStorage || palette.m_62680_() == 1) {
            elements = List.of(palette.m_5795_(0));
        } else if (palette instanceof CanaryHashPalette) {
            CanaryHashPalette lithiumHashPalette;
            hashPalette = lithiumHashPalette = (CanaryHashPalette)palette;
        }
        if (elements == null) {
            CanaryHashPalette<T> compactedPalette = new CanaryHashPalette<T>(idList, storage.m_144604_(), this.f_63070_);
            short[] array = this.getOrCreate(provider.m_188144_());
            ((CompactingPackedIntegerArray)storage).compact(this.f_188032_.f_188102_(), compactedPalette, array);
            if (hashPalette != null && hashPalette.m_62680_() == compactedPalette.m_62680_() && storage.m_144604_() == provider.m_188151_(idList, hashPalette.m_62680_())) {
                data = this.asOptional((long[])storage.m_13513_().clone());
                elements = hashPalette.getElements();
            } else {
                int bits = provider.m_188151_(idList, compactedPalette.m_62680_());
                if (bits != 0) {
                    SimpleBitStorage copy = new SimpleBitStorage(bits, array.length);
                    for (int i = 0; i < array.length; ++i) {
                        copy.m_13524_(i, (int)array[i]);
                    }
                    data = this.asOptional(copy.m_13513_());
                }
                elements = compactedPalette.getElements();
            }
        }
        this.m_63120_();
        return new PalettedContainerRO.PackedData(elements, data);
    }

    private Optional<LongStream> asOptional(long[] data) {
        return Optional.of(Arrays.stream(data));
    }

    private short[] getOrCreate(int size) {
        return switch (size) {
            case 64 -> CACHED_ARRAY_64.get();
            case 4096 -> CACHED_ARRAY_4096.get();
            default -> new short[size];
        };
    }

    @Inject(method={"count(Lnet/minecraft/world/level/chunk/PalettedContainer$CountConsumer;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void count(PalettedContainer.CountConsumer<T> consumer, CallbackInfo ci) {
        int len = this.f_188032_.f_188102_().m_62680_();
        if (len > 4096) {
            return;
        }
        short[] counts = new short[len];
        this.f_188032_.f_188101_().m_13519_(i -> {
            int n = i;
            counts[n] = (short)(counts[n] + 1);
        });
        for (int i2 = 0; i2 < counts.length; ++i2) {
            Object obj = this.f_188032_.f_188102_().m_5795_(i2);
            if (obj == null) continue;
            consumer.m_63144_(obj, (int)counts[i2]);
        }
        ci.cancel();
    }
}

