/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world;

import com.google.common.collect.Maps;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.EnumStrength;
import de.teamlapen.vampirism.api.VampirismCapabilities;
import de.teamlapen.vampirism.api.world.IVampirismWorld;
import de.teamlapen.vampirism.world.ModDamageSources;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.util.thread.EffectiveSide;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VampirismWorld
implements IVampirismWorld {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final Capability<IVampirismWorld> CAP = VampirismCapabilities.WORLD;
    @NotNull
    private final Level level;
    private final ModDamageSources damageSources;
    private final Map<BlockPos, BoundingBox> fogAreas = new ConcurrentHashMap<BlockPos, BoundingBox>();
    private final Map<BlockPos, BoundingBox> tmpFogAreas = new ConcurrentHashMap<BlockPos, BoundingBox>();
    private final HashMap<ChunkPos, EnumStrength> strengthHashMap = Maps.newHashMap();
    private final HashMap<Integer, Emitter> emitterHashMap = Maps.newHashMap();

    @Deprecated
    @NotNull
    public static VampirismWorld get(@NotNull Level world) {
        return (VampirismWorld)world.getCapability(CAP, null).orElseThrow(() -> new IllegalStateException("Cannot get VampirismWorld from World " + world));
    }

    @NotNull
    public static LazyOptional<VampirismWorld> getOpt(@NotNull Level world) {
        LazyOptional opt = world.getCapability(CAP, null).cast();
        if (!opt.isPresent()) {
            LOGGER.warn("Cannot get world capability. This might break mod functionality.", new Throwable().fillInStackTrace());
        }
        return opt;
    }

    @NotNull
    public static ICapabilityProvider createNewCapability(final @NotNull Level world) {
        return new ICapabilitySerializable<CompoundTag>(){
            final VampirismWorld inst;
            final LazyOptional<IVampirismWorld> opt;
            {
                this.inst = new VampirismWorld(world);
                this.opt = LazyOptional.of(() -> this.inst);
            }

            public void deserializeNBT(CompoundTag nbt) {
                this.inst.loadNBTData(nbt);
            }

            @NotNull
            public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, Direction facing) {
                return CAP.orEmpty(capability, this.opt);
            }

            @NotNull
            public CompoundTag serializeNBT() {
                CompoundTag tag = new CompoundTag();
                this.inst.saveNBTData(tag);
                return tag;
            }
        };
    }

    private static boolean isHostingClient() {
        return EffectiveSide.get().isClient() && ServerLifecycleHooks.getCurrentServer() != null;
    }

    public VampirismWorld(@NotNull Level level) {
        this.level = level;
        this.damageSources = new ModDamageSources(level.m_9598_());
    }

    @Override
    public void clearCaches() {
        this.strengthHashMap.clear();
        this.emitterHashMap.clear();
    }

    @Override
    @NotNull
    public EnumStrength getStrengthAtChunk(ChunkPos pos) {
        EnumStrength s = this.strengthHashMap.get(pos);
        return s == null ? EnumStrength.NONE : s;
    }

    @Override
    public boolean isInsideArtificialVampireFogArea(@NotNull BlockPos blockPos) {
        return Stream.concat(this.fogAreas.entrySet().stream(), this.tmpFogAreas.entrySet().stream()).anyMatch(entry -> ((BoundingBox)entry.getValue()).m_71051_((Vec3i)blockPos));
    }

    public void printDebug(@NotNull CommandSourceStack sender) {
        for (Emitter emitter : this.emitterHashMap.values()) {
            sender.m_288197_(() -> Component.m_237113_((String)("E: " + emitter.toString())), true);
        }
        for (Map.Entry entry : this.strengthHashMap.entrySet()) {
            sender.m_288197_(() -> Component.m_237113_((String)("S: " + entry.toString())), true);
        }
    }

    @Override
    public int registerGarlicBlock(EnumStrength strength, ChunkPos ... pos) {
        for (ChunkPos p : pos) {
            if (p != null) continue;
            throw new IllegalArgumentException("Garlic emitter position should not be null");
        }
        Emitter e = new Emitter(strength, pos);
        int hash = e.hashCode();
        if (VampirismWorld.isHostingClient()) {
            return hash;
        }
        this.emitterHashMap.put(hash, e);
        this.rebuildStrengthMap();
        return hash;
    }

    @Override
    public void removeGarlicBlock(int id) {
        if (VampirismWorld.isHostingClient()) {
            return;
        }
        Emitter e = this.emitterHashMap.remove(id);
        if (e == null) {
            LOGGER.debug("Removed emitter did not exist");
        }
        this.rebuildStrengthMap();
    }

    @Override
    public void updateArtificialFogBoundingBox(@NotNull BlockPos totemPos, @Nullable AABB box) {
        if (box == null) {
            this.fogAreas.remove(totemPos);
            this.updateTemporaryArtificialFog(totemPos, null);
        } else {
            this.fogAreas.put(totemPos, UtilLib.AABBtoMB(box));
        }
    }

    @Override
    public void updateTemporaryArtificialFog(@NotNull BlockPos totemPos, @Nullable AABB box) {
        if (box == null) {
            this.tmpFogAreas.remove(totemPos);
        } else {
            this.tmpFogAreas.put(totemPos, UtilLib.AABBtoMB(box));
        }
    }

    private void loadNBTData(CompoundTag nbt) {
    }

    private void rebuildStrengthMap() {
        this.strengthHashMap.clear();
        for (Emitter e : this.emitterHashMap.values()) {
            for (ChunkPos pos : e.pos) {
                EnumStrength old = this.strengthHashMap.get(pos);
                if (old != null && !e.strength.isStrongerThan(old)) continue;
                this.strengthHashMap.put(pos, e.strength);
            }
        }
    }

    private void saveNBTData(CompoundTag nbt) {
    }

    public ModDamageSources damageSources() {
        return this.damageSources;
    }

    private record Emitter(EnumStrength strength, ChunkPos[] pos) {
        @Override
        @NotNull
        public String toString() {
            return "Emitter{pos=" + Arrays.toString(this.pos) + ", strength=" + this.strength + "}";
        }
    }
}

