/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.util;

import de.teamlapen.vampirism.REFERENCE;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.settings.Supporter;
import java.util.Arrays;
import java.util.HashMap;
import net.minecraft.util.RandomSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class SupporterManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static Supporter[][] supporters = new Supporter[2][0];

    public static Supporter getRandomHunter(@NotNull RandomSource rnd) {
        if (supporters[1].length > 0) {
            return supporters[1][rnd.m_188503_(supporters[1].length)];
        }
        return new Supporter(REFERENCE.HUNTER_PLAYER_KEY, "none", "none", null, new HashMap<String, String>());
    }

    public static Supporter getRandomVampire(@NotNull RandomSource rnd) {
        if (supporters[0].length > 0) {
            return supporters[0][rnd.m_188503_(supporters[0].length)];
        }
        return new Supporter(REFERENCE.VAMPIRE_PLAYER_KEY, "none", "none", null, new HashMap<String, String>());
    }

    @NotNull
    private static String getDebugString() {
        return "Vampires: " + Arrays.toString(supporters[0]) + " Hunters: " + Arrays.toString(supporters[1]);
    }

    public static void init() {
        VampirismAPI.settings().getSupportersAsync().thenAccept(optional -> optional.ifPresentOrElse(supporters -> {
            Supporter[][] supporter = new Supporter[][]{(Supporter[])supporters.stream().filter(s -> s.faction().equals((Object)REFERENCE.VAMPIRE_PLAYER_KEY)).toArray(Supporter[]::new), (Supporter[])supporters.stream().filter(s -> s.faction().equals((Object)REFERENCE.HUNTER_PLAYER_KEY)).toArray(Supporter[]::new)};
            supporters = supporter;
            LOGGER.trace("Supporters {}", (Object)SupporterManager.getDebugString());
        }, () -> LOGGER.warn("Failed to retrieve supporters")));
    }
}

