/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui.screens.skills;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.client.gui.screens.skills.SkillsScreen;
import de.teamlapen.vampirism.client.gui.screens.skills.SkillsTabScreen;
import de.teamlapen.vampirism.entity.player.skills.ActionSkill;
import de.teamlapen.vampirism.entity.player.skills.SkillHandler;
import de.teamlapen.vampirism.entity.player.skills.SkillNode;
import de.teamlapen.vampirism.entity.player.skills.SkillTree;
import de.teamlapen.vampirism.entity.player.skills.SkillTreeManager;
import de.teamlapen.vampirism.util.RegUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.NonnullDefault;

@NonnullDefault
public class SkillNodeScreen {
    private static final ResourceLocation WIDGETS_LOCATION = new ResourceLocation("vampirism", "textures/gui/skills/widgets.png");
    private static final int[] TEST_SPLIT_OFFSETS = new int[]{0, 10, -10, 25, -25};
    private final Minecraft minecraft;
    private final SkillsTabScreen tab;
    private final SkillsScreen screen;
    private final SkillNode skillNode;
    private final SkillHandler<?> skillHandler;
    private final List<SkillNodeScreen> children = new ArrayList<SkillNodeScreen>();
    @Nullable
    private final SkillNodeScreen parent;
    private final int x;
    private final int y;
    private final FormattedCharSequence[] titles;
    private final List<FormattedCharSequence>[] descriptions;
    private final int[] width;

    public SkillNodeScreen(@NotNull Minecraft minecraft, @NotNull SkillsScreen screen, @NotNull SkillsTabScreen tab, @NotNull SkillNode skillNode, @NotNull SkillHandler<?> skillHandler) {
        this(minecraft, screen, tab, skillNode, skillHandler, null, 0, 0);
    }

    public SkillNodeScreen(@NotNull Minecraft minecraft, @NotNull SkillsScreen screen, @NotNull SkillsTabScreen tab, @NotNull SkillNode skillNode, @NotNull SkillHandler<?> skillHandler, @Nullable SkillNodeScreen parent, int x, int y) {
        int i;
        this.minecraft = minecraft;
        this.tab = tab;
        this.screen = screen;
        this.skillNode = skillNode;
        this.skillHandler = skillHandler;
        this.parent = parent;
        this.x = x;
        this.y = y;
        int w = SkillTree.getTreeWidth(skillNode);
        int childrenCount = this.skillNode.getChildren().size();
        if (childrenCount > 0) {
            int pos = x;
            if (--childrenCount > 0) {
                pos -= w / 2 - 13;
            }
            for (i = 0; i < skillNode.getChildren().size(); ++i) {
                SkillNode current = skillNode.getChildren().get(i);
                this.children.add(new SkillNodeScreen(minecraft, screen, tab, current, skillHandler, this, pos, y + 60));
                pos += SkillTree.getTreeWidth(current) / 2 + 30;
                if (skillNode.getChildren().size() < i + 2) continue;
                SkillNode next = skillNode.getChildren().get(i + 1);
                pos += SkillTree.getTreeWidth(next) / 2;
            }
        }
        this.titles = new FormattedCharSequence[skillNode.getElements().length];
        this.descriptions = new List[skillNode.getElements().length];
        this.width = new int[skillNode.getElements().length];
        int l = 56;
        for (i = 0; i < skillNode.getElements().length; ++i) {
            this.titles[i] = Language.m_128107_().m_5536_(minecraft.f_91062_.m_92854_((FormattedText)skillNode.getElements()[i].getName(), 163));
            int size = Math.max(l + minecraft.f_91062_.m_92724_(this.titles[i]), 120);
            this.descriptions[i] = Language.m_128107_().m_128112_(this.findOptimalLines((Component)ComponentUtils.m_130750_((MutableComponent)Optional.ofNullable(skillNode.getElements()[i].getDescription()).orElse((Component)Component.m_237119_()).m_6881_(), (Style)Style.f_131099_.m_131140_(ChatFormatting.GRAY)), size - 30));
            this.width[i] = size;
        }
    }

    private static float getMaxWidth(@NotNull StringSplitter p_238693_0_, @NotNull List<FormattedText> p_238693_1_) {
        return (float)p_238693_1_.stream().mapToDouble(arg_0 -> ((StringSplitter)p_238693_0_).m_92384_(arg_0)).max().orElse(0.0);
    }

    private SkillNodeState getState() {
        block6: {
            block5: {
                if (Arrays.stream(this.skillNode.getElements()).anyMatch(this.skillHandler::isSkillEnabled)) {
                    return SkillNodeState.UNLOCKED;
                }
                if (this.skillHandler.isSkillNodeLocked(this.skillNode)) {
                    return SkillNodeState.LOCKED;
                }
                if (this.skillNode.getParent() == null) break block5;
                if (!Arrays.stream(this.skillNode.getParent().getElements()).anyMatch(this.skillHandler::isSkillEnabled)) break block6;
            }
            return SkillNodeState.AVAILABLE;
        }
        return this.skillNode.isHidden() ? SkillNodeState.HIDDEN : SkillNodeState.VISIBLE;
    }

    private Collection<ISkill<?>> getLockingSkills(@NotNull SkillNode node) {
        return Arrays.stream(node.getLockingNodes()).map(id -> SkillTreeManager.getInstance().getSkillTree().getNodeFromId((ResourceLocation)id)).filter(Objects::nonNull).flatMap(node2 -> Arrays.stream(node2.getElements())).filter(this.skillHandler::isSkillEnabled).collect(Collectors.toList());
    }

    public List<SkillNodeScreen> getChildren() {
        return this.children;
    }

    public SkillNode getSkillNode() {
        return this.skillNode;
    }

    public void draw(@NotNull GuiGraphics graphics, int i, int j) {
        PoseStack pose = graphics.m_280168_();
        pose.m_85836_();
        SkillNodeState state = this.getState();
        if (state == SkillNodeState.HIDDEN) {
            return;
        }
        int width = this.getNodeWidth();
        pose.m_252880_((float)(-width) / 2.0f, 0.0f, 50.0f);
        int x = i + this.getNodeStart();
        if (this.skillNode.getElements().length > 1) {
            graphics.blitWithBorder(WIDGETS_LOCATION, x, this.y + j, 200, 0, width, 26, 26, 26, 3);
        }
        for (int i1 = 0; i1 < this.skillNode.getElements().length; ++i1) {
            if (state == SkillNodeState.LOCKED || !this.skillHandler.isSkillEnabled(this.skillNode.getElements()[i1])) {
                graphics.m_280246_(0.5f, 0.5f, 0.5f, 1.0f);
            } else {
                graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
            }
            graphics.m_280218_(WIDGETS_LOCATION, x, this.y + j, this.skillNode.isRoot() ? 226 : 200, 0, 26, 26);
            graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
            RenderSystem.enableBlend();
            graphics.m_280163_(this.getSkillIconLocation(this.skillNode.getElements()[i1]), x + 5, this.y + j + 5, 0.0f, 0.0f, 16, 16, 16, 16);
            x += 36;
        }
        pose.m_85849_();
        for (SkillNodeScreen child : this.children) {
            child.draw(graphics, i, j);
        }
    }

    public void drawConnectivity(@NotNull GuiGraphics graphics, int startX, int startY, boolean outerLine) {
        SkillNodeState state = this.getState();
        if (state == SkillNodeState.HIDDEN) {
            return;
        }
        if (this.parent != null) {
            int color = state.pathColor(outerLine);
            PoseStack pose = graphics.m_280168_();
            pose.m_85836_();
            if (state == SkillNodeState.UNLOCKED) {
                pose.m_252880_(0.0f, 0.0f, 10.0f);
            }
            int i = startX + this.x;
            int i1 = startX + this.parent.x;
            int j = startY + this.y - 30;
            int j2 = startY + this.parent.y + 13;
            int j3 = startY + this.y - 29;
            int j4 = startY + this.parent.y + 13 + 16;
            int i2 = startX + this.x;
            int j5 = startY + this.y;
            int i3 = startX + this.parent.x;
            if (outerLine) {
                graphics.m_280656_(i, i1, j - 1, color);
                graphics.m_280656_(i, i1, j + 1, color);
                graphics.m_280315_(i1 - 1, j2, j3, color);
                graphics.m_280315_(i3 + 1, j2, j3, color);
                graphics.m_280315_(i - 1, j4, j5 + 1, color);
                graphics.m_280315_(i2 + 1, j4, j5 + 1, color);
            } else {
                graphics.m_280656_(i, i1, j, color);
                graphics.m_280315_(i1, j2, j3, color);
                graphics.m_280315_(i, j4, j5 + 1, color);
            }
            pose.m_85849_();
        }
        for (SkillNodeScreen child : this.children) {
            child.drawConnectivity(graphics, startX, startY, outerLine);
        }
    }

    private int getNodeWidth() {
        return 26 * this.skillNode.getElements().length + (this.skillNode.getElements().length - 1) * 10;
    }

    public void drawHover(@NotNull GuiGraphics graphics, double mouseX, double mouseY, float fade, int scrollX, int scrollY) {
        SkillNodeState state = this.getState();
        if (state == SkillNodeState.HIDDEN) {
            return;
        }
        ISkill<?>[] elements = this.skillNode.getElements();
        scrollX = (int)((float)scrollX - (float)this.getNodeWidth() / 2.0f);
        int hoveredSkillIndex = -1;
        for (int i = 0; i < elements.length; ++i) {
            if (!this.isMouseOverSkill(i, mouseX, mouseY, scrollX, scrollY)) continue;
            hoveredSkillIndex = i;
            break;
        }
        if (hoveredSkillIndex != -1) {
            ISkill<?> hoveredSkill = elements[hoveredSkillIndex];
            int x = this.getNodeStart() + 36 * hoveredSkillIndex;
            Collection<ISkill<?>> lockingSkills = this.getLockingSkills(this.skillNode);
            if (state == SkillNodeState.LOCKED || state == SkillNodeState.VISIBLE) {
                ArrayList<MutableComponent> text = new ArrayList<MutableComponent>();
                if (state == SkillNodeState.VISIBLE) {
                    MutableComponent t1 = Component.m_237115_((String)"text.vampirism.skill.unlock_parent_first").m_130940_(ChatFormatting.DARK_RED);
                    text.add(t1);
                } else {
                    text.add(Component.m_237115_((String)"text.vampirism.skill.locked"));
                    lockingSkills.stream().map(a -> a.getName().m_6881_().m_130940_(ChatFormatting.DARK_RED)).forEach(text::add);
                }
                int width = text.stream().mapToInt(arg_0 -> ((Font)this.minecraft.f_91062_).m_92852_(arg_0)).max().getAsInt();
                graphics.blitWithBorder(WIDGETS_LOCATION, scrollX + x - 3, scrollY + this.y - 3 - text.size() * 9, 0, 81, width + 8, 10 + text.size() * 10, 200, 20, 3);
                int fontY = scrollY + this.y + 1 - text.size() * 9;
                for (int i = 0; i < text.size(); ++i) {
                    graphics.m_280614_(this.minecraft.f_91062_, (Component)text.get(i), scrollX + x + 2, fontY + i * 9, -1, true);
                }
            }
            List<FormattedCharSequence> description = this.descriptions[hoveredSkillIndex];
            if (!lockingSkills.isEmpty()) {
                ArrayList<MutableComponent> text = new ArrayList<MutableComponent>();
                text.add(Component.m_237115_((String)"text.vampirism.skill.excluding"));
                lockingSkills.stream().map(a -> a.getName().m_6881_().m_130940_(ChatFormatting.YELLOW)).forEach(text::add);
                int width = Math.min(this.width[hoveredSkillIndex], text.stream().mapToInt(arg_0 -> ((Font)this.minecraft.f_91062_).m_92852_(arg_0)).max().getAsInt());
                int yOffset = description.isEmpty() ? 15 : 24;
                graphics.blitWithBorder(WIDGETS_LOCATION, scrollX + x - 3, scrollY + this.y + 3 + 7 + description.size() * 9, 0, 81, width + 8, text.size() * 10 + yOffset, 200, 20, 3);
                int fontY = scrollY + this.y + 3 + yOffset + 8 + description.size() * 9;
                for (int i = 0; i < text.size(); ++i) {
                    graphics.m_280614_(this.minecraft.f_91062_, (Component)text.get(i), scrollX + x + 2, fontY + i * 9, -1, true);
                }
            }
            if (!description.isEmpty()) {
                graphics.blitWithBorder(WIDGETS_LOCATION, scrollX + x - 5, scrollY + this.y + 3, 0, 81, this.width[hoveredSkillIndex], 30 + description.size() * 9, 200, 20, 3);
                for (int i = 0; i < description.size(); ++i) {
                    graphics.m_280649_(this.minecraft.f_91062_, description.get(i), scrollX + x + 2, scrollY + this.y + 3 + 24 + i * 9, -1, true);
                }
            }
            int wid = this.width[hoveredSkillIndex] / 2;
            int titleTextureY = state.titleTextureY;
            if (state == SkillNodeState.UNLOCKED && !this.skillHandler.isSkillEnabled(hoveredSkill)) {
                titleTextureY = SkillNodeState.LOCKED.titleTextureY;
            }
            graphics.m_280218_(WIDGETS_LOCATION, scrollX + x - 5, scrollY + this.y + 3, 0, titleTextureY, wid, 22);
            graphics.m_280218_(WIDGETS_LOCATION, scrollX + x - 5 + wid, scrollY + this.y + 3, 200 - wid, titleTextureY, wid, 22);
            graphics.m_280649_(this.minecraft.f_91062_, this.titles[hoveredSkillIndex], scrollX + x + 40, scrollY + this.y + 9, -1, true);
            if (!this.skillNode.isRoot()) {
                int cost = hoveredSkill.getSkillPointCost();
                int costWidth = this.minecraft.f_91062_.m_92895_(String.valueOf(cost));
                Objects.requireNonNull(this.minecraft.f_91062_);
                int costHeight = 9;
                graphics.blitWithBorder(WIDGETS_LOCATION, scrollX + x + 24, scrollY + this.y + (26 - costHeight) / 2 - 1, 0, 81, costWidth + 5, costHeight + 4, 200, 20, 3);
                graphics.m_280614_(this.minecraft.f_91062_, (Component)Component.m_237113_((String)String.valueOf(cost)), scrollX + x + 27, (int)((float)(scrollY + this.y) + (float)(26 - costHeight) / 2.0f + 1.0f), -1, true);
            }
            graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
            graphics.m_280218_(WIDGETS_LOCATION, scrollX + x, scrollY + this.y, this.skillNode.isRoot() ? 226 : 200, 0, 26, 26);
            RenderSystem.enableBlend();
            graphics.m_280163_(this.getSkillIconLocation(hoveredSkill), x + scrollX + 5, this.y + scrollY + 5, 0.0f, 0.0f, 16, 16, 16, 16);
        }
    }

    private List<FormattedCharSequence> getSkillDescription(int skill) {
        List<FormattedCharSequence> description = this.descriptions[skill];
        ISkillHandler.Result result = this.skillHandler.canSkillBeEnabled(this.skillNode.getElements()[skill]);
        List<ISkill<?>> lockingSkills = null;
        ChatFormatting lockingColor = ChatFormatting.BLACK;
        if (this.skillNode.getLockingNodes().length != 0) {
            lockingSkills = this.skillHandler.getLockingSkills(this.skillNode);
            ChatFormatting chatFormatting = result == ISkillHandler.Result.ALREADY_ENABLED ? ChatFormatting.DARK_GRAY : (lockingColor = lockingSkills.stream().anyMatch(this.skillHandler::isSkillEnabled) ? ChatFormatting.DARK_RED : ChatFormatting.YELLOW);
        }
        if (lockingSkills != null) {
            int l = 56;
            int size = Math.max(l + this.minecraft.f_91062_.m_92724_(this.titles[skill]), 120) - 20;
            description = new ArrayList<FormattedCharSequence>(description);
            description.addAll(Language.m_128107_().m_128112_(this.findOptimalLines((Component)Component.m_237115_((String)"text.vampirism.skill.excluding").m_130940_(lockingColor), size)));
            for (ISkill<?> lockingSkill : lockingSkills) {
                description.addAll(Language.m_128107_().m_128112_(this.findOptimalLines((Component)Component.m_237113_((String)"  ").m_7220_((Component)lockingSkill.getName().m_6881_().m_130940_(lockingColor)), size)));
            }
        }
        return description;
    }

    private ResourceLocation getSkillIconLocation(@NotNull ISkill skill) {
        if (skill instanceof ActionSkill) {
            return new ResourceLocation(((ActionSkill)skill).getActionID().m_135827_(), "textures/actions/" + ((ActionSkill)skill).getActionID().m_135815_() + ".png");
        }
        ResourceLocation id = RegUtil.id(skill);
        return new ResourceLocation(id.m_135827_(), "textures/skills/" + id.m_135815_() + ".png");
    }

    public boolean isMouseOver(double mouseX, double mouseY, int scrollX, int scrollY) {
        double width = this.getNodeWidth();
        return mouseX >= (double)(this.x + scrollX) - width / 2.0 && mouseX < (double)(this.x + scrollX) + width / 2.0 - 1.0 && mouseY > (double)(scrollY + this.y) && mouseY < (double)(scrollY + this.y + 26);
    }

    public boolean isMouseOverSkill(int index, double mouseX, double mouseY, int guiLeft, int guiTop) {
        int x = this.x + 36 * index;
        return mouseX > (double)(x + guiLeft) && mouseX < (double)(x + guiLeft + 26) && mouseY > (double)(guiTop + this.y) && mouseY < (double)(guiTop + this.y + 26);
    }

    @Nullable
    public ISkill getSelectedSkill(double mouseX, double mouseY, int scrollX, int scrollY) {
        if (!this.isMouseOver(mouseX, mouseY, scrollX, scrollY)) {
            return null;
        }
        int nodeWidth = this.getNodeWidth();
        for (int i = 0; i < this.skillNode.getElements().length; ++i) {
            if (!this.isMouseOverSkill(i, mouseX, mouseY, (int)((float)scrollX - (float)nodeWidth / 2.0f), scrollY)) continue;
            return this.skillNode.getElements()[i];
        }
        return null;
    }

    private int getNodeStart() {
        int x = this.x;
        return x;
    }

    private List<FormattedText> findOptimalLines(@NotNull Component p_238694_1_, int p_238694_2_) {
        StringSplitter charactermanager = this.minecraft.f_91062_.m_92865_();
        List list = Collections.emptyList();
        float f = Float.MAX_VALUE;
        for (int i : TEST_SPLIT_OFFSETS) {
            List list1 = charactermanager.m_92414_((FormattedText)p_238694_1_, p_238694_2_ - i, Style.f_131099_);
            float f1 = Math.abs(SkillNodeScreen.getMaxWidth(charactermanager, list1) - (float)p_238694_2_);
            if (f1 <= 10.0f) {
                return list1;
            }
            if (!(f1 < f)) continue;
            f = f1;
            list = list1;
        }
        return list;
    }

    static enum SkillNodeState {
        AVAILABLE(3, -5789785, -1),
        HIDDEN(0, 0, 0),
        LOCKED(55, -3211264, -9830400),
        UNLOCKED(29, -16742639, -16755964),
        VISIBLE(3, -14540254, -12632257);

        public final int titleTextureY;
        public final int innerColor;
        public final int outerColor;

        private SkillNodeState(int titleTextureY, int innerColor, int outerColor) {
            this.titleTextureY = titleTextureY;
            this.outerColor = outerColor;
            this.innerColor = innerColor;
        }

        int pathColor(boolean outer) {
            return outer ? this.outerColor : this.innerColor;
        }
    }
}

