/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.core;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.platform.InputConstants;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.client.gui.screens.SelectActionRadialScreen;
import de.teamlapen.vampirism.client.gui.screens.SelectAmmoScreen;
import de.teamlapen.vampirism.client.gui.screens.SelectMinionTaskRadialScreen;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.entity.player.vampire.actions.VampireActions;
import de.teamlapen.vampirism.network.ServerboundSimpleInputEvent;
import de.teamlapen.vampirism.network.ServerboundStartFeedingPacket;
import de.teamlapen.vampirism.network.ServerboundToggleActionPacket;
import de.teamlapen.vampirism.util.RegUtil;
import it.unimi.dsi.fastutil.ints.Int2LongArrayMap;
import java.util.Map;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class ModKeys {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final long ACTION_BUTTON_COOLDOWN = 500L;
    private static final String CATEGORY = "keys.vampirism.category";
    private static final String SUCK_BLOOD = "keys.vampirism.suck";
    private static final String TOGGLE_ACTIONS = "keys.vampirism.action";
    private static final String OPEN_VAMPIRISM_MENU = "keys.vampirism.select_skills";
    private static final String SWITCH_VISION = "keys.vampirism.vision";
    private static final String ACTIVATE_ACTION1 = "keys.vampirism.action1";
    private static final String ACTIVATE_ACTION2 = "keys.vampirism.action2";
    private static final String ACTIVATE_ACTION3 = "keys.vampirism.action3";
    private static final String ACTIVATE_ACTION4 = "keys.vampirism.action4";
    private static final String ACTIVATE_ACTION5 = "keys.vampirism.action5";
    private static final String ACTIVATE_ACTION6 = "keys.vampirism.action6";
    private static final String ACTIVATE_ACTION7 = "keys.vampirism.action7";
    private static final String ACTIVATE_ACTION8 = "keys.vampirism.action8";
    private static final String ACTIVATE_ACTION9 = "keys.vampirism.action9";
    private static final String MINION_TASK = "keys.vampirism.minion_task";
    private static final String SELECT_AMMO_NAME = "keys.vampirism.select_ammo";
    public static final KeyMapping SUCK = new KeyMapping("keys.vampirism.suck", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, 86, "keys.vampirism.category");
    public static final KeyMapping ACTION = new KeyMapping("keys.vampirism.action", InputConstants.Type.KEYSYM, 82, "keys.vampirism.category");
    public static final KeyMapping VAMPIRISM_MENU = new KeyMapping("keys.vampirism.select_skills", InputConstants.Type.KEYSYM, 80, "keys.vampirism.category");
    public static final KeyMapping VISION = new KeyMapping("keys.vampirism.vision", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, 78, "keys.vampirism.category");
    public static final KeyMapping ACTION1 = new KeyMapping("keys.vampirism.action1", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.ALT, InputConstants.Type.KEYSYM, 49, "keys.vampirism.category");
    public static final KeyMapping ACTION2 = new KeyMapping("keys.vampirism.action2", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.ALT, InputConstants.Type.KEYSYM, 50, "keys.vampirism.category");
    public static final KeyMapping ACTION3 = new KeyMapping("keys.vampirism.action3", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.ALT, InputConstants.Type.KEYSYM, 51, "keys.vampirism.category");
    public static final KeyMapping ACTION4 = new KeyMapping("keys.vampirism.action4", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.f_84822_, "keys.vampirism.category");
    public static final KeyMapping ACTION5 = new KeyMapping("keys.vampirism.action5", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.f_84822_, "keys.vampirism.category");
    public static final KeyMapping ACTION6 = new KeyMapping("keys.vampirism.action6", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.f_84822_, "keys.vampirism.category");
    public static final KeyMapping ACTION7 = new KeyMapping("keys.vampirism.action7", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.f_84822_, "keys.vampirism.category");
    public static final KeyMapping ACTION8 = new KeyMapping("keys.vampirism.action8", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.f_84822_, "keys.vampirism.category");
    public static final KeyMapping ACTION9 = new KeyMapping("keys.vampirism.action9", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.f_84822_, "keys.vampirism.category");
    public static final KeyMapping MINION = new KeyMapping("keys.vampirism.minion_task", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.f_84822_, "keys.vampirism.category");
    public static final KeyMapping SELECT_AMMO = new KeyMapping("keys.vampirism.select_ammo", InputConstants.Type.KEYSYM, 67, "keys.vampirism.category");
    public static final Map<Integer, KeyMapping> ACTION_KEYS = Map.of(1, ACTION1, 2, ACTION2, 3, ACTION3, 4, ACTION4, 5, ACTION5, 6, ACTION6, 7, ACTION7, 8, ACTION8, 9, ACTION9);
    private boolean suckKeyDown = false;
    private final Map<KeyMapping, Runnable> keyMappingActions;
    private final Minecraft mc;
    private final Int2LongArrayMap actionTriggerTime = new Int2LongArrayMap();

    static void registerKeyMapping(@NotNull RegisterKeyMappingsEvent event) {
        event.register(ACTION);
        event.register(SUCK);
        event.register(VAMPIRISM_MENU);
        event.register(VISION);
        event.register(MINION);
        event.register(SELECT_AMMO);
        ACTION_KEYS.forEach((i, k) -> event.register(k));
    }

    public ModKeys() {
        ImmutableMap.Builder keyMappingActions = ImmutableMap.builder();
        keyMappingActions.put((Object)ACTION, this::openActionMenu);
        keyMappingActions.put((Object)VAMPIRISM_MENU, this::openVampirismMenu);
        keyMappingActions.put((Object)VISION, this::switchVision);
        keyMappingActions.put((Object)MINION, this::openMinionTaskMenu);
        keyMappingActions.put((Object)SELECT_AMMO, this::selectAmmo);
        ACTION_KEYS.forEach((i, key) -> keyMappingActions.put(key, () -> this.toggleAction((int)i)));
        this.keyMappingActions = keyMappingActions.build();
        this.mc = Minecraft.m_91087_();
    }

    @SubscribeEvent
    public void handleMouseButton(InputEvent.MouseButton.Pre event) {
        this.handleInputEvent((InputEvent)event, event.getAction());
    }

    @SubscribeEvent
    public void handleKey(InputEvent.Key event) {
        this.handleInputEvent((InputEvent)event, event.getAction());
    }

    public void handleInputEvent(InputEvent event, int action) {
        if (SUCK.m_90857_()) {
            this.suck();
        } else {
            this.endSuck();
            if (action == 1) {
                for (Map.Entry<KeyMapping, Runnable> entry : this.keyMappingActions.entrySet()) {
                    if (!entry.getKey().m_90857_()) continue;
                    entry.getValue().run();
                    break;
                }
            }
        }
    }

    private void suck() {
        if (!this.suckKeyDown) {
            HitResult mouseOver = Minecraft.m_91087_().f_91077_;
            this.suckKeyDown = true;
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (mouseOver != null && !player.m_5833_() && VampirePlayer.getOpt((Player)player).map(vp -> vp.getLevel() > 0 && !vp.getActionHandler().isActionActive((ILastingAction)VampireActions.BAT.get())).orElse(false).booleanValue()) {
                if (mouseOver instanceof EntityHitResult) {
                    VampirismMod.dispatcher.sendToServer(new ServerboundStartFeedingPacket(((EntityHitResult)mouseOver).m_82443_().m_19879_()));
                } else if (mouseOver instanceof BlockHitResult) {
                    BlockPos pos = ((BlockHitResult)mouseOver).m_82425_();
                    VampirismMod.dispatcher.sendToServer(new ServerboundStartFeedingPacket(pos));
                } else {
                    LOGGER.warn("Unknown mouse over type while trying to feed");
                }
            }
        }
    }

    private void endSuck() {
        if (this.suckKeyDown) {
            this.suckKeyDown = false;
            VampirismMod.dispatcher.sendToServer(new ServerboundSimpleInputEvent(ServerboundSimpleInputEvent.Type.FINISH_SUCK_BLOOD));
        }
    }

    private void openActionMenu() {
        if (this.mc.f_91074_.m_6084_() && !this.mc.f_91074_.m_5833_()) {
            SelectActionRadialScreen.show();
        }
    }

    private void openVampirismMenu() {
        VampirismMod.dispatcher.sendToServer(new ServerboundSimpleInputEvent(ServerboundSimpleInputEvent.Type.VAMPIRISM_MENU));
    }

    private void switchVision() {
        VampirismMod.dispatcher.sendToServer(new ServerboundSimpleInputEvent(ServerboundSimpleInputEvent.Type.TOGGLE_VAMPIRE_VISION));
    }

    private void openMinionTaskMenu() {
        if (Minecraft.m_91087_().f_91074_.m_5833_()) {
            return;
        }
        FactionPlayerHandler.getOpt((Player)this.mc.f_91074_).filter(p -> p.getLordLevel() > 0).ifPresent(p -> SelectMinionTaskRadialScreen.show());
    }

    private void toggleAction(int id) {
        long t = System.currentTimeMillis();
        if (t - this.actionTriggerTime.getOrDefault(id, 0L) > 500L) {
            this.actionTriggerTime.put(id, t);
            LocalPlayer player = this.mc.f_91074_;
            if (player.m_6084_()) {
                FactionPlayerHandler.getOpt((Player)player).ifPresent(factionHandler -> factionHandler.getCurrentFactionPlayer().ifPresent(factionPlayer -> this.toggleBoundAction((IFactionPlayer<?>)factionPlayer, factionHandler.getBoundAction(id))));
            }
        }
    }

    private void toggleBoundAction(@NotNull IFactionPlayer<?> player, @Nullable IAction<?> action) {
        if (action == null) {
            player.getRepresentingPlayer().m_5661_((Component)Component.m_237110_((String)"text.vampirism.action.not_bound", (Object[])new Object[]{"/vampirism bind-action"}), true);
        } else if (action.getFaction().map(faction -> !faction.equals(player.getFaction())).orElse(false).booleanValue()) {
            player.getRepresentingPlayer().m_5661_((Component)Component.m_237110_((String)"text.vampirism.action.only_faction", (Object[])new Object[]{action.getFaction().get().getName()}), true);
        } else {
            VampirismMod.dispatcher.sendToServer(ServerboundToggleActionPacket.createFromRaytrace(RegUtil.id(action), Minecraft.m_91087_().f_91077_));
        }
    }

    private void selectAmmo() {
        if (this.mc.f_91074_.m_6084_()) {
            SelectAmmoScreen.show();
        }
    }
}

