/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib.proxy;

import de.teamlapen.lib.HelperRegistry;
import de.teamlapen.lib.lib.network.ISyncable;
import de.teamlapen.lib.network.ClientboundUpdateEntityPacket;
import de.teamlapen.lib.proxy.CommonProxy;
import de.teamlapen.lib.util.ISoundReference;
import de.teamlapen.lib.util.SoundReference;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.util.thread.EffectiveSide;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class ClientProxy
extends CommonProxy {
    private static final Logger LOGGER = LogManager.getLogger();

    private static void handleCapability(Entity e, ResourceLocation key, CompoundTag data) {
        Capability cap = (Capability)HelperRegistry.getSyncableEntityCaps().get((Object)key);
        if (cap == null && e instanceof Player) {
            cap = (Capability)HelperRegistry.getSyncablePlayerCaps().get((Object)key);
        }
        if (cap == null) {
            LOGGER.warn("Capability with key {} is not registered in the HelperRegistry", (Object)key);
        } else {
            LazyOptional opt = e.getCapability(cap);
            opt.ifPresent(inst -> inst.loadUpdateFromNBT(data));
            if (!opt.isPresent()) {
                LOGGER.warn("Target entity {} does not have capability {}", (Object)e, (Object)cap);
            }
        }
    }

    @Override
    @NotNull
    public ISoundReference createMasterSoundReference(@NotNull SoundEvent event, float volume, float pinch) {
        return new SoundReference((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)event, (float)volume, (float)pinch));
    }

    @Override
    @NotNull
    public ISoundReference createSoundReference(@NotNull SoundEvent event, @NotNull SoundSource category, @NotNull BlockPos pos, float volume, float pinch) {
        return new SoundReference((SoundInstance)new SimpleSoundInstance(event, category, volume, pinch, RandomSource.m_216327_(), pos));
    }

    @Override
    @NotNull
    public ISoundReference createSoundReference(@NotNull SoundEvent event, @NotNull SoundSource category, double x, double y, double z, float volume, float pinch) {
        return new SoundReference((SoundInstance)new SimpleSoundInstance(event, category, volume, pinch, RandomSource.m_216327_(), (double)((float)x), (double)((float)y), (double)((float)z)));
    }

    @Override
    @NotNull
    public String getActiveLanguage() {
        return Minecraft.m_91087_().m_91102_().m_264236_().toString();
    }

    @Override
    @Nullable
    public Player getPlayerEntity(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull NetworkEvent.Context ctx) {
        return EffectiveSide.get() == LogicalSide.CLIENT ? Minecraft.m_91087_().f_91074_ : super.getPlayerEntity(ctx);
    }

    @Override
    public Level getWorldFromKey(ResourceKey<Level> world) {
        Level serverWorld = super.getWorldFromKey(world);
        if (serverWorld != null) {
            return serverWorld;
        }
        ClientLevel clientWorld = Minecraft.m_91087_().f_91073_;
        if (clientWorld != null && clientWorld.m_46472_().equals(world)) {
            return clientWorld;
        }
        return null;
    }

    @Override
    public void handleUpdateEntityPacket(@NotNull ClientboundUpdateEntityPacket msg) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            LOGGER.error("Cannot handle update package because sending player entity is null. Message: {}", (Object)msg);
        } else {
            Entity e = player.m_20193_().m_6815_(msg.getId());
            if (e == null) {
                LOGGER.error("Did not find entity {}", (Object)msg.getId());
                if (msg.isPlayerItself()) {
                    LOGGER.error("Message is meant for player itself, but id mismatch {} {}. Loading anyway.", (Object)player.m_19879_(), (Object)msg.getId());
                    e = player;
                }
            }
            if (e != null) {
                if (msg.getData() != null) {
                    try {
                        ISyncable syncable = (ISyncable)e;
                        syncable.loadUpdateFromNBT(msg.getData());
                    }
                    catch (ClassCastException ex) {
                        LOGGER.warn("Target entity {} does not implement ISyncable ({})", (Object)e, (Object)ex);
                    }
                }
                if (msg.getCaps() != null) {
                    for (String key : msg.getCaps().m_128431_()) {
                        ClientProxy.handleCapability(e, new ResourceLocation(key), msg.getCaps().m_128469_(key));
                    }
                }
            }
        }
    }
}

