/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.network.message.SendEffectMessage;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class RequestEffectMessage {
    private final int id;

    public RequestEffectMessage(int id) {
        this.id = id;
    }

    public static void encode(RequestEffectMessage message, FriendlyByteBuf buf) {
        buf.writeInt(message.id);
    }

    public static RequestEffectMessage decode(FriendlyByteBuf buf) {
        return new RequestEffectMessage(buf.readInt());
    }

    public static void handle(RequestEffectMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isServer()) {
            context.enqueueWork(() -> {
                EntityMaid maid;
                ServerPlayer sender = context.getSender();
                if (sender == null) {
                    return;
                }
                Entity entity = sender.f_19853_.m_6815_(message.id);
                if (entity instanceof EntityMaid && (maid = (EntityMaid)entity).m_21830_((LivingEntity)sender)) {
                    SendEffectMessage sendEffectMessage = new SendEffectMessage(message.id, maid.m_21220_());
                    NetworkHandler.sendToClientPlayer(sendEffectMessage, (Player)sender);
                }
            });
        }
        context.setPacketHandled(true);
    }
}

