/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network;

import com.github.tartaricacid.touhoulittlemaid.network.message.BeaconAbsorbMessage;
import com.github.tartaricacid.touhoulittlemaid.network.message.ChairModelMessage;
import com.github.tartaricacid.touhoulittlemaid.network.message.CheckSchedulePosMessage;
import com.github.tartaricacid.touhoulittlemaid.network.message.ChessDataToClientMessage;
import com.github.tartaricacid.touhoulittlemaid.network.message.ChessDataToServerMessage;
import com.github.tartaricacid.touhoulittlemaid.network.message.FoxScrollMessage;
import com.github.tartaricacid.touhoulittlemaid.network.message.ItemBreakMessage;
import com.github.tartaricacid.touhoulittlemaid.network.message.MaidConfigMessage;
import com.github.tartaricacid.touhoulittlemaid.network.message.MaidModelMessage;
import com.github.tartaricacid.touhoulittlemaid.network.message.MaidTaskMessage;
import com.github.tartaricacid.touhoulittlemaid.network.message.OpenBeaconGuiMessage;
import com.github.tartaricacid.touhoulittlemaid.network.message.OpenChairGuiMessage;
import com.github.tartaricacid.touhoulittlemaid.network.message.OpenSwitcherGuiMessage;
import com.github.tartaricacid.touhoulittlemaid.network.message.PlayMaidSoundMessage;
import com.github.tartaricacid.touhoulittlemaid.network.message.RequestEffectMessage;
import com.github.tartaricacid.touhoulittlemaid.network.message.SaveSwitcherDataMessage;
import com.github.tartaricacid.touhoulittlemaid.network.message.SendEffectMessage;
import com.github.tartaricacid.touhoulittlemaid.network.message.SendNameTagMessage;
import com.github.tartaricacid.touhoulittlemaid.network.message.ServantBellSetMessage;
import com.github.tartaricacid.touhoulittlemaid.network.message.SetBeaconOverflowMessage;
import com.github.tartaricacid.touhoulittlemaid.network.message.SetBeaconPotionMessage;
import com.github.tartaricacid.touhoulittlemaid.network.message.SetMaidSoundIdMessage;
import com.github.tartaricacid.touhoulittlemaid.network.message.SetMonsterListMessage;
import com.github.tartaricacid.touhoulittlemaid.network.message.SetScrollData;
import com.github.tartaricacid.touhoulittlemaid.network.message.SpawnParticleMessage;
import com.github.tartaricacid.touhoulittlemaid.network.message.StorageAndTakePowerMessage;
import com.github.tartaricacid.touhoulittlemaid.network.message.SyncCapabilityMessage;
import com.github.tartaricacid.touhoulittlemaid.network.message.SyncMaidAreaMessage;
import com.github.tartaricacid.touhoulittlemaid.network.message.ToggleTabMessage;
import com.github.tartaricacid.touhoulittlemaid.network.message.WirelessIOGuiMessage;
import com.github.tartaricacid.touhoulittlemaid.network.message.WirelessIOSlotConfigMessage;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public final class NetworkHandler {
    private static final String VERSION = "1.0.0";
    public static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("touhou_little_maid", "network"), () -> "1.0.0", it -> it.equals(VERSION), it -> it.equals(VERSION));

    public static void init() {
        CHANNEL.registerMessage(0, MaidModelMessage.class, MaidModelMessage::encode, MaidModelMessage::decode, MaidModelMessage::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        CHANNEL.registerMessage(1, ChairModelMessage.class, ChairModelMessage::encode, ChairModelMessage::decode, ChairModelMessage::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        CHANNEL.registerMessage(2, OpenChairGuiMessage.class, OpenChairGuiMessage::encode, OpenChairGuiMessage::decode, OpenChairGuiMessage::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        CHANNEL.registerMessage(3, MaidConfigMessage.class, MaidConfigMessage::encode, MaidConfigMessage::decode, MaidConfigMessage::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        CHANNEL.registerMessage(4, MaidTaskMessage.class, MaidTaskMessage::encode, MaidTaskMessage::decode, MaidTaskMessage::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        CHANNEL.registerMessage(5, SendNameTagMessage.class, SendNameTagMessage::encode, SendNameTagMessage::decode, SendNameTagMessage::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        CHANNEL.registerMessage(6, ItemBreakMessage.class, ItemBreakMessage::encode, ItemBreakMessage::decode, ItemBreakMessage::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        CHANNEL.registerMessage(7, SpawnParticleMessage.class, SpawnParticleMessage::encode, SpawnParticleMessage::decode, SpawnParticleMessage::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        CHANNEL.registerMessage(8, SyncCapabilityMessage.class, SyncCapabilityMessage::encode, SyncCapabilityMessage::decode, SyncCapabilityMessage::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        CHANNEL.registerMessage(9, WirelessIOGuiMessage.class, WirelessIOGuiMessage::encode, WirelessIOGuiMessage::decode, WirelessIOGuiMessage::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        CHANNEL.registerMessage(10, WirelessIOSlotConfigMessage.class, WirelessIOSlotConfigMessage::encode, WirelessIOSlotConfigMessage::decode, WirelessIOSlotConfigMessage::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        CHANNEL.registerMessage(11, OpenBeaconGuiMessage.class, OpenBeaconGuiMessage::encode, OpenBeaconGuiMessage::decode, OpenBeaconGuiMessage::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        CHANNEL.registerMessage(12, SetBeaconPotionMessage.class, SetBeaconPotionMessage::encode, SetBeaconPotionMessage::decode, SetBeaconPotionMessage::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        CHANNEL.registerMessage(13, StorageAndTakePowerMessage.class, StorageAndTakePowerMessage::encode, StorageAndTakePowerMessage::decode, StorageAndTakePowerMessage::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        CHANNEL.registerMessage(14, SetBeaconOverflowMessage.class, SetBeaconOverflowMessage::encode, SetBeaconOverflowMessage::decode, SetBeaconOverflowMessage::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        CHANNEL.registerMessage(15, BeaconAbsorbMessage.class, BeaconAbsorbMessage::encode, BeaconAbsorbMessage::decode, BeaconAbsorbMessage::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        CHANNEL.registerMessage(16, OpenSwitcherGuiMessage.class, OpenSwitcherGuiMessage::encode, OpenSwitcherGuiMessage::decode, OpenSwitcherGuiMessage::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        CHANNEL.registerMessage(17, SaveSwitcherDataMessage.class, SaveSwitcherDataMessage::encode, SaveSwitcherDataMessage::decode, SaveSwitcherDataMessage::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        CHANNEL.registerMessage(18, ToggleTabMessage.class, ToggleTabMessage::encode, ToggleTabMessage::decode, ToggleTabMessage::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        CHANNEL.registerMessage(19, RequestEffectMessage.class, RequestEffectMessage::encode, RequestEffectMessage::decode, RequestEffectMessage::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        CHANNEL.registerMessage(20, SendEffectMessage.class, SendEffectMessage::encode, SendEffectMessage::decode, SendEffectMessage::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        CHANNEL.registerMessage(21, PlayMaidSoundMessage.class, PlayMaidSoundMessage::encode, PlayMaidSoundMessage::decode, PlayMaidSoundMessage::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        CHANNEL.registerMessage(22, SetMaidSoundIdMessage.class, SetMaidSoundIdMessage::encode, SetMaidSoundIdMessage::decode, SetMaidSoundIdMessage::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        CHANNEL.registerMessage(23, ChessDataToClientMessage.class, ChessDataToClientMessage::encode, ChessDataToClientMessage::decode, ChessDataToClientMessage::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        CHANNEL.registerMessage(24, ChessDataToServerMessage.class, ChessDataToServerMessage::encode, ChessDataToServerMessage::decode, ChessDataToServerMessage::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        CHANNEL.registerMessage(25, FoxScrollMessage.class, FoxScrollMessage::encode, FoxScrollMessage::decode, FoxScrollMessage::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        CHANNEL.registerMessage(26, SetScrollData.class, SetScrollData::encode, SetScrollData::decode, SetScrollData::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        CHANNEL.registerMessage(27, CheckSchedulePosMessage.class, CheckSchedulePosMessage::encode, CheckSchedulePosMessage::decode, CheckSchedulePosMessage::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        CHANNEL.registerMessage(28, SyncMaidAreaMessage.class, SyncMaidAreaMessage::encode, SyncMaidAreaMessage::decode, SyncMaidAreaMessage::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        CHANNEL.registerMessage(29, ServantBellSetMessage.class, ServantBellSetMessage::encode, ServantBellSetMessage::decode, ServantBellSetMessage::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        CHANNEL.registerMessage(30, SetMonsterListMessage.class, SetMonsterListMessage::encode, SetMonsterListMessage::decode, SetMonsterListMessage::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
    }

    public static void sendToClientPlayer(Object message, Player player) {
        CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), message);
    }

    public static void sendToNearby(Level world, BlockPos pos, Object toSend) {
        if (world instanceof ServerLevel) {
            ServerLevel ws = (ServerLevel)world;
            ws.m_7726_().f_8325_.m_183262_(new ChunkPos(pos), false).stream().filter(p -> p.m_20275_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()) < 36864.0).forEach(p -> CHANNEL.send(PacketDistributor.PLAYER.with(() -> p), toSend));
        }
    }

    public static void sendToNearby(Entity entity, Object toSend) {
        if (entity.f_19853_ instanceof ServerLevel) {
            ServerLevel ws = (ServerLevel)entity.m_9236_();
            BlockPos pos = entity.m_20183_();
            ws.m_7726_().f_8325_.m_183262_(new ChunkPos(pos), false).stream().filter(p -> p.m_20275_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()) < 36864.0).forEach(p -> CHANNEL.send(PacketDistributor.PLAYER.with(() -> p), toSend));
        }
    }

    public static void sendToNearby(Entity entity, Object toSend, int distance) {
        if (entity.f_19853_ instanceof ServerLevel) {
            ServerLevel ws = (ServerLevel)entity.m_9236_();
            BlockPos pos = entity.m_20183_();
            ws.m_7726_().f_8325_.m_183262_(new ChunkPos(pos), false).stream().filter(p -> p.m_20275_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()) < (double)(distance * distance)).forEach(p -> CHANNEL.send(PacketDistributor.PLAYER.with(() -> p), toSend));
        }
    }
}

