/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.client.gui.item.ServantBellSetScreen;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.world.data.MaidInfo;
import com.github.tartaricacid.touhoulittlemaid.world.data.MaidWorldData;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import org.apache.commons.lang3.tuple.Pair;

public class ItemServantBell
extends Item {
    private static final String UUID_TAG = "ServantBellUuid";
    private static final String TIP_TAG = "ServantBellTip";
    private static final String SHOW_TAG = "ServantBellShow";
    private static final String SHOW_DIMENSION_TAG = "Dimension";
    private static final String SHOW_POS_TAG = "Pos";
    private static final int MIN_USE_DURATION = 20;

    public ItemServantBell() {
        super(new Item.Properties().m_41487_(1));
    }

    public static void recordMaidInfo(ItemStack stack, UUID uuid, String tip) {
        if (stack.m_150930_((Item)InitItems.SERVANT_BELL.get())) {
            CompoundTag tag = stack.m_41784_();
            tag.m_128362_(UUID_TAG, uuid);
            tag.m_128359_(TIP_TAG, tip);
        }
    }

    @Nullable
    public static Pair<String, BlockPos> getMaidShow(ItemStack stack) {
        CompoundTag showTag;
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128425_(SHOW_TAG, 10) && (showTag = tag.m_128469_(SHOW_TAG)).m_128425_(SHOW_DIMENSION_TAG, 8) && showTag.m_128425_(SHOW_POS_TAG, 10)) {
            String dimension = showTag.m_128461_(SHOW_DIMENSION_TAG);
            BlockPos blockPos = NbtUtils.m_129239_((CompoundTag)showTag.m_128469_(SHOW_POS_TAG));
            return Pair.of((Object)dimension, (Object)blockPos);
        }
        return null;
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity target, InteractionHand usedHand) {
        EntityMaid maid;
        if (usedHand == InteractionHand.MAIN_HAND && target instanceof EntityMaid && (maid = (EntityMaid)target).m_21830_((LivingEntity)player)) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.openServantBellSetScreen(maid));
            return InteractionResult.SUCCESS;
        }
        return super.m_6880_(stack, player, target, usedHand);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        UUID searchUuid = this.getMaidUuid(stack);
        if (searchUuid != null) {
            playerIn.m_6672_(handIn);
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        if (!worldIn.f_46443_) {
            playerIn.m_213846_((Component)Component.m_237115_((String)"message.touhou_little_maid.servant_bell.data_is_empty"));
        }
        return super.m_7203_(worldIn, playerIn, handIn);
    }

    public void m_5551_(ItemStack stack, Level worldIn, LivingEntity entityLiving, int timeLeft) {
        Player player;
        block8: {
            block7: {
                if (!(entityLiving instanceof Player)) break block7;
                player = (Player)entityLiving;
                if (timeLeft >= 20) break block8;
            }
            return;
        }
        UUID searchUuid = this.getMaidUuid(stack);
        if (searchUuid == null) {
            player.m_213846_((Component)Component.m_237115_((String)"message.touhou_little_maid.servant_bell.data_is_empty"));
            return;
        }
        if (worldIn instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)worldIn;
            List maids = serverLevel.m_143280_(EntityMaid.TYPE, maid -> this.checkMaidUuid(player, (EntityMaid)maid, searchUuid));
            if (maids.isEmpty()) {
                this.showMaidInfo(worldIn, player, stack, searchUuid);
            } else {
                stack.m_41784_().m_128473_(SHOW_TAG);
                this.teleportMaid(player, maids);
            }
        }
        worldIn.m_5594_(null, player.m_20183_(), SoundEvents.f_11699_, SoundSource.BLOCKS, 2.0f, 1.0f);
        player.m_36335_().m_41524_((Item)this, 20);
    }

    @Nullable
    private UUID getMaidUuid(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128403_(UUID_TAG)) {
            return tag.m_128342_(UUID_TAG);
        }
        return null;
    }

    private void teleportMaid(Player player, List<? extends EntityMaid> maids) {
        maids.forEach(maid -> {
            maid.setHomeModeEnable(false);
            maid.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 200, 1, true, false));
            maid.m_6021_(player.m_20185_() + (double)player.m_217043_().m_188503_(3) - 1.0, player.m_20186_(), player.m_20189_() + (double)player.m_217043_().m_188503_(3) - 1.0);
        });
    }

    private void showMaidInfo(Level worldIn, Player player, ItemStack stack, UUID searchUuid) {
        MaidWorldData data = MaidWorldData.get(worldIn);
        if (data == null) {
            player.m_213846_((Component)Component.m_237115_((String)"message.touhou_little_maid.servant_bell.no_result"));
            return;
        }
        List<MaidInfo> infos = data.getPlayerMaidInfos(player);
        if (infos == null || infos.isEmpty()) {
            player.m_213846_((Component)Component.m_237115_((String)"message.touhou_little_maid.servant_bell.no_result"));
            return;
        }
        infos.stream().filter(info -> info.getEntityId().equals(searchUuid)).findFirst().ifPresentOrElse(info -> {
            String dimension = info.getDimension();
            String playerDimension = player.f_19853_.m_46472_().m_135782_().toString();
            CompoundTag showTag = stack.m_41698_(SHOW_TAG);
            showTag.m_128359_(SHOW_DIMENSION_TAG, dimension);
            showTag.m_128365_(SHOW_POS_TAG, (Tag)NbtUtils.m_129224_((BlockPos)info.getChunkPos()));
            if (dimension.equals(playerDimension)) {
                player.m_213846_((Component)Component.m_237115_((String)"message.touhou_little_maid.servant_bell.show_pos"));
            } else {
                player.m_213846_((Component)Component.m_237110_((String)"message.touhou_little_maid.servant_bell.not_same_dimension", (Object[])new Object[]{dimension}));
            }
        }, () -> player.m_213846_((Component)Component.m_237115_((String)"message.touhou_little_maid.servant_bell.no_result")));
    }

    private boolean checkMaidUuid(Player player, EntityMaid maid, UUID searchUuid) {
        return maid.m_21830_((LivingEntity)player) && maid.m_20148_().equals(searchUuid);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void openServantBellSetScreen(EntityMaid maid) {
        if (maid.f_19853_.f_46443_) {
            Minecraft.m_91087_().m_91152_((Screen)new ServantBellSetScreen(maid));
        }
    }

    public int m_8105_(ItemStack stack) {
        return 100;
    }

    public UseAnim m_6164_(ItemStack pStack) {
        return UseAnim.BLOCK;
    }

    public Component m_7626_(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128425_(TIP_TAG, 8)) {
            String tip = tag.m_128461_(TIP_TAG);
            return Component.m_237113_((String)tip).m_130940_(ChatFormatting.GOLD).m_130940_(ChatFormatting.UNDERLINE);
        }
        return super.m_7626_(stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        UUID uuid = this.getMaidUuid(stack);
        if (uuid != null) {
            tooltip.add((Component)Component.m_237110_((String)"tooltips.touhou_little_maid.servant_bell.uuid", (Object[])new Object[]{uuid.toString()}).m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)CommonComponents.m_264333_());
        }
        tooltip.add((Component)Component.m_237115_((String)"tooltips.touhou_little_maid.servant_bell.desc.1").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237115_((String)"tooltips.touhou_little_maid.servant_bell.desc.2").m_130940_(ChatFormatting.GRAY));
    }
}

