/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.network.message.FoxScrollMessage;
import com.github.tartaricacid.touhoulittlemaid.world.data.MaidInfo;
import com.github.tartaricacid.touhoulittlemaid.world.data.MaidWorldData;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.Pair;

public class ItemFoxScroll
extends Item {
    private static final String TRACK_INFO = "TrackInfo";

    public ItemFoxScroll() {
        super(new Item.Properties().m_41487_(1));
    }

    public static boolean hasTrackInfo(ItemStack scroll) {
        return scroll.m_41782_() && !Objects.requireNonNull(scroll.m_41783_()).m_128469_(TRACK_INFO).m_128456_();
    }

    public static void setTrackInfo(ItemStack scroll, String dimension, BlockPos pos) {
        CompoundTag tag = scroll.m_41698_(TRACK_INFO);
        tag.m_128359_("Dimension", dimension);
        tag.m_128365_("Position", (Tag)NbtUtils.m_129224_((BlockPos)pos));
    }

    @Nullable
    public static Pair<String, BlockPos> getTrackInfo(ItemStack scroll) {
        if (ItemFoxScroll.hasTrackInfo(scroll)) {
            CompoundTag tag = Objects.requireNonNull(scroll.m_41783_()).m_128469_(TRACK_INFO);
            String dimension = tag.m_128461_("Dimension");
            BlockPos position = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("Position"));
            return Pair.of((Object)dimension, (Object)position);
        }
        return null;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (!level.f_46443_ && hand == InteractionHand.MAIN_HAND) {
            ItemStack item = player.m_21205_();
            MaidWorldData maidWorldData = MaidWorldData.get(level);
            if (maidWorldData == null) {
                return super.m_7203_(level, player, hand);
            }
            HashMap data = Maps.newHashMap();
            List<MaidInfo> maidInfos = null;
            if (item.m_41720_() == InitItems.RED_FOX_SCROLL.get()) {
                maidInfos = maidWorldData.getPlayerMaidInfos(player);
            } else if (item.m_41720_() == InitItems.WHITE_FOX_SCROLL.get()) {
                maidInfos = maidWorldData.getPlayerMaidTombstones(player);
            }
            if (maidInfos == null) {
                maidInfos = Collections.emptyList();
            }
            maidInfos.forEach(info -> {
                List scrollData = data.computeIfAbsent(info.getDimension(), dim -> Lists.newArrayList());
                scrollData.add(new FoxScrollMessage.FoxScrollData(info.getChunkPos(), info.getName(), info.getTimestamp()));
            });
            NetworkHandler.sendToClientPlayer(new FoxScrollMessage(data), player);
            return InteractionResultHolder.m_19090_((Object)item);
        }
        return super.m_7203_(level, player, hand);
    }

    public void m_7373_(ItemStack stack, @Nullable Level pLevel, List<Component> components, TooltipFlag pIsAdvanced) {
        Pair<String, BlockPos> info = ItemFoxScroll.getTrackInfo(stack);
        if (info != null) {
            components.add((Component)Component.m_237110_((String)"tooltips.touhou_little_maid.fox_scroll.dimension", (Object[])new Object[]{info.getLeft()}).m_130940_(ChatFormatting.GOLD));
            components.add((Component)Component.m_237110_((String)"tooltips.touhou_little_maid.fox_scroll.position", (Object[])new Object[]{((BlockPos)info.getRight()).m_123344_()}).m_130940_(ChatFormatting.RED));
            components.add((Component)Component.m_237119_());
        }
        if (stack.m_41720_() == InitItems.RED_FOX_SCROLL.get()) {
            components.add((Component)Component.m_237115_((String)"tooltips.touhou_little_maid.fox_scroll.red").m_130940_(ChatFormatting.GRAY));
        } else if (stack.m_41720_() == InitItems.WHITE_FOX_SCROLL.get()) {
            components.add((Component)Component.m_237115_((String)"tooltips.touhou_little_maid.fox_scroll.white").m_130940_(ChatFormatting.GRAY));
        }
        super.m_7373_(stack, pLevel, components, pIsAdvanced);
    }
}

