/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.inventory.container.backpack;

import com.github.tartaricacid.touhoulittlemaid.entity.backpack.data.TankBackpackData;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.MaidMainContainer;
import com.mojang.datafixers.util.Pair;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;

public class TankBackpackContainer
extends MaidMainContainer {
    public static final MenuType<TankBackpackContainer> TYPE = IForgeMenuType.create((windowId, inv, data) -> new TankBackpackContainer(windowId, inv, data.readInt()));
    private static final ResourceLocation INPUT_SLOT = new ResourceLocation("touhou_little_maid", "slot/tank_input_slot");
    private static final ResourceLocation OUTPUT_SLOT = new ResourceLocation("touhou_little_maid", "slot/tank_output_slot");
    private final ContainerData data;

    public TankBackpackContainer(int id, Inventory inventory, int entityId) {
        super(TYPE, id, inventory, entityId);
        TankBackpackData tankData = this.getMaid().getBackpackData() instanceof TankBackpackData ? (TankBackpackData)this.getMaid().getBackpackData() : new TankBackpackData(this.getMaid());
        this.data = tankData.getDataAccess();
        this.m_38897_(new TankInputSlot((Container)tankData, 0, 161, 101));
        this.m_38897_(new TankOutputSlot((Container)tankData, 1, 161, 140));
        this.m_38884_(this.data);
    }

    @Override
    protected void addBackpackInv(Inventory inventory) {
        int i;
        ItemStackHandler itemHandler = this.maid.getMaidInv();
        for (i = 0; i < 6; ++i) {
            this.m_38897_((Slot)new SlotItemHandler((IItemHandler)itemHandler, 6 + i, 143 + 18 * i, 57));
        }
        for (i = 0; i < 6; ++i) {
            this.m_38897_((Slot)new SlotItemHandler((IItemHandler)itemHandler, 12 + i, 143 + 18 * i, 75));
        }
    }

    public int getFluidCount() {
        return this.data.m_6413_(0);
    }

    public static class TankInputSlot
    extends Slot {
        public TankInputSlot(Container pContainer, int pSlot, int pX, int pY) {
            super(pContainer, pSlot, pX, pY);
        }

        public boolean m_5857_(ItemStack stack) {
            return FluidUtil.getFluidHandler((ItemStack)stack).isPresent();
        }

        @OnlyIn(value=Dist.CLIENT)
        public Pair<ResourceLocation, ResourceLocation> m_7543_() {
            return Pair.of((Object)InventoryMenu.f_39692_, (Object)INPUT_SLOT);
        }
    }

    public static class TankOutputSlot
    extends Slot {
        public TankOutputSlot(Container pContainer, int pSlot, int pX, int pY) {
            super(pContainer, pSlot, pX, pY);
        }

        public boolean m_5857_(ItemStack stack) {
            return FluidUtil.getFluidHandler((ItemStack)stack).isPresent();
        }

        @OnlyIn(value=Dist.CLIENT)
        public Pair<ResourceLocation, ResourceLocation> m_7543_() {
            return Pair.of((Object)InventoryMenu.f_39692_, (Object)OUTPUT_SLOT);
        }
    }
}

