/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.geckolib3.geo;

import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.util.Color;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.animated.AnimatedGeoBone;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.animated.AnimatedGeoModel;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.render.built.GeoCube;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.render.built.GeoQuad;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.render.built.GeoVertex;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.util.EModelRenderCycle;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.util.IRenderCycle;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.util.RenderUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public interface IGeoRenderer<T> {
    public MultiBufferSource getCurrentRTB();

    default public void setCurrentRTB(MultiBufferSource bufferSource) {
    }

    public ResourceLocation getTextureLocation(T var1);

    default public void render(AnimatedGeoModel model, T animatable, float partialTick, RenderType type, PoseStack poseStack, @Nullable MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.setCurrentRTB(bufferSource);
        this.renderEarly(animatable, poseStack, partialTick, bufferSource, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        if (bufferSource != null) {
            buffer = bufferSource.m_6299_(type);
        }
        this.renderLate(animatable, poseStack, partialTick, bufferSource, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        for (AnimatedGeoBone group : model.topLevelBones()) {
            this.renderRecursively(group, poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        }
        this.setCurrentModelRenderCycle(EModelRenderCycle.REPEATED);
    }

    default public void renderRecursively(AnimatedGeoBone bone, PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        int cubePackedLight = bone.geoBone().glow() ? LightTexture.m_109885_((int)15, (int)15) : packedLight;
        if ((bone.getScaleX() == 0.0f ? 0 : 1) + (bone.getScaleY() == 0.0f ? 0 : 1) + (bone.getScaleZ() == 0.0f ? 0 : 1) < 2) {
            return;
        }
        poseStack.m_85836_();
        RenderUtils.prepMatrixForBone(poseStack, bone);
        this.renderCubesOfBone(bone, poseStack, buffer, cubePackedLight, packedOverlay, red, green, blue, alpha);
        this.renderChildBones(bone, poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        poseStack.m_85849_();
    }

    default public void renderCubesOfBone(AnimatedGeoBone bone, PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (bone.isHidden()) {
            return;
        }
        if (!bone.cubesAreHidden()) {
            for (GeoCube cube : bone.geoBone().cubes()) {
                this.renderCube(cube, poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            }
        }
    }

    default public void renderChildBones(AnimatedGeoBone bone, PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (bone.childBonesAreHiddenToo()) {
            return;
        }
        for (AnimatedGeoBone childBone : bone.children()) {
            this.renderRecursively(childBone, poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        }
    }

    default public void renderCube(GeoCube cube, PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        Matrix3f normalisedPoseState = poseStack.m_85850_().m_252943_();
        Matrix4f poseState = poseStack.m_85850_().m_252922_();
        for (GeoQuad quad : cube.quads) {
            if (quad == null) continue;
            Vector3f normal = normalisedPoseState.transform(new Vector3f((Vector3fc)quad.normal));
            if ((cube.size.y() == 0.0f || cube.size.z() == 0.0f) && normal.x() < 0.0f) {
                normal.mul(-1.0f, 1.0f, 1.0f);
            }
            if ((cube.size.x() == 0.0f || cube.size.z() == 0.0f) && normal.y() < 0.0f) {
                normal.mul(1.0f, -1.0f, 1.0f);
            }
            if ((cube.size.x() == 0.0f || cube.size.y() == 0.0f) && normal.z() < 0.0f) {
                normal.mul(1.0f, 1.0f, -1.0f);
            }
            this.createVerticesOfQuad(quad, poseState, normal, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        }
    }

    default public void createVerticesOfQuad(GeoQuad quad, Matrix4f poseState, Vector3f normal, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        Vector3f position = new Vector3f();
        for (GeoVertex vertex : quad.vertices) {
            vertex.position.mulPosition((Matrix4fc)poseState, position);
            buffer.m_5954_(position.x(), position.y(), position.z(), red, green, blue, alpha, vertex.textureU, vertex.textureV, packedOverlay, packedLight, normal.x(), normal.y(), normal.z());
        }
    }

    default public void renderEarly(T animatable, PoseStack poseStack, float partialTick, @Nullable MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, int packedLight, int packedOverlayIn, float red, float green, float blue, float alpha) {
        if (this.getCurrentModelRenderCycle() == EModelRenderCycle.INITIAL) {
            float width = this.getWidthScale(animatable);
            float height = this.getHeightScale(animatable);
            poseStack.m_85841_(width, height, width);
        }
    }

    default public void renderLate(T animatable, PoseStack poseStack, float partialTick, MultiBufferSource bufferSource, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
    }

    default public RenderType getRenderType(T animatable, float partialTick, PoseStack poseStack, @Nullable MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, int packedLight, ResourceLocation texture) {
        return RenderType.m_110458_((ResourceLocation)texture);
    }

    default public Color getRenderColor(T animatable, float partialTick, PoseStack poseStack, @Nullable MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, int packedLight) {
        return Color.WHITE;
    }

    @Nonnull
    default public IRenderCycle getCurrentModelRenderCycle() {
        return EModelRenderCycle.INITIAL;
    }

    default public void setCurrentModelRenderCycle(IRenderCycle cycle) {
    }

    default public float getWidthScale(T animatable) {
        return 1.0f;
    }

    default public float getHeightScale(T entity) {
        return 1.0f;
    }
}

