/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.navigation;

import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;

public class MaidNodeEvaluator
extends WalkNodeEvaluator {
    public BlockPathTypes m_8086_(BlockGetter level, int pX, int pY, int pZ) {
        return MaidNodeEvaluator.getMaidBlockPathTypeStatic(level, new BlockPos.MutableBlockPos(pX, pY, pZ));
    }

    private static BlockPathTypes getMaidBlockPathTypeStatic(BlockGetter level, BlockPos.MutableBlockPos pos) {
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        BlockPathTypes type = MaidNodeEvaluator.getMaidBlockPathTypeRaw(level, (BlockPos)pos);
        if (type == BlockPathTypes.OPEN && y >= level.m_141937_() + 1) {
            BlockPathTypes typeBelow = MaidNodeEvaluator.getMaidBlockPathTypeRaw(level, (BlockPos)pos.m_122178_(x, y - 1, z));
            BlockPathTypes blockPathTypes = type = typeBelow != BlockPathTypes.WALKABLE && typeBelow != BlockPathTypes.OPEN && typeBelow != BlockPathTypes.WATER && typeBelow != BlockPathTypes.LAVA ? BlockPathTypes.WALKABLE : BlockPathTypes.OPEN;
            if (typeBelow == BlockPathTypes.DAMAGE_FIRE) {
                type = BlockPathTypes.DAMAGE_FIRE;
            }
            if (typeBelow == BlockPathTypes.DAMAGE_OTHER) {
                type = BlockPathTypes.DAMAGE_OTHER;
            }
            if (typeBelow == BlockPathTypes.STICKY_HONEY) {
                type = BlockPathTypes.STICKY_HONEY;
            }
            if (typeBelow == BlockPathTypes.POWDER_SNOW) {
                type = BlockPathTypes.DANGER_POWDER_SNOW;
            }
            if (typeBelow == BlockPathTypes.DAMAGE_CAUTIOUS) {
                type = BlockPathTypes.DAMAGE_CAUTIOUS;
            }
        }
        if (type == BlockPathTypes.WALKABLE) {
            type = MaidNodeEvaluator.m_77607_((BlockGetter)level, (BlockPos.MutableBlockPos)pos.m_122178_(x, y, z), (BlockPathTypes)type);
        }
        return type;
    }

    private static BlockPathTypes getMaidBlockPathTypeRaw(BlockGetter level, BlockPos pos) {
        BlockState blockState = level.m_8055_(pos);
        BlockPathTypes pathType = blockState.getBlockPathType(level, pos, null);
        if (pathType != null) {
            return pathType;
        }
        if (blockState.m_60795_()) {
            return BlockPathTypes.OPEN;
        }
        if (blockState.m_60734_() instanceof FenceGateBlock) {
            return (Boolean)blockState.m_61143_((Property)FenceGateBlock.f_53341_) != false ? BlockPathTypes.DOOR_OPEN : BlockPathTypes.DOOR_WOOD_CLOSED;
        }
        return WalkNodeEvaluator.m_77643_((BlockGetter)level, (BlockPos)pos);
    }
}

