/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.geckolayer;

import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.GeckoEntityMaidRenderer;
import com.github.tartaricacid.touhoulittlemaid.compat.carryon.RenderFixer;
import com.github.tartaricacid.touhoulittlemaid.compat.slashblade.SlashBladeCompat;
import com.github.tartaricacid.touhoulittlemaid.compat.slashblade.SlashBladeRender;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.GeoLayerRenderer;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.animated.AnimatedGeoModel;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.util.RenderUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class GeckoLayerMaidHeld<T extends Mob>
extends GeoLayerRenderer<T, GeckoEntityMaidRenderer<T>> {
    private final ItemInHandRenderer itemInHandRenderer;

    public GeckoLayerMaidHeld(GeckoEntityMaidRenderer<T> entityRendererIn, ItemInHandRenderer itemInHandRenderer) {
        super(entityRendererIn);
        this.itemInHandRenderer = itemInHandRenderer;
    }

    @Override
    public void render(PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn, T entityLivingBaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack offhandItem = entityLivingBaseIn.m_21206_();
        ItemStack mainHandItem = entityLivingBaseIn.m_21205_();
        AnimatedGeoModel geoModel = ((GeckoEntityMaidRenderer)this.entityRenderer).getAnimatableEntity(entityLivingBaseIn).getCurrentModel();
        if (geoModel == null) {
            return;
        }
        if (!offhandItem.m_41619_() || !mainHandItem.m_41619_()) {
            poseStack.m_85836_();
            if (!geoModel.rightHandBones().isEmpty() && !RenderFixer.isCarryOnRender(mainHandItem, bufferIn)) {
                if (SlashBladeCompat.isSlashBladeItem(mainHandItem)) {
                    SlashBladeRender.renderMaidMainhandSlashBlade(entityLivingBaseIn, geoModel, poseStack, bufferIn, packedLightIn, mainHandItem, partialTicks);
                } else {
                    this.renderArmWithItem(entityLivingBaseIn, mainHandItem, ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, HumanoidArm.RIGHT, poseStack, bufferIn, packedLightIn);
                }
            }
            if (!geoModel.leftHandBones().isEmpty() && !RenderFixer.isCarryOnRender(offhandItem, bufferIn)) {
                if (SlashBladeCompat.isSlashBladeItem(offhandItem)) {
                    SlashBladeRender.renderMaidOffhandSlashBlade(geoModel, poseStack, bufferIn, packedLightIn, offhandItem);
                } else {
                    this.renderArmWithItem(entityLivingBaseIn, offhandItem, ItemDisplayContext.THIRD_PERSON_LEFT_HAND, HumanoidArm.LEFT, poseStack, bufferIn, packedLightIn);
                }
            }
            poseStack.m_85849_();
        }
    }

    protected void renderArmWithItem(T livingEntity, ItemStack itemStack, ItemDisplayContext displayContext, HumanoidArm arm, PoseStack poseStack, MultiBufferSource bufferSource, int light) {
        AnimatedGeoModel geoModel = ((GeckoEntityMaidRenderer)this.entityRenderer).getAnimatableEntity(livingEntity).getCurrentModel();
        if (!itemStack.m_41619_() && geoModel != null) {
            poseStack.m_85836_();
            this.translateToHand(arm, poseStack, geoModel);
            poseStack.m_85837_(0.0, -0.0625, -0.1);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
            boolean isLeftHand = arm == HumanoidArm.LEFT;
            this.itemInHandRenderer.m_269530_(livingEntity, itemStack, displayContext, isLeftHand, poseStack, bufferSource, light);
            poseStack.m_85849_();
        }
    }

    protected void translateToHand(HumanoidArm arm, PoseStack poseStack, AnimatedGeoModel geoModel) {
        if (arm == HumanoidArm.LEFT) {
            RenderUtils.prepMatrixForLocator(poseStack, geoModel.leftHandBones());
        } else {
            RenderUtils.prepMatrixForLocator(poseStack, geoModel.rightHandBones());
        }
    }
}

