/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.block;

import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.item.ItemMaidBeacon;
import com.github.tartaricacid.touhoulittlemaid.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.network.message.OpenBeaconGuiMessage;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityMaidBeacon;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockMaidBeacon
extends BaseEntityBlock {
    public static final EnumProperty<Position> POSITION = EnumProperty.m_61587_((String)"position", Position.class);
    private static final VoxelShape UP_AABB = Block.m_49796_((double)3.0, (double)1.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private static final VoxelShape DOWN_AABB = Block.m_49796_((double)6.5, (double)0.0, (double)6.5, (double)9.5, (double)26.0, (double)9.5);

    public BlockMaidBeacon() {
        super(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56736_).m_60913_(2.0f, 2.0f).m_60955_().m_60953_(s -> s.m_61143_(POSITION) == Position.DOWN ? 0 : 15));
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(POSITION, (Comparable)((Object)Position.DOWN)));
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        if (state.m_61143_(POSITION) != Position.DOWN) {
            return new TileEntityMaidBeacon(pos, state);
        }
        return null;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return level.m_5776_() ? null : BlockMaidBeacon.m_152132_(type, TileEntityMaidBeacon.TYPE, TileEntityMaidBeacon::serverTick);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (worldIn.m_7702_(pos) instanceof TileEntityMaidBeacon) {
            if (!worldIn.f_46443_) {
                NetworkHandler.sendToClientPlayer(new OpenBeaconGuiMessage(pos), player);
            }
            return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
        }
        return super.m_6227_(state, worldIn, pos, player, handIn, hit);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Position position = (Position)((Object)state.m_61143_(POSITION));
        return position == Position.DOWN ? DOWN_AABB : UP_AABB;
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing.m_122434_() == Direction.Axis.Y) {
            Position position = (Position)((Object)stateIn.m_61143_(POSITION));
            if (!(position != Position.DOWN || facing != Direction.UP || facingState.m_60713_((Block)this) && facingState.m_61143_(POSITION) != Position.DOWN)) {
                return Blocks.f_50016_.m_49966_();
            }
            if (!(position == Position.DOWN || facing != Direction.DOWN || facingState.m_60713_((Block)this) && facingState.m_61143_(POSITION) != Position.UP_W_E && facingState.m_61143_(POSITION) != Position.UP_N_S)) {
                return Blocks.f_50016_.m_49966_();
            }
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public void m_5707_(Level worldIn, BlockPos pos, BlockState state, Player player) {
        BlockPos belowPos;
        BlockState belowState;
        Position position;
        if (!worldIn.f_46443_ && player.m_7500_() && (position = (Position)((Object)state.m_61143_(POSITION))) != Position.DOWN && (belowState = worldIn.m_8055_(belowPos = pos.m_7495_())).m_60713_((Block)this) && belowState.m_61143_(POSITION) == Position.DOWN) {
            worldIn.m_7731_(belowPos, Blocks.f_50016_.m_49966_(), 35);
            worldIn.m_5898_(player, 2001, belowPos, Block.m_49956_((BlockState)belowState));
        }
        super.m_5707_(worldIn, pos, state, player);
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity te = worldIn.m_7702_(pos);
        if (te instanceof TileEntityMaidBeacon) {
            BlockMaidBeacon.m_49840_((Level)worldIn, (BlockPos)pos, (ItemStack)ItemMaidBeacon.tileEntityToItemStack((TileEntityMaidBeacon)te));
        }
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.BLOCK;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)InitItems.MAID_BEACON.get());
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos blockpos = context.m_8083_();
        Level world = context.m_43725_();
        int maxHeight = world.m_151558_() - 1;
        if (blockpos.m_123342_() < maxHeight && world.m_8055_(blockpos.m_7494_()).m_60629_(context)) {
            return super.m_5573_(context);
        }
        return null;
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        Direction facing = this.getHorizontalDirection(placer);
        BlockState stateUp = facing == Direction.SOUTH || facing == Direction.NORTH ? (BlockState)this.m_49966_().m_61124_(POSITION, (Comparable)((Object)Position.UP_N_S)) : (BlockState)this.m_49966_().m_61124_(POSITION, (Comparable)((Object)Position.UP_W_E));
        worldIn.m_7731_(pos.m_7494_(), stateUp, 3);
        BlockEntity te = worldIn.m_7702_(pos.m_7494_());
        if (te instanceof TileEntityMaidBeacon) {
            TileEntityMaidBeacon tileEntityMaidBeacon = (TileEntityMaidBeacon)te;
            ItemMaidBeacon.itemStackToTileEntity(stack, tileEntityMaidBeacon);
            tileEntityMaidBeacon.refresh();
        }
    }

    public BlockState rotate(BlockState state, LevelAccessor world, BlockPos pos, Rotation direction) {
        switch (direction) {
            default: {
                return state;
            }
            case CLOCKWISE_90: 
            case COUNTERCLOCKWISE_90: 
        }
        if (state.m_61143_(POSITION) == Position.UP_N_S) {
            return (BlockState)state.m_61124_(POSITION, (Comparable)((Object)Position.UP_W_E));
        }
        if (state.m_61143_(POSITION) == Position.UP_W_E) {
            return (BlockState)state.m_61124_(POSITION, (Comparable)((Object)Position.UP_N_S));
        }
        return state;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{POSITION});
    }

    private Direction getHorizontalDirection(@Nullable LivingEntity placer) {
        return placer == null ? Direction.NORTH : placer.m_6350_();
    }

    public static enum Position implements StringRepresentable
    {
        UP_N_S,
        UP_W_E,
        DOWN;


        public String m_7912_() {
            return this.name().toLowerCase(Locale.US);
        }

        public String toString() {
            return this.m_7912_();
        }
    }
}

