/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.forge.platform;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.util.Either;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import mezz.jei.common.platform.IPlatformRenderHelper;
import mezz.jei.library.util.ResourceLocationUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.client.extensions.common.IClientMobEffectExtensions;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class RenderHelper
implements IPlatformRenderHelper {
    @Override
    public Font getFontRenderer(Minecraft minecraft, ItemStack itemStack) {
        IClientItemExtensions renderProperties = IClientItemExtensions.of((ItemStack)itemStack);
        Font fontRenderer = renderProperties.getFont(itemStack, IClientItemExtensions.FontContext.TOOLTIP);
        if (fontRenderer != null) {
            return fontRenderer;
        }
        return minecraft.f_91062_;
    }

    @Override
    public boolean shouldRender(MobEffectInstance potionEffect) {
        IClientMobEffectExtensions effectRenderer = IClientMobEffectExtensions.of((MobEffectInstance)potionEffect);
        return effectRenderer.isVisibleInInventory(potionEffect);
    }

    @Override
    public TextureAtlasSprite getParticleIcon(BakedModel bakedModel) {
        return bakedModel.getParticleIcon(ModelData.EMPTY);
    }

    @Override
    public ItemColors getItemColors() {
        return Minecraft.m_91087_().getItemColors();
    }

    @Override
    public Optional<NativeImage> getMainImage(TextureAtlasSprite sprite) {
        SpriteContents contents = sprite.m_245424_();
        NativeImage[] frames = contents.f_243731_;
        if (frames.length == 0) {
            return Optional.empty();
        }
        NativeImage frame = frames[0];
        return Optional.ofNullable(frame);
    }

    @Override
    public void renderTooltip(GuiGraphics guiGraphics, List<Either<FormattedText, TooltipComponent>> elements, int x, int y, Font font, ItemStack stack) {
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen == null) {
            return;
        }
        guiGraphics.tooltipStack = stack;
        List<ClientTooltipComponent> components = RenderHelper.gatherTooltipComponents(stack, elements, x, screen.f_96543_, screen.f_96544_, font);
        guiGraphics.m_280497_(font, components, x, y, DefaultTooltipPositioner.f_262752_);
        guiGraphics.tooltipStack = ItemStack.f_41583_;
    }

    private static List<ClientTooltipComponent> gatherTooltipComponents(ItemStack stack, List<Either<FormattedText, TooltipComponent>> elements, int mouseX, int screenWidth, int screenHeight, Font fallbackFont) {
        Font font = ForgeHooksClient.getTooltipFont((ItemStack)stack, (Font)fallbackFont);
        RenderTooltipEvent.GatherComponents event = new RenderTooltipEvent.GatherComponents(stack, screenWidth, screenHeight, elements, -1);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return List.of();
        }
        int tooltipTextWidth = event.getTooltipElements().stream().mapToInt(either -> {
            Objects.requireNonNull(font);
            return (Integer)either.map(arg_0 -> ((Font)font).m_92852_(arg_0), component -> 0);
        }).max().orElse(0);
        boolean needsWrap = false;
        int tooltipX = mouseX + 12;
        if (tooltipX + tooltipTextWidth + 4 > screenWidth && (tooltipX = mouseX - 16 - tooltipTextWidth) < 4) {
            tooltipTextWidth = mouseX > screenWidth / 2 ? mouseX - 12 - 8 : screenWidth - 16 - mouseX;
            needsWrap = true;
        }
        if (event.getMaxWidth() > 0 && tooltipTextWidth > event.getMaxWidth()) {
            tooltipTextWidth = event.getMaxWidth();
            needsWrap = true;
        }
        int tooltipTextWidthF = tooltipTextWidth;
        return needsWrap ? event.getTooltipElements().stream().flatMap(either -> (Stream)either.map(text -> RenderHelper.splitLine(text, font, tooltipTextWidthF), component -> Stream.of(ClientTooltipComponent.m_169950_((TooltipComponent)component)))).toList() : event.getTooltipElements().stream().map(either -> (ClientTooltipComponent)either.map(text -> ClientTooltipComponent.m_169948_((FormattedCharSequence)(text instanceof Component ? ((Component)text).m_7532_() : Language.m_128107_().m_5536_(text))), ClientTooltipComponent::m_169950_)).toList();
    }

    private static Stream<ClientTooltipComponent> splitLine(FormattedText text, Font font, int maxWidth) {
        Component component;
        if (text instanceof Component && (component = (Component)text).getString().isEmpty()) {
            return Stream.of(component.m_7532_()).map(ClientTooltipComponent::m_169948_);
        }
        return font.m_92923_(text, maxWidth).stream().map(ClientTooltipComponent::m_169948_);
    }

    @Override
    public Component getName(TagKey<?> tagKey) {
        String tagTranslationKey = RenderHelper.getTagTranslationKey(tagKey);
        return Component.m_264568_((String)tagTranslationKey, (String)("#" + tagKey.f_203868_()));
    }

    private static String getTagTranslationKey(TagKey<?> tagKey) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("tag.");
        ResourceLocation registryIdentifier = tagKey.f_203867_().m_135782_();
        ResourceLocation tagIdentifier = tagKey.f_203868_();
        if (!registryIdentifier.m_135827_().equals("minecraft")) {
            stringBuilder.append(registryIdentifier.m_135827_()).append(".");
        }
        String registryId = ResourceLocationUtil.sanitizePath(registryIdentifier.m_135815_());
        String tagId = ResourceLocationUtil.sanitizePath(tagIdentifier.m_135815_());
        stringBuilder.append(registryId).append(".").append(tagIdentifier.m_135827_()).append(".").append(tagId);
        return stringBuilder.toString();
    }
}

