/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.resource;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.tacz.guns.crafting.GunSmithTableRecipe;
import com.tacz.guns.resource.pojo.data.attachment.AttachmentData;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;

public enum CommonAssetManager {
    INSTANCE;

    private final Map<ResourceLocation, GunData> gunData = Maps.newHashMap();
    private final Map<ResourceLocation, AttachmentData> attachmentData = Maps.newHashMap();
    private final Map<ResourceLocation, GunSmithTableRecipe> gunSmithTableRecipes = Maps.newHashMap();
    private final Map<ResourceLocation, Set<String>> attachmentTags = Maps.newHashMap();
    private final Map<ResourceLocation, Set<String>> allowAttachmentTags = Maps.newHashMap();

    public void putGunData(ResourceLocation registryName, GunData data) {
        this.gunData.put(registryName, data);
    }

    public GunData getGunData(ResourceLocation registryName) {
        return this.gunData.get(registryName);
    }

    public void putAttachmentData(ResourceLocation registryName, AttachmentData data) {
        this.attachmentData.put(registryName, data);
    }

    public AttachmentData getAttachmentData(ResourceLocation registryName) {
        return this.attachmentData.get(registryName);
    }

    public void putRecipe(ResourceLocation registryName, GunSmithTableRecipe recipe) {
        this.gunSmithTableRecipes.put(registryName, recipe);
    }

    public Optional<GunSmithTableRecipe> getRecipe(ResourceLocation recipeId) {
        return Optional.ofNullable(this.gunSmithTableRecipes.get(recipeId));
    }

    public Map<ResourceLocation, GunSmithTableRecipe> getAllRecipes() {
        return this.gunSmithTableRecipes;
    }

    public void putAttachmentTags(ResourceLocation registryName, List<String> tags) {
        this.attachmentTags.computeIfAbsent(registryName, id -> Sets.newHashSet()).addAll(tags);
    }

    public Set<String> getAttachmentTags(ResourceLocation registryName) {
        return this.attachmentTags.get(registryName);
    }

    public void putAllowAttachmentTags(ResourceLocation registryName, List<String> tags) {
        this.allowAttachmentTags.computeIfAbsent(registryName, id -> Sets.newHashSet()).addAll(tags);
    }

    public Set<String> getAllowAttachmentTags(ResourceLocation registryName) {
        return this.allowAttachmentTags.get(registryName);
    }

    public void clearAll() {
        this.gunData.clear();
        this.attachmentData.clear();
        this.attachmentTags.clear();
        this.allowAttachmentTags.clear();
    }

    public void clearRecipes() {
        this.gunSmithTableRecipes.clear();
    }
}

