/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.sound;

import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.IAttachment;
import com.tacz.guns.client.resource.index.ClientGunIndex;
import com.tacz.guns.client.sound.GunSoundInstance;
import com.tacz.guns.config.common.GunConfig;
import com.tacz.guns.init.ModSounds;
import com.tacz.guns.network.message.ServerMessageSound;
import com.tacz.guns.sound.SoundManager;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class SoundPlayManager {
    private static boolean DRY_SOUND_TRACK = true;
    private static GunSoundInstance tmpSoundInstance = null;

    public static GunSoundInstance playClientSound(Entity entity, @Nullable ResourceLocation name, float volume, float pitch, int distance) {
        Minecraft minecraft = Minecraft.m_91087_();
        GunSoundInstance instance = new GunSoundInstance((SoundEvent)ModSounds.GUN.get(), SoundSource.PLAYERS, volume, pitch, entity, distance, name);
        minecraft.m_91106_().m_120367_((SoundInstance)instance);
        return instance;
    }

    public static void stopPlayGunSound() {
        if (tmpSoundInstance != null) {
            tmpSoundInstance.setStop();
        }
    }

    public static void stopPlayGunSound(ClientGunIndex gunIndex, String animationName) {
        if (tmpSoundInstance != null && tmpSoundInstance.getRegistryName() != null && tmpSoundInstance.getRegistryName().equals((Object)gunIndex.getSounds(animationName))) {
            tmpSoundInstance.setStop();
        }
    }

    public static void playerRefitSound(ItemStack attachmentItem, LocalPlayer player, String soundName) {
        IAttachment iAttachment = IAttachment.getIAttachmentOrNull(attachmentItem);
        if (iAttachment == null) {
            return;
        }
        ResourceLocation attachmentId = iAttachment.getAttachmentId(attachmentItem);
        TimelessAPI.getClientAttachmentIndex(attachmentId).ifPresent(index -> {
            Map<String, ResourceLocation> sounds = index.getSounds();
            if (sounds.containsKey(soundName)) {
                ResourceLocation resourceLocation = sounds.get(soundName);
                SoundPlayManager.playClientSound((Entity)player, resourceLocation, 1.0f, 1.0f, (Integer)GunConfig.DEFAULT_GUN_OTHER_SOUND_DISTANCE.get());
            }
        });
    }

    public static void playShootSound(LivingEntity entity, ClientGunIndex gunIndex) {
        SoundPlayManager.playClientSound((Entity)entity, gunIndex.getSounds(SoundManager.SHOOT_SOUND), 0.8f, 0.9f + entity.m_217043_().m_188501_() * 0.125f, (Integer)GunConfig.DEFAULT_GUN_FIRE_SOUND_DISTANCE.get());
    }

    public static void playSilenceSound(LivingEntity entity, ClientGunIndex gunIndex) {
        SoundPlayManager.playClientSound((Entity)entity, gunIndex.getSounds(SoundManager.SILENCE_SOUND), 0.6f, 0.9f + entity.m_217043_().m_188501_() * 0.125f, (Integer)GunConfig.DEFAULT_GUN_OTHER_SOUND_DISTANCE.get());
    }

    public static void playDryFireSound(LivingEntity entity, ClientGunIndex gunIndex) {
        if (DRY_SOUND_TRACK) {
            SoundPlayManager.playClientSound((Entity)entity, gunIndex.getSounds(SoundManager.DRY_FIRE_SOUND), 1.0f, 0.9f + entity.m_217043_().m_188501_() * 0.125f, (Integer)GunConfig.DEFAULT_GUN_OTHER_SOUND_DISTANCE.get());
            DRY_SOUND_TRACK = false;
        }
    }

    public static void resetDryFireSound() {
        DRY_SOUND_TRACK = true;
    }

    public static void playReloadSound(LivingEntity entity, ClientGunIndex gunIndex, boolean noAmmo) {
        tmpSoundInstance = noAmmo ? SoundPlayManager.playClientSound((Entity)entity, gunIndex.getSounds(SoundManager.RELOAD_EMPTY_SOUND), 1.0f, 1.0f, (Integer)GunConfig.DEFAULT_GUN_OTHER_SOUND_DISTANCE.get()) : SoundPlayManager.playClientSound((Entity)entity, gunIndex.getSounds(SoundManager.RELOAD_TACTICAL_SOUND), 1.0f, 1.0f, (Integer)GunConfig.DEFAULT_GUN_OTHER_SOUND_DISTANCE.get());
    }

    public static void playInspectSound(LivingEntity entity, ClientGunIndex gunIndex, boolean noAmmo) {
        tmpSoundInstance = noAmmo ? SoundPlayManager.playClientSound((Entity)entity, gunIndex.getSounds(SoundManager.INSPECT_EMPTY_SOUND), 1.0f, 1.0f, (Integer)GunConfig.DEFAULT_GUN_OTHER_SOUND_DISTANCE.get()) : SoundPlayManager.playClientSound((Entity)entity, gunIndex.getSounds(SoundManager.INSPECT_SOUND), 1.0f, 1.0f, (Integer)GunConfig.DEFAULT_GUN_OTHER_SOUND_DISTANCE.get());
    }

    public static void playBoltSound(LivingEntity entity, ClientGunIndex gunIndex) {
        tmpSoundInstance = SoundPlayManager.playClientSound((Entity)entity, gunIndex.getSounds(SoundManager.BOLT_SOUND), 1.0f, 1.0f, (Integer)GunConfig.DEFAULT_GUN_OTHER_SOUND_DISTANCE.get());
    }

    public static void playDrawSound(LivingEntity entity, ClientGunIndex gunIndex) {
        tmpSoundInstance = SoundPlayManager.playClientSound((Entity)entity, gunIndex.getSounds(SoundManager.DRAW_SOUND), 1.0f, 1.0f, (Integer)GunConfig.DEFAULT_GUN_OTHER_SOUND_DISTANCE.get());
    }

    public static void playPutAwaySound(LivingEntity entity, ClientGunIndex gunIndex) {
        tmpSoundInstance = SoundPlayManager.playClientSound((Entity)entity, gunIndex.getSounds(SoundManager.PUT_AWAY_SOUND), 1.0f, 1.0f, (Integer)GunConfig.DEFAULT_GUN_OTHER_SOUND_DISTANCE.get());
    }

    public static void playFireSelectSound(LivingEntity entity, ClientGunIndex gunIndex) {
        SoundPlayManager.playClientSound((Entity)entity, gunIndex.getSounds(SoundManager.FIRE_SELECT), 1.0f, 1.0f, (Integer)GunConfig.DEFAULT_GUN_OTHER_SOUND_DISTANCE.get());
    }

    public static void playMeleeBayonetSound(LivingEntity entity, ClientGunIndex gunIndex) {
        SoundPlayManager.playClientSound((Entity)entity, gunIndex.getSounds(SoundManager.MELEE_BAYONET), 1.0f, 0.9f + entity.m_217043_().m_188501_() * 0.125f, (Integer)GunConfig.DEFAULT_GUN_OTHER_SOUND_DISTANCE.get());
    }

    public static void playMeleePushSound(LivingEntity entity, ClientGunIndex gunIndex) {
        SoundPlayManager.playClientSound((Entity)entity, gunIndex.getSounds(SoundManager.MELEE_PUSH), 1.0f, 0.9f + entity.m_217043_().m_188501_() * 0.125f, (Integer)GunConfig.DEFAULT_GUN_OTHER_SOUND_DISTANCE.get());
    }

    public static void playMeleeStockSound(LivingEntity entity, ClientGunIndex gunIndex) {
        SoundPlayManager.playClientSound((Entity)entity, gunIndex.getSounds(SoundManager.MELEE_STOCK), 1.0f, 0.9f + entity.m_217043_().m_188501_() * 0.125f, (Integer)GunConfig.DEFAULT_GUN_OTHER_SOUND_DISTANCE.get());
    }

    public static void playHeadHitSound(LivingEntity entity, ClientGunIndex gunIndex) {
        SoundPlayManager.playClientSound((Entity)entity, gunIndex.getSounds(SoundManager.HEAD_HIT_SOUND), 1.0f, 1.0f, (Integer)GunConfig.DEFAULT_GUN_OTHER_SOUND_DISTANCE.get());
    }

    public static void playFleshHitSound(LivingEntity entity, ClientGunIndex gunIndex) {
        SoundPlayManager.playClientSound((Entity)entity, gunIndex.getSounds(SoundManager.FLESH_HIT_SOUND), 1.0f, 1.0f, (Integer)GunConfig.DEFAULT_GUN_OTHER_SOUND_DISTANCE.get());
    }

    public static void playKillSound(LivingEntity entity, ClientGunIndex gunIndex) {
        SoundPlayManager.playClientSound((Entity)entity, gunIndex.getSounds(SoundManager.KILL_SOUND), 1.0f, 1.0f, (Integer)GunConfig.DEFAULT_GUN_OTHER_SOUND_DISTANCE.get());
    }

    public static void playMessageSound(ServerMessageSound message) {
        Entity entity;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null || !((entity = level.m_6815_(message.getEntityId())) instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        ResourceLocation gunId = message.getGunId();
        TimelessAPI.getClientGunIndex(gunId).ifPresent(index -> {
            ResourceLocation soundId = index.getSounds(message.getSoundName());
            if (soundId == null) {
                return;
            }
            SoundPlayManager.playClientSound((Entity)livingEntity, soundId, message.getVolume(), message.getPitch(), message.getDistance());
        });
    }
}

